---
generated_at: 2026-02-10 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **チャットメッセージAPIのパラメータ仕様**：APIHandler.tsとRestAPI.tsで定義が若干異なる
  2. **エクスポート可能なファイル形式**：設定依存のため実行環境確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/handler/RestAPI.ts` - REST API v2エンドポイント定義
- E-02: `src/node/handler/APIHandler.ts` - APIバージョン・関数マッピング
- E-03: `src/node/hooks/express/openapi.ts` - OpenAPI定義生成・レガシーAPI
- E-04: `src/node/hooks/express/apicalls.ts` - /api エンドポイント
- E-05: `src/node/hooks/express/importexport.ts` - インポート/エクスポートエンドポイント
- E-06: `src/node/hooks/express/specialpages.ts` - ヘルスチェック・統計エンドポイント
- E-07: `src/node/hooks/express/admin.ts` - 管理画面エンドポイント
- E-08: `src/node/security/OAuth2Provider.ts` - OAuth2/OIDC認証
- E-09: `src/node/hooks/express/webaccess.ts` - 認証・認可処理
- E-10: `src/node/db/API.ts` - API関数実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 最新APIバージョンは1.3.0 | E-02 (exports.latestApiVersion = '1.3.0') | ○ |
| C-02 | REST API v2は/api/2で提供 | E-01 (app.use('/api/2', ...)) | ○ |
| C-03 | API Key認証がサポートされている | E-02, E-08 | ○ |
| C-04 | OAuth 2.0/OpenID Connect認証がサポートされている | E-08 | ○ |
| C-05 | レスポンス形式はcode/message/dataの構造 | E-01 (defaultResponses定義) | ○ |
| C-06 | エラーコード0は成功を示す | E-01, E-03 | ○ |
| C-07 | エラーコード1は一般的なAPIエラー | E-01 | ○ |
| C-08 | エラーコード2は内部エラー | E-01 | ○ |
| C-09 | エラーコード3は関数が存在しないエラー | E-01, E-03 | ○ |
| C-10 | エラーコード4は認証エラー | E-01, E-02 | ○ |
| C-11 | POST /api/2/groupsでグループ作成 | E-01 | ○ |
| C-12 | GET /api/2/groupsで全グループ一覧取得 | E-01 (listAllGroups) | ○ |
| C-13 | DELETE /api/2/groupsでグループ削除 | E-01 | ○ |
| C-14 | POST /api/2/authorsで著者作成 | E-01 | ○ |
| C-15 | POST /api/2/sessionsでセッション作成 | E-01 | ○ |
| C-16 | GET /api/2/pads/textでテキスト取得 | E-01, E-10 | ○ |
| C-17 | POST /api/2/pads/textでテキスト設定 | E-01, E-10 | ○ |
| C-18 | PATCH /api/2/pads/textでテキスト追加 | E-01 (appendText) | ○ |
| C-19 | GET /api/2/pads/htmlでHTML取得 | E-01, E-10 | ○ |
| C-20 | POST /api/2/pads/htmlでHTML設定 | E-01, E-10 | ○ |
| C-21 | GET /api/2/pads/revisionsでリビジョン数取得 | E-01, E-10 | ○ |
| C-22 | GET /api/2/pads/readonlyで読み取り専用ID取得 | E-01, E-10 | ○ |
| C-23 | GET /api/2/pads/chatHistoryでチャット履歴取得 | E-01, E-10 | ○ |
| C-24 | PATCH /api/2/chats/messagesでチャットメッセージ追加 | E-01 | △ |
| C-25 | GET /api/2/statsで統計情報取得 | E-01, E-10 | ○ |
| C-26 | GET /api/2/checkTokenでトークン検証 | E-01, E-10 | ○ |
| C-27 | POST /api/2/pads/copypadでパッドコピー | E-01, E-10 | ○ |
| C-28 | POST /api/2/pads/movePadでパッド移動 | E-01, E-10 | ○ |
| C-29 | GET /healthでヘルスチェック | E-06 | ○ |
| C-30 | GET /statsで統計情報（設定依存） | E-06 (enableMetrics条件分岐) | ○ |
| C-31 | GET /stats/prometheusでPrometheus形式統計 | E-06 | ○ |
| C-32 | GET /p/:pad/export/:typeでエクスポート | E-05 | ○ |
| C-33 | POST /p/:pad/importでインポート | E-05 | ○ |
| C-34 | エクスポート形式にtxt,html,etherpadをサポート | E-05 (types配列) | ○ |
| C-35 | エクスポート形式にpdf,doc,odtはコンバーター必要 | E-05 (exportAvailable条件) | △ |
| C-36 | GET /admin/*で管理画面提供 | E-07 | ○ |
| C-37 | /oidc/*でOpenID Connect認証 | E-08 | ○ |
| C-38 | GET /api-docsでSwagger UI提供 | E-01 | ○ |
| C-39 | GET /api-docs.jsonでOpenAPI定義提供 | E-01 | ○ |
| C-40 | v1.3.0でauthorIdパラメータ追加 | E-02 (version['1.3.0']) | ○ |
| C-41 | v1.2.14でgetStats追加 | E-02 | ○ |
| C-42 | v1.2.9でcopyPad,movePad追加 | E-02 | ○ |
| C-43 | v1.2.7でcreateDiffHTML追加 | E-02 | ○ |
| C-44 | v1.1でlistAllGroups追加 | E-02 | ○ |
| C-45 | OpenAPI 3.0.2形式で定義 | E-03 (OPENAPI_VERSION = '3.0.2') | ○ |

## 4) 不足情報（Unknown / Missing）
- C-24: チャットメッセージ追加APIについて、RestAPI.ts（/chats/messages）とAPIHandler.ts（appendChatMessage）で定義箇所が異なり、実際のエンドポイントパスが一致するか実行確認が必要
  - 候補：RestAPI.tsの定義を優先 / APIHandler.tsのパラメータ定義を確認 / 統合テストで検証
- C-35: pdf/doc/odtエクスポートはAbiwordまたはLibreOfficeのインストールが必要だが、具体的な設定方法は別途ドキュメント参照が必要
  - 候補：settings.jsonのabiword/sofficeパス設定を確認 / 公式ドキュメント参照 / 運用環境での動作確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - APIバージョン履歴、基本的なエンドポイント定義（大部分）
- **1: 中リスク** - 認証方式の設定依存部分（API Key vs OAuth）、エクスポート形式の環境依存
- **1: 中リスク** - REST API v2とレガシーAPIの両方が存在することによる混乱の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] チャットメッセージAPI（C-24）の実際のエンドポイントパスを確認
- [ ] エクスポート機能の環境依存性についてドキュメントに注記追加を検討
- [ ] OAuth 2.0設定の具体例が必要かどうか確認
- [ ] REST API v2とレガシーAPI(/api/{version})の使い分けについてドキュメント追記を検討
- [ ] レート制限設定（importExportRateLimiting）の具体的な値をドキュメントに追記するか検討
