# Etherpad

## 概要

Etherpadは、Webベースのリアルタイム共同編集エディタです。数千人規模の同時接続に対応し、複数のユーザーが同時にドキュメントを編集できます。オープンソース（Apache License v2）で提供され、自己ホスト環境で動作させることができます。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| リアルタイム共同編集 | Easysyncライブラリを使用した複数ユーザーによる同時編集機能 |
| プラグインシステム | 拡張機能をプラグインとして追加可能（フォント色、コメント、マークダウン、見出し等） |
| データエクスポート | 完全なデータエクスポート機能（DOC/PDF/ODT形式対応にはAbiWordまたはLibreOfficeが必要） |
| 認証システム | OpenID Connect対応のユーザー認証機能 |
| 管理画面 | プラグイン管理・設定変更用のWebベース管理インターフェース |
| 多言語対応 | 105言語以上のローカライゼーション対応（TranslateWiki連携） |
| スキンカスタマイズ | スキンバリアント機能によるUIのカスタマイズ |
| HTTP API | パッド・ユーザー・グループ管理のためのREST API（OpenAPI対応） |
| メトリクス | Prometheus対応のメトリクス収集機能 |
| Docker対応 | Docker/Docker Composeによるコンテナ化デプロイ |

## 技術スタック

### コア

- フレームワーク: Express 5.x（Node.js）
- 言語: TypeScript / JavaScript
- ランタイム: Node.js >= 18.18.2
- パッケージマネージャー: pnpm >= 8.3.0
- リアルタイム通信: Socket.IO 4.x
- データベース: UeberDB2（DirtyDB, MySQL, PostgreSQL, MongoDB等対応）
- テンプレートエンジン: EJS

### 主要ライブラリ

- `socket.io` - WebSocketによるリアルタイム通信
- `ueberdb2` - 複数データベース対応の抽象化レイヤー
- `express-rate-limit` - APIレート制限
- `log4js` - ロギング
- `prom-client` - Prometheusメトリクス
- `jose` / `jsonwebtoken` - JWT認証
- `oidc-provider` - OpenID Connect認証
- `openapi-backend` - OpenAPI仕様に基づくAPIバックエンド
- `live-plugin-manager` - ランタイムプラグイン管理

### フロントエンド（管理画面）

- React 19.x
- Vite (Rolldown)
- React Router
- Zustand（状態管理）
- i18next（国際化）
- Lucide React（アイコン）
- Radix UI（UIコンポーネント）

## ディレクトリ構成

```
etherpad-lite/
├── src/                    # メインアプリケーションソース
│   ├── node/               # サーバーサイドコード
│   │   ├── db/             # データベースアクセス層
│   │   ├── handler/        # HTTPハンドラー
│   │   ├── hooks/          # プラグインフック
│   │   ├── security/       # セキュリティ関連
│   │   ├── types/          # TypeScript型定義
│   │   ├── utils/          # ユーティリティ関数
│   │   └── server.ts       # サーバーエントリーポイント
│   ├── static/             # 静的ファイル
│   ├── templates/          # HTMLテンプレート
│   ├── locales/            # 多言語リソース
│   └── tests/              # テストコード
├── admin/                  # 管理画面（React）
│   ├── src/                # Reactコンポーネント
│   └── public/             # 静的アセット
├── ui/                     # OIDCログインUI
├── bin/                    # CLIツール・スクリプト
│   ├── plugins/            # プラグイン管理ツール
│   ├── run.sh              # 起動スクリプト
│   ├── installDeps.sh      # 依存関係インストール
│   └── *.ts                # 各種管理スクリプト
├── doc/                    # ドキュメント
├── local_plugins/          # ローカルプラグイン配置ディレクトリ
├── var/                    # 実行時データ
├── settings.json.template  # 設定ファイルテンプレート
├── docker-compose.yml      # Docker Compose設定
└── Dockerfile              # Dockerイメージ定義
```

## セットアップ

### 必要条件

- Node.js >= 18.18.2（推奨: 20.x以上）
- pnpm >= 8.3.0
- npm >= 6.14.0

### インストール手順

#### ローカル環境（Windows/macOS/Linux）

```bash
# 1. リポジトリをクローン
git clone https://github.com/ether/etherpad-lite.git
cd etherpad-lite

# 2. pnpmをインストール
npm install -g pnpm

# 3. 依存関係をインストール
pnpm install

# 4. フロントエンドをビルド
pnpm run build:etherpad

# 5. 本番モードで起動
pnpm run prod

# ブラウザで http://localhost:9001 にアクセス
```

#### Docker環境

```bash
# Docker Composeで起動
docker-compose up -d

# ブラウザで http://localhost:9001 にアクセス
```

### 設定

- `settings.json.template` をコピーして `settings.json` を作成
- 環境変数による設定も可能（`${ENV_VAR}` または `${ENV_VAR:default_value}` 形式）
- 本番環境では DirtyDB の代わりに MySQL/PostgreSQL などを使用推奨

## 開発

### 開発サーバー起動

```bash
pnpm run dev
```

### コードチェック

```bash
# ESLintによるリント
pnpm run lint

# TypeScript型チェック
pnpm run ts-check

# 型チェック（ウォッチモード）
pnpm run ts-check:watch
```

### テスト

```bash
# バックエンドテスト実行
pnpm run test

# ユーティリティテスト
pnpm run test-utils

# UIテスト（Playwright）
pnpm run test-ui

# 管理画面テスト
pnpm run test-admin
```

### プラグイン管理

```bash
# プラグインをインストール
pnpm run plugins i ep_plugin_name

# プラグイン一覧
pnpm run list-plugins

# プラグインを削除
pnpm run remove-plugins ep_plugin_name
```

### デバッグ

```bash
# デバッグモードで起動
./bin/debugRun.sh

# 高速起動（依存関係更新スキップ）
./bin/fastRun.sh
```
