---
generated_at: 2026-02-10 12:55:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **多言語対応数「105言語以上」**：README.mdからの引用だが、localesディレクトリの実数は未検証
  2. **翻訳カバー率「98%」**：README.mdのバッジ情報からの引用、動的データのため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json`（ルート）
- E-02: `src/package.json`
- E-03: `admin/package.json`
- E-04: `ui/package.json`
- E-05: `README.md`（ルート）
- E-06: `Dockerfile`
- E-07: `settings.json.template`
- E-08: `src/node/` ディレクトリ構成
- E-09: `bin/` ディレクトリ構成
- E-10: `docker-compose.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクト名はEtherpad | E-01, E-02 | ○ |
| C-02 | リアルタイム共同編集エディタ | E-01, E-05 | ○ |
| C-03 | Apache License v2 | E-01, E-02 | ○ |
| C-04 | Node.js >= 18.18.2 | E-02 | ○ |
| C-05 | pnpm >= 8.3.0 | E-02 | ○ |
| C-06 | Express 5.x使用 | E-02（express: ^5.2.1） | ○ |
| C-07 | Socket.IO 4.x使用 | E-02（socket.io: ^4.8.3） | ○ |
| C-08 | TypeScript使用 | E-02, E-03（devDependencies） | ○ |
| C-09 | UeberDB2使用 | E-02（ueberdb2: ^5.0.23） | ○ |
| C-10 | React 19.x（admin） | E-03（react: ^19.2.4） | ○ |
| C-11 | Vite使用 | E-03, E-04 | ○ |
| C-12 | Zustand状態管理 | E-03（zustand: ^5.0.11） | ○ |
| C-13 | i18next国際化 | E-03（i18next: ^25.8.1） | ○ |
| C-14 | Radix UI使用 | E-03 | ○ |
| C-15 | Prometheus対応 | E-02（prom-client: ^15.1.3） | ○ |
| C-16 | OpenID Connect対応 | E-02（oidc-provider: 9.6.0） | ○ |
| C-17 | OpenAPI対応 | E-02（openapi-backend: ^5.15.0） | ○ |
| C-18 | EJSテンプレート | E-02（ejs: ^4.0.1） | ○ |
| C-19 | log4jsロギング | E-02（log4js: ^6.9.1） | ○ |
| C-20 | JWTトークン認証 | E-02（jose, jsonwebtoken） | ○ |
| C-21 | Playwrightテスト | E-02（@playwright/test） | ○ |
| C-22 | Mochaテスト | E-02（mocha: ^11.7.5） | ○ |
| C-23 | ディレクトリ構成（src/node） | E-08 | ○ |
| C-24 | ディレクトリ構成（bin） | E-09 | ○ |
| C-25 | Docker対応 | E-06, E-10 | ○ |
| C-26 | pnpm runスクリプト | E-01, E-02 | ○ |
| C-27 | ポート9001 | E-05, E-06 | ○ |
| C-28 | 数千人同時接続対応 | E-05 | ○ |
| C-29 | プラグインシステム | E-05, E-09 | ○ |
| C-30 | 環境変数設定対応 | E-07 | ○ |
| C-31 | 105言語以上対応 | E-05 | △ |
| C-32 | 翻訳カバー率98% | E-05 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-31, C-32（多言語対応の詳細数値）**
  - README.mdに記載されているバッジ情報からの引用
  - localesディレクトリには116ファイル存在するが、言語数と完全な対応関係は未検証
  - 候補：localesディレクトリの詳細解析 / TranslateWiki連携情報の確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な技術スタック情報はpackage.jsonから直接取得しており信頼性が高い
- 0: 低リスク - ディレクトリ構成は実際のファイルシステムから確認済み
- 1: 中リスク - 多言語対応の数値はバッジ情報依存のため、最新状態との乖離の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 記載されているNode.jsバージョン要件が現在の開発環境と一致しているか
- [ ] pnpm runコマンドが実際に動作するか
- [ ] Docker環境での起動が問題なく行えるか
- [ ] 多言語対応の数値（105言語、98%カバー）が最新情報と一致しているか
