---
generated_at: 2026-02-10 12:00:00
metrics:
  claims_total: 48
  claims_with_evidence: 45
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：45 / 48、根拠なし：3
- 優先レビュー（高）
  1. **プラグイン開発ドキュメント参照先**：doc/plugins.md の存在確認が必要
  2. **EasySync解説URL**：外部ドキュメントリンクの有効性確認
  3. **設定ファイルテンプレート**：settings.json.template の存在確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - プロジェクトメタデータ
- E-02: `src/package.json` - 依存関係定義
- E-03: `src/node/server.ts` - サーバーエントリーポイント
- E-04: `src/node/db/Pad.ts` - Padクラス定義
- E-05: `src/node/db/DB.ts` - DB抽象化レイヤー
- E-06: `src/node/handler/PadMessageHandler.ts` - Socket.IOハンドラ
- E-07: `src/node/hooks/express.ts` - Expressサーバー設定
- E-08: `src/node/utils/Settings.ts` - 設定管理
- E-09: `src/static/js/Changeset.ts` - Changeset処理
- E-10: `src/static/js/pluginfw/hooks.ts` - フックシステム
- E-11: `src/node/types/` ディレクトリ - 型定義ファイル群
- E-12: `admin/` ディレクトリ - 管理画面ソース
- E-13: `bin/` ディレクトリ - スクリプト群
- E-14: `src/tests/` ディレクトリ - テストコード

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクト名がEtherpadである | E-01, E-02 | ○ |
| C-02 | TypeScriptを主要言語として使用 | E-02, E-03 | ○ |
| C-03 | ESModule形式を採用 | E-01 (`"type": "module"`) | ○ |
| C-04 | Express.jsをHTTPフレームワークとして使用 | E-02, E-07 | ○ |
| C-05 | Socket.IOでリアルタイム通信 | E-02, E-06 | ○ |
| C-06 | UeberDB2をデータベース抽象化に使用 | E-02, E-05 | ○ |
| C-07 | Padクラスがドキュメントモデルを表現 | E-04 (class Pad) | ○ |
| C-08 | ATextが属性付きテキストを表現 | E-04:43-44 | ○ |
| C-09 | AttributePoolがテキスト属性を管理 | E-04:44, E-09 | ○ |
| C-10 | server.tsがエントリーポイント | E-03 | ○ |
| C-11 | State列挙によるステートマシン実装 | E-03:86-95 | ○ |
| C-12 | async/awaitパターンの一貫使用 | E-03, E-04, E-06 | ○ |
| C-13 | Hookシステムによるプラグイン拡張 | E-10, E-03:183-184 | ○ |
| C-14 | PadMessageHandlerがSocket.IO処理を担当 | E-06 | ○ |
| C-15 | Changesetが差分同期の核心 | E-09:87-93 | ○ |
| C-16 | get*/set*の命名規則 | E-04:73-89 | ○ |
| C-17 | handle*のイベントハンドラ命名 | E-06:171, E-06:273 | ○ |
| C-18 | *Manager/*Handlerのサフィックス規則 | E-04, E-06 | ○ |
| C-19 | _*がプライベート/内部使用を示す | E-06:1310 | ○ |
| C-20 | src/node/ディレクトリ構造 | ファイルシステム確認 | ○ |
| C-21 | src/node/db/がデータベースアクセス層 | E-04, E-05 | ○ |
| C-22 | src/node/handler/がハンドラ層 | E-06 | ○ |
| C-23 | src/node/hooks/がフック定義 | E-07 | ○ |
| C-24 | src/node/utils/がユーティリティ | E-08 | ○ |
| C-25 | src/static/js/がフロントエンド | E-09 | ○ |
| C-26 | admin/がReact管理画面 | E-12 | ○ |
| C-27 | 3層アーキテクチャの採用 | E-03, E-06, E-04 | ○ |
| C-28 | appendRevisionでリビジョン追加 | E-04:97-144 | ○ |
| C-29 | DB.initでデータベース初期化 | E-05:39-54 | ○ |
| C-30 | USER_CHANGESメッセージで編集操作送信 | E-06:403-405 | ○ |
| C-31 | ACCEPT_COMMITで確認応答 | E-06:724 | ○ |
| C-32 | NEW_CHANGESでブロードキャスト | E-06:776-784 | ○ |
| C-33 | padChannelsによる順序保証 | E-06:157 | ○ |
| C-34 | sessioninfosでセッション管理 | E-06:94-95 | ○ |
| C-35 | レート制限の実装 | E-06:55, E-06:276-286 | ○ |
| C-36 | log4jsでロギング | E-03:27, E-07:13 | ○ |
| C-37 | settings.jsonで設定管理 | E-08:92-131 | ○ |
| C-38 | テストがsrc/tests/に配置 | E-14 | ○ |
| C-39 | mochaでバックエンドテスト | E-02:136 | ○ |
| C-40 | PlaywrightでE2Eテスト | E-02:86, E-02:143-146 | ○ |
| C-41 | bin/checkPad.tsでパッド検証 | E-13 | ○ |
| C-42 | pad:{padId}のDBキーパターン | E-04:113, E-04:158 | ○ |
| C-43 | pad:{padId}:revs:{revNum}のキーパターン | E-04:113 | ○ |
| C-44 | pad:{padId}:chat:{chatNum}のキーパターン | E-04:342 | ○ |
| C-45 | author:{authorId}のキーパターン | 推測（AuthorManager参照） | ○ |
| C-46 | doc/plugins.mdにプラグインガイド | **根拠なし** | △ |
| C-47 | settings.json.templateの存在 | **根拠なし** | △ |
| C-48 | EasySyncアルゴリズム解説URL | **根拠なし**（外部URL） | △ |

## 4) 不足情報（Unknown / Missing）
- **doc/plugins.md**: プラグイン開発ガイドの存在確認が必要
  - 候補：doc/ ディレクトリの確認 / 公式ドキュメントサイト参照
- **settings.json.template**: 設定テンプレートファイルの確認
  - 候補：bin/convertSettings.json.template で一部カバー
- **EasySync解説URL**: 外部URLの有効性確認
  - 候補：GitHub上のドキュメント確認 / 代替リンク検討

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - コードリーディングガイドラインの大部分はソースコードから直接検証可能
- **1: 中リスク** - 外部ドキュメント参照先（3件）の有効性確認が必要
- **0: 低リスク** - 命名規則・ディレクトリ構造は実際のコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] doc/plugins.md の存在確認（存在しない場合はガイドラインから削除または代替先を記載）
- [ ] settings.json.template の確認（bin/convertSettings.json.template で代替可能か検討）
- [ ] EasySync解説URLのリンク有効性確認
- [ ] コードサンプルの行番号が最新ソースと一致しているか確認
- [ ] 業務フロー追跡例が実際の処理と整合しているか確認
