---
generated_at: 2026-02-10 12:55:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **C-41 トランザクション分離レベル**：DBドライバー依存のため詳細未確認
  2. **C-42 キャッシュTTL設定**：具体的なデフォルト値の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `package.json` - ルートパッケージ定義
- E-02: `src/package.json` - ep_etherpad-lite パッケージ定義（依存関係）
- E-03: `src/node/server.ts` - サーバーエントリーポイント
- E-04: `src/node/db/DB.ts` - データベース初期化・接続
- E-05: `src/node/db/Pad.ts` - パッドドメインモデル
- E-06: `src/node/db/API.ts` - REST API実装
- E-07: `src/node/handler/PadMessageHandler.ts` - Socket.IOメッセージハンドラー
- E-08: `src/node/handler/SocketIORouter.ts` - Socket.IOルーター
- E-09: `src/node/hooks/express.ts` - Expressサーバー設定
- E-10: `src/node/hooks/express/webaccess.ts` - 認証・認可ミドルウェア
- E-11: `src/ep.json` - プラグインフック定義
- E-12: `settings.json.template` - 設定ファイルテンプレート
- E-13: `Dockerfile` - Dockerビルド設定
- E-14: `admin/package.json` - 管理画面パッケージ定義
- E-15: `ui/package.json` - OIDC UIパッケージ定義
- E-16: `pnpm-workspace.yaml` - pnpmワークスペース設定

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Etherpad Liteはバージョン2.6.1である | E-01, E-02 | ○ |
| C-02 | Node.js上で動作するサーバーサイドアプリケーション | E-03 | ○ |
| C-03 | ueberdb2を使用したデータベース抽象化層 | E-02, E-04 | ○ |
| C-04 | dirty、MySQL、PostgreSQL、SQLite等に対応 | E-12 | ○ |
| C-05 | Abiwordによるドキュメント変換サポート | E-12, E-13 | ○ |
| C-06 | LibreOfficeによるドキュメント変換サポート | E-12, E-13 | ○ |
| C-07 | Socket.IOによるリアルタイム通信 | E-02, E-07 | ○ |
| C-08 | OAuth2/OIDCによる認証連携 | E-11, E-12 | ○ |
| C-09 | モジュラー・レイヤードアーキテクチャを採用 | E-03, ディレクトリ構造 | ○ |
| C-10 | フックベースプラグインシステム | E-11 | ○ |
| C-11 | Presentation層にadmin/, ui/, templates/, static/js/が存在 | E-14, E-15, ディレクトリ構造 | ○ |
| C-12 | Handler層にPadMessageHandler, SocketIORouter等が存在 | E-07, E-08 | ○ |
| C-13 | Domain層にPad, AuthorManager, SessionManager等が存在 | E-05, E-06 | ○ |
| C-14 | Infrastructure層にDB.ts, ueberdb2が存在 | E-04 | ○ |
| C-15 | Security層にwebaccess.ts, OAuth2Provider.tsが存在 | E-10, E-11 | ○ |
| C-16 | パッドはChangesetアルゴリズムで管理される | E-05, E-07 | ○ |
| C-17 | Channelsクラスでパッドごとにシリアライズ処理 | E-07 | ○ |
| C-18 | Express 5.2.1を使用 | E-02 | ○ |
| C-19 | Socket.IO 4.8.3を使用 | E-02 | ○ |
| C-20 | express-session 1.19.0を使用 | E-02 | ○ |
| C-21 | express-rate-limit 8.2.1を使用 | E-02 | ○ |
| C-22 | rate-limiter-flexible 9.1.0を使用 | E-02, E-07 | ○ |
| C-23 | log4js 6.9.1を使用 | E-02 | ○ |
| C-24 | prom-client 15.1.3を使用 | E-02 | ○ |
| C-25 | oidc-provider 9.6.0を使用 | E-02 | ○ |
| C-26 | lru-cache 11.2.5を使用 | E-02 | ○ |
| C-27 | HTTPリクエストはExpressミドルウェアチェーンを通過 | E-09 | ○ |
| C-28 | CLIENT_READYメッセージで初期データ送信 | E-07 | ○ |
| C-29 | USER_CHANGESでChangeset受信・処理 | E-07 | ○ |
| C-30 | NEW_CHANGESで他クライアントにブロードキャスト | E-07 | ○ |
| C-31 | HTTP Basic認証をサポート | E-10 | ○ |
| C-32 | preAuthorize, authenticate, authorizeフックで認証拡張可能 | E-10 | ○ |
| C-33 | log4jsによるアプリケーションログ | E-07, E-09 | ○ |
| C-34 | prom-clientによるPrometheusメトリクス | E-02, E-03 | ○ |
| C-35 | 認証エラーは401を返す | E-10 | ○ |
| C-36 | 認可エラーは403を返す | E-10 | ○ |
| C-37 | TypeScriptを使用 | E-02, ファイル拡張子 | ○ |
| C-38 | ESLintを使用 | E-02 | ○ |
| C-39 | pnpmワークスペースによるモノレポ構成 | E-01, E-16 | ○ |
| C-40 | React + Viteで管理画面を構築 | E-14 | ○ |
| C-41 | トランザクション分離レベルはDBドライバー依存 | **根拠なし** | △ |
| C-42 | lru-cacheのTTLは設定可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-41 トランザクション分離レベル**
  - ueberdb2のトランザクション実装詳細がコードからは確認困難
  - 候補：ueberdb2ソースコード / 各DBドライバーのドキュメント / 実行時テスト

- **C-42 キャッシュTTL設定**
  - lru-cacheの具体的な使用箇所と設定値の確認が必要
  - 候補：PadManager.ts / settings.json詳細設定 / src/node/utils内のキャッシュ関連コード

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 全体的なアーキテクチャ記述 - ソースコードから直接確認可能
- **0（低リスク）**: 依存関係バージョン - package.jsonから正確に取得
- **0（低リスク）**: レイヤー構成 - ディレクトリ構造とコードから明確
- **1（中リスク）**: トランザクション管理詳細 - 実装詳細の確認が必要
- **1（中リスク）**: キャッシュ設定詳細 - 設定ファイルとコードの詳細確認が必要

## 6) レビュアーチェックリスト（最小）

- [ ] レイヤー定義がプロジェクトの実態と一致しているか確認
- [ ] 依存関係バージョンが最新のpackage.jsonと一致しているか確認
- [ ] プラグインフック一覧がep.jsonの内容を網羅しているか確認
- [ ] セキュリティ関連の記述（認証・認可）が実装と一致しているか確認
- [ ] トランザクション管理の記述がueberdb2の実際の動作と一致しているか確認
- [ ] lru-cacheの使用箇所とTTL設定を確認し、必要に応じて記述を更新
