---
generated_at: 2026-02-10 12:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **バックアップ頻度・保持期間**：コード内に明示的な設定なし
  2. **スケーリング時のリソース制限値**：推奨値として記載、実際の設定は未定義
  3. **監視ツール選定**：推奨として記載、プロジェクト固有の設定なし
  4. **高可用性構成の詳細**：現状シングル構成のため推奨事項として記載

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docker-compose.yml`
- E-02: `docker-compose.dev.yml`
- E-03: `Dockerfile`
- E-04: `.env.default`
- E-05: `.env.dev.default`
- E-06: `settings.json.docker`
- E-07: `src/tests/ratelimit/nginx.conf`
- E-08: `src/tests/ratelimit/Dockerfile.nginx`
- E-09: `src/tests/ratelimit/Dockerfile.anotherip`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Node.js LTS Alpine ベースのアプリケーション | E-03 (Dockerfile:10,18) | ○ |
| C-02 | PostgreSQL 15 Alpine をデータベースとして使用 | E-01:32, E-02:46 | ○ |
| C-03 | Etherpad はポート 9001 でリッスン | E-01:29, E-06:170 | ○ |
| C-04 | PostgreSQL はポート 5432 を使用 | E-01:37, E-06:254 | ○ |
| C-05 | pnpm 10.28.2 を使用 | E-03:8 | ○ |
| C-06 | 非 root ユーザー (UID: 5001) で実行 | E-03:89, E-01:3 | ○ |
| C-07 | restart: always ポリシーを設定 | E-01:27,39, E-02:41,55 | ○ |
| C-08 | ヘルスチェックは /health エンドポイント | E-03:190-191 | ○ |
| C-09 | ヘルスチェック間隔は 5秒 | E-03:190 | ○ |
| C-10 | docker volume: postgres_data | E-01:48 | ○ |
| C-11 | docker volume: plugins | E-01:49 | ○ |
| C-12 | docker volume: etherpad-var | E-01:50 | ○ |
| C-13 | NODE_ENV: production（本番） | E-01:13 | ○ |
| C-14 | NODE_ENV: development（開発） | E-02:27 | ○ |
| C-15 | TRUST_PROXY 設定が存在 | E-01:26, E-06:395 | ○ |
| C-16 | DISABLE_IP_LOGGING 設定が存在 | E-01:24, E-06:481 | ○ |
| C-17 | DB_TYPE は postgres | E-01:20 | ○ |
| C-18 | DB_CHARSET は utf8mb4 | E-01:15 | ○ |
| C-19 | メトリクスエンドポイント有効化設定 | E-06:185 | ○ |
| C-20 | SSO 認証方式をサポート | E-06:200, E-06:697-720 | ○ |
| C-21 | インポート/エクスポートのレート制限 | E-06:616-622 | ○ |
| C-22 | コミットのレート制限 | E-06:640-646 | ○ |
| C-23 | 最大インポートファイルサイズ 50MB | E-06:630 | ○ |
| C-24 | LibreOffice オプションインストール | E-03:77, E-06:366 | ○ |
| C-25 | AbiWord オプションインストール | E-03:69, E-06:358 | ○ |
| C-26 | Nginx によるリバースプロキシ対応 | E-07, E-08 | ○ |
| C-27 | WebSocket プロキシ設定 | E-07:17-19 | ○ |
| C-28 | 開発環境でソースマウント | E-02:21-22 | ○ |
| C-29 | マルチステージビルド構成 | E-03:10,18,127,131,136,157 | ○ |
| C-30 | 更新サーバー URL | E-06:231 | ○ |
| C-31 | Cookie セッション設定 | E-06:400-476 | ○ |
| C-32 | ログレベル設定（INFO/DEBUG/WARN/ERROR） | E-06:685 | ○ |
| C-33 | SSL 設定オプション | E-06:217-222 | ○ |
| C-34 | Socket.IO 設定 | E-06:573-584 | ○ |
| C-35 | 管理者パスワード環境変数 | E-01:14, E-04:14 | ○ |
| C-36 | デフォルトパッドテキスト設定 | E-01:23, E-06:267 | ○ |
| C-37 | プラグインインストール機能 | E-03:45-61, E-03:152-154 | ○ |
| C-38 | GitHub からのプラグイン取得 | E-03:59-61 | ○ |
| C-39 | バックアップ頻度・保持期間 | **根拠なし** | △ |
| C-40 | スケーリング時の推奨リソース値 | **根拠なし** | △ |
| C-41 | 推奨監視ツール（Prometheus + Grafana） | **根拠なし** | △ |
| C-42 | PostgreSQL レプリケーション設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **バックアップ設計の詳細**: プロジェクトコード内にバックアップスクリプトや設定ファイルが存在しない
  - 候補：運用ドキュメント / バックアップスクリプト / CI/CD 設定
- **スケーリング時のリソース制限**: docker-compose.yml に deploy.resources が未定義
  - 候補：本番用 docker-compose.prod.yml / Kubernetes マニフェスト
- **監視設定**: プロジェクト内に Prometheus/Grafana の設定ファイルなし
  - 候補：monitoring/ ディレクトリ / 外部監視システムドキュメント
- **高可用性構成**: シングルインスタンス構成のみ定義
  - 候補：Kubernetes 設定 / クラスタ構成ドキュメント

## 5) リスクフラグ（レビュー観点）

| フラグ | レベル | 説明 |
|---|---|---|
| 本番環境のデフォルトパスワード | 2 (高) | ADMIN_PASSWORD のデフォルト値が "admin" |
| バックアップ設計未定義 | 1 (中) | データ損失リスクへの対応が不明 |
| リソース制限未設定 | 1 (中) | コンテナリソース枯渇の可能性 |
| シングルポイント障害 | 1 (中) | DB がシングルインスタンス |

## 6) レビュアーチェックリスト（最小）

- [ ] ADMIN_PASSWORD が本番環境で変更されているか確認
- [ ] PostgreSQL の外部公開設定が無効であることを確認
- [ ] SSL/TLS 終端が適切に設定されているか確認
- [ ] バックアップ運用手順が別途定義されているか確認
- [ ] 監視・アラート設定が運用環境に実装されているか確認
- [ ] レート制限値が要件に適合しているか確認
- [ ] セッション設定（TTL、SameSite）が要件に適合しているか確認
