# インフラ構成図

## 全体構成図

```mermaid
flowchart TB
    subgraph Internet["インターネット"]
        User[("👤 ユーザー")]
    end

    subgraph LoadBalancer["ロードバランサー層（オプション）"]
        Nginx["🔀 Nginx<br/>リバースプロキシ<br/>Port: 80/443"]
    end

    subgraph AppLayer["アプリケーション層"]
        Etherpad["📝 Etherpad<br/>Node.js LTS Alpine<br/>Port: 9001"]
    end

    subgraph DataLayer["データ層"]
        PostgreSQL[("🐘 PostgreSQL 15<br/>Alpine<br/>Port: 5432")]
    end

    subgraph Storage["永続化ストレージ"]
        Vol1[("📁 postgres_data")]
        Vol2[("📁 plugins")]
        Vol3[("📁 etherpad-var")]
    end

    User -->|HTTPS| Nginx
    Nginx -->|HTTP/WebSocket| Etherpad
    User -.->|直接接続時| Etherpad
    Etherpad -->|TCP:5432| PostgreSQL
    PostgreSQL --> Vol1
    Etherpad --> Vol2
    Etherpad --> Vol3
```

## Docker Compose サービス構成図

```mermaid
flowchart LR
    subgraph DockerCompose["Docker Compose 環境"]
        subgraph AppService["app サービス"]
            EtherpadContainer["etherpad/etherpad:latest<br/>User: 5001:0<br/>Port: 9001"]
        end

        subgraph DBService["postgres サービス"]
            PostgresContainer["postgres:15-alpine<br/>Port: 5432"]
        end

        EtherpadContainer -->|depends_on| PostgresContainer
    end

    subgraph Volumes["Docker Volumes"]
        plugins["plugins"]
        etherpad_var["etherpad-var"]
        postgres_data["postgres_data"]
    end

    EtherpadContainer --> plugins
    EtherpadContainer --> etherpad_var
    PostgresContainer --> postgres_data

    Host["ホスト :9001"] --> EtherpadContainer
```

## コンテナ内部構成図

```mermaid
flowchart TB
    subgraph EtherpadContainer["Etherpad コンテナ"]
        subgraph Runtime["ランタイム"]
            Node["Node.js LTS"]
            pnpm["pnpm 10.28.2"]
        end

        subgraph App["アプリケーション"]
            EtherpadApp["Etherpad Lite<br/>/opt/etherpad-lite"]
            Settings["settings.json"]
            Plugins["プラグイン"]
        end

        subgraph Optional["オプション"]
            LibreOffice["LibreOffice"]
            AbiWord["AbiWord"]
        end

        Node --> EtherpadApp
        pnpm --> EtherpadApp
        Settings --> EtherpadApp
        Plugins --> EtherpadApp
        LibreOffice -.-> EtherpadApp
        AbiWord -.-> EtherpadApp
    end

    subgraph Ports["ポート"]
        Port9001["9001/tcp"]
    end

    EtherpadApp --> Port9001
```

## ネットワーク構成図

```mermaid
flowchart TB
    subgraph External["外部ネットワーク"]
        Internet["インターネット"]
    end

    subgraph HostNetwork["ホストネットワーク"]
        HostPort["ホストポート :9001"]
    end

    subgraph DockerNetwork["Docker ブリッジネットワーク"]
        subgraph AppNet["アプリケーションネットワーク"]
            Etherpad["Etherpad<br/>0.0.0.0:9001"]
            Postgres["PostgreSQL<br/>5432"]
        end
    end

    Internet --> HostPort
    HostPort --> Etherpad
    Etherpad -->|TCP| Postgres
```

## データフロー図

```mermaid
sequenceDiagram
    participant User as ユーザー
    participant Nginx as Nginx（オプション）
    participant Etherpad as Etherpad
    participant DB as PostgreSQL

    User->>Nginx: HTTPS リクエスト
    Nginx->>Etherpad: HTTP/WebSocket プロキシ

    alt パッド作成/編集
        Etherpad->>DB: INSERT/UPDATE パッドデータ
        DB-->>Etherpad: 確認
    end

    alt リアルタイム同期
        Etherpad-->>User: WebSocket 通信
        User-->>Etherpad: 編集操作
        Etherpad->>DB: 変更を永続化
    end

    Etherpad-->>Nginx: レスポンス
    Nginx-->>User: HTTPS レスポンス
```

## デプロイメントパイプライン図

```mermaid
flowchart LR
    subgraph Build["ビルドステージ"]
        AdminBuild["adminbuild<br/>UI ビルド"]
        Build1["build<br/>基盤構築"]
        BuildGit["build_git<br/>Git 情報取得"]
        BuildCopy["build_copy<br/>コピー"]
    end

    subgraph Target["ターゲット"]
        Development["development<br/>開発環境"]
        Production["production<br/>本番環境"]
    end

    AdminBuild --> Build1
    Build1 --> BuildGit
    Build1 --> BuildCopy
    BuildGit --> Development
    BuildGit --> Production
    BuildCopy --> Development
    BuildCopy --> Production
```

## 環境別構成比較

```mermaid
flowchart TB
    subgraph Production["本番環境"]
        ProdApp["Etherpad<br/>NODE_ENV=production<br/>イメージ: latest"]
        ProdDB["PostgreSQL"]
        ProdVol["Volume マウント"]

        ProdApp --> ProdDB
        ProdApp --> ProdVol
    end

    subgraph Development["開発環境"]
        DevApp["Etherpad<br/>NODE_ENV=development<br/>ローカルビルド"]
        DevDB["PostgreSQL"]
        DevSrc["ソースマウント<br/>./src, ./bin"]

        DevApp --> DevDB
        DevApp --> DevSrc
    end
```

## 外部サービス連携図

```mermaid
flowchart LR
    subgraph Internal["内部システム"]
        Etherpad["Etherpad"]
    end

    subgraph External["外部サービス"]
        UpdateServer["Etherpad Update Server<br/>etherpad.org/ep_infos"]
        npm["npm Registry<br/>npmjs.com"]
        GitHub["GitHub<br/>github.com"]
        SSO["SSO Provider<br/>OAuth2/OIDC"]
    end

    Etherpad -->|HTTPS| UpdateServer
    Etherpad -->|HTTPS| npm
    Etherpad -->|HTTPS| GitHub
    Etherpad <-->|OAuth2| SSO
```

## 監視・ヘルスチェック構成図

```mermaid
flowchart TB
    subgraph Monitoring["監視システム"]
        Prometheus["Prometheus"]
        Grafana["Grafana"]
    end

    subgraph Application["アプリケーション"]
        Health["/health エンドポイント"]
        Metrics["/metrics エンドポイント"]
    end

    subgraph Checks["ヘルスチェック"]
        DockerHealth["Docker HEALTHCHECK<br/>interval: 5s<br/>timeout: 3s"]
    end

    Prometheus -->|scrape| Metrics
    Prometheus --> Grafana
    DockerHealth -->|curl| Health
```
