# インフラ設計書

## 概要

本ドキュメントは、Etherpad Lite のインフラ構成について記載する。Etherpad Lite はリアルタイム共同編集機能を提供するWebアプリケーションであり、Docker コンテナベースのデプロイメントを標準構成として採用している。

## システム構成

### 全体構成

Etherpad Lite は以下のコンポーネントで構成される：

1. **アプリケーションサーバー（Etherpad）**: Node.js ベースの Web アプリケーション
2. **データベースサーバー（PostgreSQL）**: パッドデータおよびセッション情報の永続化
3. **リバースプロキシ（Nginx）**: 負荷分散、SSL終端、WebSocket プロキシ（オプション）

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| APサーバー（Etherpad） | リアルタイム共同編集エンジン、REST API提供 | Node.js LTS (Alpine Linux ベース)、UID: 5001 | 1台〜（スケール可能） |
| DBサーバー（PostgreSQL） | パッドデータ永続化、セッション管理 | PostgreSQL 15 (Alpine Linux ベース)、ポート: 5432 | 1台 |
| リバースプロキシ（Nginx） | SSL終端、WebSocketプロキシ、ロードバランシング | Nginx (公式イメージ) | オプション |

### ネットワーク構成

```
インターネット
      │
      ▼
[リバースプロキシ (Nginx)] ← オプション：SSL終端、WebSocket対応
      │ ポート: 80/443
      ▼
[Etherpad アプリケーション]
      │ ポート: 9001
      ▼
[PostgreSQL データベース]
        ポート: 5432 (内部のみ)
```

**ネットワーク設定:**
- Etherpad は `0.0.0.0:9001` でリッスン
- PostgreSQL はコンテナ間通信のみ（外部公開なし）
- Docker Compose によるサービス間ネットワーク分離

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Node.js | LTS (Alpine) | Etherpad アプリケーション実行環境 |
| PostgreSQL | 15-alpine | データ永続化 |
| pnpm | 10.28.2 | パッケージ管理 |
| Nginx | latest | リバースプロキシ（オプション） |
| LibreOffice | オプション | ドキュメント変換（DOC/PDF/ODT） |
| AbiWord | オプション | ドキュメント変換（軽量版） |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| Etherpad Update Server | プラグイン情報・更新確認 | HTTPS (https://etherpad.org/ep_infos) |
| SSO Provider | シングルサインオン認証 | OAuth2/OIDC |
| npm Registry | プラグインダウンロード | HTTPS |
| GitHub | プラグインソース取得 | HTTPS |

## スケーリング設計

### 水平スケーリング

Etherpad は以下の条件下で水平スケーリングが可能：

1. **ステートレス設計**: セッション情報はデータベースに保存
2. **共有データベース**: 複数インスタンスで同一 PostgreSQL を参照
3. **ロードバランサー**: Nginx または外部 LB によるトラフィック分散

### スケーリング制約

- WebSocket 接続のスティッキーセッションが必要
- データベースがボトルネックになる可能性あり

### コンテナリソース

Docker Compose では明示的なリソース制限は未設定（ホストリソースを共有）。本番環境では以下を推奨：

```yaml
deploy:
  resources:
    limits:
      cpus: '2.0'
      memory: 2G
    reservations:
      cpus: '0.5'
      memory: 512M
```

## 可用性設計

### 再起動ポリシー

- 全サービスに `restart: always` を設定
- コンテナ障害時の自動復旧

### ヘルスチェック

Dockerfile に定義されたヘルスチェック：

```dockerfile
HEALTHCHECK --interval=5s --timeout=3s \
  CMD curl --silent http://localhost:9001/health | grep -E "pass|ok|up" > /dev/null || exit 1
```

**エンドポイント:** `/health`
**チェック間隔:** 5秒
**タイムアウト:** 3秒

### 冗長構成

現在の Docker Compose 構成はシングルインスタンス。高可用性には以下を検討：

1. PostgreSQL のレプリケーション設定
2. 複数 Etherpad インスタンス + ロードバランサー
3. Kubernetes への移行

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| PostgreSQL データ | Docker Volume バックアップ / pg_dump | 日次推奨 | 要件に応じて設定 |
| プラグイン設定 | Docker Volume (plugins) | 設定変更時 | 世代管理推奨 |
| Etherpad 変数データ | Docker Volume (etherpad-var) | 日次推奨 | 要件に応じて設定 |

### Docker Volume 一覧

| Volume 名 | マウント先 | 用途 |
| --- | --- | --- |
| postgres_data | /var/lib/postgresql/data | PostgreSQL データ |
| plugins | /opt/etherpad-lite/src/plugin_packages | プラグイン |
| etherpad-var | /opt/etherpad-lite/var | Etherpad 変数データ（dirty.db 等） |

## 監視設計

### メトリクスエンドポイント

Etherpad は `/metrics` エンドポイントを提供（設定: `enableMetrics: true`）

**監視項目:**
- アプリケーションヘルス（/health）
- メトリクス（/metrics）
- コンテナリソース使用量
- データベース接続状態

### ログ設計

| コンポーネント | ログ出力 | ログレベル |
| --- | --- | --- |
| Etherpad | stdout/stderr | INFO（設定可能: DEBUG/WARN/ERROR） |
| PostgreSQL | /dev/fd/1, /dev/fd/2 | 標準 |
| Nginx | /dev/fd/1, /dev/fd/2 | access/error |

### 推奨監視ツール

- Prometheus + Grafana（メトリクス収集・可視化）
- Docker ログドライバー連携（ログ集約）

## セキュリティ設計

### コンテナセキュリティ

- 非 root ユーザー実行（UID: 5001, GID: 0）
- OpenShift 互換の権限設定
- Alpine Linux ベースによる攻撃面の最小化

### ネットワークセキュリティ

- PostgreSQL は外部公開なし（コンテナ間通信のみ）
- TRUST_PROXY 設定によるリバースプロキシ対応
- SSL 終端はリバースプロキシまたはネイティブ SSL で対応可能

### 認証・認可

- SSO（シングルサインオン）による認証
- 管理者/一般ユーザーのロール分離
- セッション Cookie の SameSite 属性設定

## 環境別構成

### 本番環境 (docker-compose.yml)

```yaml
services:
  app:
    image: etherpad/etherpad:latest
    environment:
      NODE_ENV: production
    ports:
      - "9001:9001"
    restart: always
```

### 開発環境 (docker-compose.dev.yml)

```yaml
services:
  app:
    build:
      target: development
    environment:
      NODE_ENV: development
      DISABLE_IP_LOGGING: true
    volumes:
      - ./src:/opt/etherpad-lite/src
      - ./bin:/opt/etherpad-lite/bin
```

**開発環境の特徴:**
- ソースコードのライブマウント
- IP ロギング無効化
- 開発用ビルドターゲット

## 環境変数一覧

### アプリケーション設定

| 変数名 | デフォルト値 | 説明 |
| --- | --- | --- |
| NODE_ENV | production | 実行環境 |
| ADMIN_PASSWORD | admin | 管理者パスワード |
| TRUST_PROXY | true | リバースプロキシ信頼設定 |
| DISABLE_IP_LOGGING | false | IP ロギング無効化 |

### データベース設定

| 変数名 | デフォルト値 | 説明 |
| --- | --- | --- |
| DB_TYPE | postgres | データベース種別 |
| DB_HOST | postgres | データベースホスト |
| DB_PORT | 5432 | データベースポート |
| DB_NAME | etherpad | データベース名 |
| DB_USER | admin | データベースユーザー |
| DB_PASS | admin | データベースパスワード |
| DB_CHARSET | utf8mb4 | 文字セット |

## 備考

### レート制限設定

- インポート/エクスポート: 90秒間に10リクエストまで
- コミット: 1秒間に10変更まで
- 最大インポートファイルサイズ: 50MB

### オプション機能

- LibreOffice/AbiWord によるドキュメント変換
- カスタムプラグインのインストール
- GitHub からのプラグイン取得

### 運用推奨事項

1. 本番環境では必ず ADMIN_PASSWORD を変更すること
2. PostgreSQL の外部公開は行わないこと
3. SSL 終端を必ず設定すること（直接 or リバースプロキシ）
4. 定期的なバックアップの実施
5. ログ監視とアラート設定の実装
