---
generated_at: 2026-02-10 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **CSP設定**：明示的な実装なし（未実装の確認）
  2. **パスワードハッシュ化**：デフォルト設定の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/hooks/express/webaccess.ts` - 認証ミドルウェア実装
- E-02: `src/node/db/SessionManager.ts` - セッション管理実装
- E-03: `src/node/hooks/express.ts` - Expressサーバー設定
- E-04: `src/node/db/SecurityManager.ts` - アクセス制御実装
- E-05: `src/node/security/SecretRotator.ts` - 秘密鍵ローテーション
- E-06: `src/node/security/OAuth2Provider.ts` - OAuth2/OIDC実装
- E-07: `src/node/security/crypto.ts` - 暗号化ユーティリティ
- E-08: `src/node/handler/APIKeyHandler.ts` - APIキー管理
- E-09: `src/node/handler/PadMessageHandler.ts` - レート制限実装
- E-10: `src/node/hooks/express/socketio.ts` - Socket.IO設定
- E-11: `src/node/utils/sanitizePathname.ts` - パス名サニタイズ
- E-12: `src/static/js/pad_utils.ts` - 入力検証（クライアント側）
- E-13: `src/node/db/PadManager.ts` - パッド管理・検証
- E-14: `settings.json.template` - 設定テンプレート
- E-15: `src/node/db/SessionStore.ts` - セッションストア実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OAuth2/OIDC (SSO) がデフォルト認証方式 | E-06, E-14 | ○ |
| C-02 | HTTPベーシック認証をサポート | E-01:161-172 | ○ |
| C-03 | APIキー認証は32文字ランダム文字列 | E-08:10-18 | ○ |
| C-04 | 認証フローは4ステップ | E-01:24-37, 77-229 | ○ |
| C-05 | ブルートフォース対策で1秒遅延 | E-01:188-189 | ○ |
| C-06 | プロトタイプ汚染対策実装 | E-01:167-170, 193-196 | ○ |
| C-07 | セッション有効期限は10日間（デフォルト） | E-14:441 | ○ |
| C-08 | セッションリフレッシュ間隔は1日間 | E-14:459 | ○ |
| C-09 | セッションIDは`s.`+16文字ランダム | E-02:144 | ○ |
| C-10 | SameSite属性はデフォルト`Lax` | E-14:415 | ○ |
| C-11 | 秘密鍵ローテーションを24時間ごとに実施 | E-05:66-262, E-14:402 | ○ |
| C-12 | HKDF-SHA256で鍵導出 | E-05:49-52 | ○ |
| C-13 | 権限は3レベル（admin, user, guest） | E-01:24-37, E-04 | ○ |
| C-14 | グループパッドは`$`を含むIDで識別 | E-04:128-150 | ○ |
| C-15 | 読み取り専用パッドは`r.`で始まる | E-04:68-75 | ○ |
| C-16 | プラグインフックによるアクセス制御拡張 | E-04:99-104, E-01 | ○ |
| C-17 | SSL/TLSをネイティブサポート | E-03:104-127, E-14:193-200 | ○ |
| C-18 | HSTSヘッダー送信（SSL有効時） | E-03:129-154 | ○ |
| C-19 | Referrer-Policyは`same-origin` | E-03:130-147 | ○ |
| C-20 | trustProxy設定でリバースプロキシ対応 | E-03:157-165, E-14:382 | ○ |
| C-21 | OAuth2トークンはRS256署名 | E-06:73-78 | ○ |
| C-22 | 環境変数による設定上書きをサポート | E-14:10-91 | ○ |
| C-23 | 著者トークンは`t.`+Base64url形式 | E-12:378-390 | ○ |
| C-24 | パッドテキストは100,000文字以下 | E-13:115-120 | ○ |
| C-25 | ディレクトリトラバーサル対策 | E-11:1-23 | ○ |
| C-26 | インポート/エクスポートレート制限 | E-14:602-608 | ○ |
| C-27 | コミットレート制限 | E-09:46, 70-73, E-14:639-645 | ○ |
| C-28 | Socket.IOバッファサイズ制限 | E-14:569 | ○ |
| C-29 | インポートファイルサイズ上限50MB | E-14:616 | ○ |
| C-30 | 認証ログにIPアドレス記録 | E-01:181, 208 | ○ |
| C-31 | IPログ記録を無効化可能 | E-14:465 | ○ |
| C-32 | ログレベル設定可能 | E-14:684 | ○ |
| C-33 | パスワード削除処理でセッションにパスワードを保存しない | E-01:198-201 | ○ |
| C-34 | セッション検証でRFC 6265準拠 | E-02:64 | ○ |
| C-35 | 有効期限検証で整数値のみサポート | E-02:119-141 | ○ |
| C-36 | OAuth2認可コード有効期限600秒 | E-14:729 | ○ |
| C-37 | OAuth2アクセストークン有効期限3600秒 | E-14:728 | ○ |
| C-38 | Socket.IOセッション更新 | E-10:94-105 | ○ |
| C-39 | 接続数管理（追跡・削除） | E-10:80-92 | ○ |
| C-40 | 開発環境警告出力 | E-03:90-96 | ○ |
| C-41 | ueberdb2によるDB抽象化 | E-14:217 | ○ |
| C-42 | credentials.jsonによる認証情報分離 | E-14:6-7 | ○ |
| C-43 | EP_hash_authプラグインによるハッシュ化推奨 | E-14:534-537 | ○ |
| C-44 | CSP (Content-Security-Policy) 未実装 | **根拠なし** | △ |
| C-45 | X-Frame-Optionsは埋め込みパッドのため未設定 | E-03:130コメント | ○ |

## 4) 不足情報（Unknown / Missing）
- **CSP設定の未実装確認**
  - ソースコード全体を検索したが、明示的なCSPヘッダー設定は見つからなかった
  - 候補：プラグインでのCSP実装 / Webサーバー（nginx等）での設定 / 今後の実装予定

- **CORS制限の詳細**
  - OAuth2Provider.tsでの広範なCORS許可は確認済み
  - OpenAPIでの「TODO: Don't allow CORS from everywhere」コメントあり

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 認証・認可機構、セッション管理、入力検証 - 実装が確認でき、標準的なセキュリティプラクティスに準拠
- **1 (中リスク)**: パスワード平文保存（デフォルト設定）、CORS制限の不足
- **2 (高リスク)**: CSP未実装 - XSS対策として追加実装を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] OAuth2/OIDC設定が本番環境に適切か確認
- [ ] `trustProxy`設定がインフラ構成と整合しているか確認
- [ ] セッション有効期限がセキュリティ要件を満たすか確認
- [ ] パスワードハッシュ化（ep_hash_auth）の導入状況を確認
- [ ] レート制限値が負荷要件と整合しているか確認
- [ ] CSPヘッダーの追加実装を検討
- [ ] 本番環境でのログレベル設定を確認
