---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **カバレッジ目標値**：明示的な設定ファイルが見つからず
  2. **不具合管理方法**：プロジェクト固有のドキュメントなし（一般的なGitHub運用を推測）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/package.json` - devDependencies、scripts定義
- E-02: `package.json` - ルートレベルのスクリプト定義
- E-03: `src/vitest.config.ts` - Vitest設定
- E-04: `src/playwright.config.ts` - Playwright設定
- E-05: `.github/workflows/backend-tests.yml` - バックエンドテストCI設定
- E-06: `.github/workflows/frontend-tests.yml` - フロントエンドテストCI設定
- E-07: `.github/workflows/frontend-admin-tests.yml` - 管理画面テストCI設定
- E-08: `.github/workflows/load-test.yml` - 負荷テストCI設定
- E-09: `.github/workflows/rate-limit.yml` - レートリミットテストCI設定
- E-10: `.github/workflows/codeql-analysis.yml` - CodeQL静的解析CI設定
- E-11: `.github/workflows/dependency-review.yml` - 依存関係レビューCI設定
- E-12: `.github/workflows/perform-type-check.yml` - 型チェックCI設定
- E-13: `src/tests/` ディレクトリ構成
- E-14: `src/tests/backend/specs/api/api.ts` - APIテストサンプル
- E-15: `src/tests/frontend-new/specs/bold.spec.ts` - Playwrightテストサンプル
- E-16: `src/tests/backend-new/specs/easysync-other.test.ts` - Vitestテストサンプル
- E-17: `src/tests/ratelimit/` ディレクトリ構成

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Mochaをバックエンドテストに使用（v11.7.5） | E-01 | ○ |
| C-02 | Vitestをバックエンド単体テストに使用（v4.0.18） | E-01, E-03, E-16 | ○ |
| C-03 | Playwrightを使用（v1.58.1） | E-01, E-04, E-15 | ○ |
| C-04 | Supertestを使用（v7.2.2） | E-01 | ○ |
| C-05 | Sinonを使用（v21.0.1） | E-01 | ○ |
| C-06 | TypeScript v5.9.3を使用 | E-01 | ○ |
| C-07 | ESLint v9.39.2を使用 | E-01 | ○ |
| C-08 | Node.js 20/22/24でテスト実行 | E-05, E-07 | ○ |
| C-09 | Linux/Windowsでテスト実行 | E-05 | ○ |
| C-10 | Chromium/Firefox/WebKitでE2Eテスト | E-04, E-06 | ○ |
| C-11 | backend-tests.ymlでバックエンドテスト | E-05 | ○ |
| C-12 | frontend-tests.ymlでフロントエンドテスト | E-06 | ○ |
| C-13 | frontend-admin-tests.ymlで管理画面テスト | E-07 | ○ |
| C-14 | load-test.ymlで負荷テスト | E-08 | ○ |
| C-15 | rate-limit.ymlでレートリミットテスト | E-09 | ○ |
| C-16 | codeql-analysis.ymlで静的解析 | E-10 | ○ |
| C-17 | dependency-review.ymlで依存関係レビュー | E-11 | ○ |
| C-18 | perform-type-check.ymlで型チェック | E-12 | ○ |
| C-19 | Playwright並列5ワーカー、リトライ2回 | E-04 | ○ |
| C-20 | テストタイムアウト90秒 | E-04 | ○ |
| C-21 | プラグインインストール後のテスト | E-05, E-08 | ○ |
| C-22 | Docker環境でレートリミットテスト | E-09, E-17 | ○ |
| C-23 | 負荷テスト25-5000ユーザー | E-08 | ○ |
| C-24 | Playwright Artifactを30日間保持 | E-06, E-07 | ○ |
| C-25 | テストディレクトリ構成 | E-13 | ○ |
| C-26 | pnpm testでMochaテスト実行 | E-01, E-02 | ○ |
| C-27 | カバレッジ目標が未設定 | **根拠なし** | △ |
| C-28 | GitHub Issuesで不具合管理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ設定ファイル**: `.nycrc`、`jest --coverage`、`vitest --coverage` 等の設定が見つからないため、カバレッジ目標が未設定と判断
  - 候補：`.nycrc` / `coverage` 設定 / CI設定内のカバレッジ収集
- **不具合管理ルール**: CONTRIBUTING.md等のプロジェクト固有の不具合管理ドキュメントが見つからず
  - 候補：CONTRIBUTING.md / ISSUE_TEMPLATE / プロジェクトWiki

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: テストツール・フレームワークの記載（package.jsonで確認可能）
- **0: 低リスク**: CI/CDワークフローの記載（.github/workflowsで確認可能）
- **1: 中リスク**: カバレッジ目標の記載（設定ファイル不在のため推測）
- **1: 中リスク**: 不具合管理方法（一般的なGitHub運用を推測）

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ収集設定の有無を確認（必要であれば追加を検討）
- [ ] 不具合管理のワークフローがプロジェクト内で別途定義されていないか確認
- [ ] テストプラグイン一覧が最新のCI設定と一致しているか確認
- [ ] Node.jsバージョン範囲が実際のCI設定と一致しているか確認
- [ ] 負荷テストのパラメータ（25-5000ユーザー）が実運用要件と整合しているか確認
