# テスト方針書

## 概要

本ドキュメントは、Etherpad（リアルタイム共同編集エディタ）プロジェクトにおけるテスト戦略、テスト環境、テストツール、およびCI/CD連携について定義します。プロジェクトはNode.js/TypeScriptベースのバックエンドと、ブラウザベースのフロントエンドで構成され、複数のテストレベルと種別を用いて品質を担保しています。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のモジュール・関数の動作検証（Changeset、AttributePool等のコアロジック） | 開発者 |
| 結合テスト | APIエンドポイント、WebSocket通信、データベース連携の検証 | 開発者 |
| システムテスト | E2Eテストによるユーザーシナリオ全体の検証（Playwrightによるブラウザ操作） | 開発者/QA |
| 受入テスト | 負荷テスト、レートリミットテスト、プラグイン互換性テスト | 開発者/QA |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | 各機能の正常動作確認（テキスト編集、チャット、認証等） | Push/PR時のCI実行 |
| 性能テスト | 負荷テスト（25-5000ユーザー同時接続シナリオ） | Push/PR時のCI実行 |
| セキュリティテスト | CodeQL静的解析、依存関係脆弱性レビュー、レートリミットテスト | Push/PR時・定期実行 |
| 互換性テスト | 複数Node.jsバージョン（20, 22, 24）およびOS（Linux/Windows）での動作確認 | Push/PR時のCI実行 |
| クロスブラウザテスト | Chromium、Firefox、WebKitでのフロントエンド動作確認 | Push時のCI実行 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者による単体・結合テスト実行 | Node.js >= 20.0.0、pnpm |
| GitHub Actions (Linux) | CI/CDパイプラインでのテスト自動実行 | ubuntu-latest、Node.js 20/22/24 |
| GitHub Actions (Windows) | Windows環境での互換性テスト | windows-latest、Node.js 20/22/24 |
| Docker環境 | レートリミットテスト、コンテナテスト | Docker、nginx、カスタムネットワーク |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| Mocha | バックエンド単体・結合テストフレームワーク | ^11.7.5 |
| Vitest | バックエンド単体テストフレームワーク（新規テスト用） | ^4.0.18 |
| Playwright | E2Eテスト・フロントエンドテストフレームワーク | ^1.58.1 |
| Supertest | HTTPリクエストテスト | ^7.2.2 |
| Sinon | モック・スタブ・スパイ | ^21.0.1 |
| etherpad-load-test-socket-io | 負荷テストツール | 最新（npm global） |
| CodeQL | セキュリティ静的解析 | GitHub Actions v4 |
| TypeScript | 型チェック | ^5.9.3 |
| ESLint | コード品質チェック | ^9.39.2 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な目標値なし（現在未設定） |
| 分岐カバレッジ | 明示的な目標値なし（現在未設定） |

※ 現時点でカバレッジ収集の設定は確認されていません。

## テストデータ

### テストデータの準備方針

- **動的生成**: テスト実行時にランダムなPad ID、ユーザー名等を動的生成
- **テスト用設定ファイル**: `src/tests/settings.json` にテスト専用設定を配置
- **フィクスチャ**: `favicon-test-custom.png`、`favicon-test-skin.png` 等のテスト用アセット
- **モック/スタブ**: Sinonを使用したモック・スタブによる外部依存の制御

## 不具合管理

### 不具合の管理方法

- **GitHub Issues**: 不具合報告および追跡
- **Pull Request**: 不具合修正のコードレビュー
- **CI/CDによる自動検出**: テスト失敗時に自動的にPRマージをブロック
- **Playwright Report**: E2Eテスト失敗時のスクリーンショット・動画をArtifactとして保存（30日間保持）

## CI/CD連携

### GitHub Actions ワークフロー一覧

| ワークフロー | トリガー | 目的 |
| --- | --- | --- |
| backend-tests.yml | push, pull_request | バックエンドテスト（Mocha, Vitest） |
| frontend-tests.yml | push | Playwrightフロントエンドテスト（Chrome, Firefox, WebKit） |
| frontend-admin-tests.yml | push | 管理画面のフロントエンドテスト |
| load-test.yml | push, pull_request | 負荷テスト（25-5000ユーザー） |
| rate-limit.yml | push, pull_request | レートリミット機能テスト（Docker環境） |
| codeql-analysis.yml | push, pull_request, schedule | セキュリティ静的解析（毎週月曜13:00 UTC） |
| dependency-review.yml | pull_request | 依存関係の脆弱性レビュー |
| perform-type-check.yml | push, pull_request | TypeScript型チェック |

### テスト実行マトリクス

```
バックエンドテスト:
  OS: [Linux, Windows]
  Node.js: [20, 22, 24]
  プラグイン: [without plugins, with plugins]

フロントエンドテスト:
  OS: Linux (ubuntu-latest)
  ブラウザ: [Chromium, Firefox, WebKit]
```

### Playwrightテスト設定

- **並列実行**: 5ワーカー、完全並列モード
- **リトライ**: 2回
- **タイムアウト**: 90秒（テスト）、20秒/5秒（アサーション、CI/ローカル）
- **レポート**: CI環境では `github` 形式、ローカルでは `html` 形式
- **トレース/動画**: 初回リトライ時に収集

### テストコマンド

| コマンド | 説明 |
| --- | --- |
| `pnpm test` | Mochaバックエンドテスト実行 |
| `pnpm test:vitest` | Vitestバックエンドテスト実行 |
| `pnpm test-ui` | Playwrightフロントエンドテスト実行 |
| `pnpm test-admin` | Playwright管理画面テスト実行（シングルワーカー） |
| `pnpm ts-check` | TypeScript型チェック |
| `pnpm lint` | ESLintコード品質チェック |

## 備考

### テストディレクトリ構成

```
src/tests/
├── backend/           # Mochaバックエンドテスト
│   ├── common.ts      # テストユーティリティ
│   └── specs/         # テストケース
│       └── api/       # APIテスト
├── backend-new/       # Vitestバックエンドテスト
│   └── specs/         # テストケース
├── frontend/          # レガシーフロントエンドテスト
│   ├── helper.js      # ヘルパー関数
│   └── specs/         # テストケース
├── frontend-new/      # Playwrightフロントエンドテスト
│   ├── admin-spec/    # 管理画面テスト
│   ├── helper/        # ヘルパー関数
│   └── specs/         # テストケース
├── container/         # コンテナテスト
└── ratelimit/         # レートリミットテスト
```

### テスト対象プラグイン

CI/CDパイプラインでは以下のプラグインがインストールされた状態でもテストが実行されます：

- ep_align
- ep_author_hover
- ep_cursortrace
- ep_font_size
- ep_hash_auth
- ep_headings2
- ep_markdown
- ep_readonly_guest
- ep_set_title_on_pad
- ep_spellcheck
- ep_subscript_and_superscript
- ep_table_of_contents

### 依存ツール

- **LibreOffice**: バックエンドテストでのインポート/エクスポート機能テストに使用（Linux環境）
