# ER図

## 概要

本ドキュメントは、Etherpad-liteのデータベース構造をER図として表現したものです。Etherpadはキーバリュー型データベースを使用しているため、厳密なリレーショナル構造ではありませんが、論理的なエンティティ間の関係を可視化しています。

## エンティティ関連図

```mermaid
erDiagram
    Groups ||--o{ Group : contains
    Group ||--o{ Pad : contains
    Group ||--o{ GroupSessions : has
    Group }o--|| GroupMapping : "mapped by"

    Pad ||--o{ Revision : has
    Pad ||--o{ ChatMessage : has
    Pad ||--|| ReadOnlyMapping : "has readonly id"

    Author ||--o{ Pad : "contributes to"
    Author ||--o{ AuthorSessions : has
    Author }o--|| TokenMapping : "mapped by token"
    Author }o--|| AuthorMapping : "mapped by mapper"

    Session }o--|| Author : "belongs to"
    Session }o--|| Group : "belongs to"
    AuthorSessions ||--o{ Session : references
    GroupSessions ||--o{ Session : references

    Groups {
        object groupIDs "グループID一覧（キー:値=1）"
    }

    Group {
        string groupID PK "グループID（g.xxxx形式）"
        object pads "所属パッドのID一覧"
        object mappings "外部マッパー一覧"
    }

    Pad {
        string padID PK "パッドID"
        object atext "属性付きテキスト"
        object pool "属性プール"
        number head "最新リビジョン番号"
        number chatHead "最新チャット番号"
        boolean publicStatus "公開状態"
        array savedRevisions "保存リビジョン"
    }

    Revision {
        string padID FK "パッドID"
        number revNum PK "リビジョン番号"
        string changeset "変更セット"
        string author "著者ID"
        number timestamp "作成日時"
        object pool "属性プール（キーリビジョンのみ）"
        object atext "属性テキスト（キーリビジョンのみ）"
    }

    ChatMessage {
        string padID FK "パッドID"
        number chatNum PK "チャット番号"
        string text "メッセージ本文"
        string authorId "著者ID"
        number time "送信日時"
    }

    Author {
        string authorID PK "著者ID（a.xxxx形式）"
        string name "表示名"
        number colorId "色ID"
        number timestamp "最終活動日時"
        object padIDs "貢献パッドID一覧"
    }

    Session {
        string sessionID PK "セッションID（s.xxxx形式）"
        string groupID FK "グループID"
        string authorID FK "著者ID"
        number validUntil "有効期限"
    }

    AuthorSessions {
        string authorID FK "著者ID"
        object sessionIDs "セッションID一覧"
    }

    GroupSessions {
        string groupID FK "グループID"
        object sessionIDs "セッションID一覧"
    }

    ReadOnlyMapping {
        string padID FK "パッドID"
        string readOnlyID "読み取り専用ID（r.xxxx形式）"
    }

    TokenMapping {
        string tokenID PK "トークンID"
        string authorID FK "著者ID"
    }

    AuthorMapping {
        string mapper PK "外部マッパー識別子"
        string authorID FK "著者ID"
    }

    GroupMapping {
        string mapper PK "外部マッパー識別子"
        string groupID FK "グループID"
    }
```

## 主要な関連説明

### Pad（パッド）を中心とした関連

1. **Pad - Revision**: 1対多の関係。パッドは複数のリビジョンを持ち、各リビジョンは変更履歴を記録
2. **Pad - ChatMessage**: 1対多の関係。パッドは複数のチャットメッセージを保持
3. **Pad - ReadOnlyMapping**: 1対1の関係。パッドには一意の読み取り専用IDが割り当てられる
4. **Pad - Author**: 多対多の関係。複数の著者がパッドに貢献し、著者は複数のパッドに貢献可能

### Group（グループ）を中心とした関連

1. **Groups - Group**: 1対多の関係。groupsレコードは全グループのIDを保持
2. **Group - Pad**: 1対多の関係。グループは複数のパッドを含む（グループパッドの場合）
3. **Group - Session**: 1対多の関係。グループには複数のセッションが紐付く

### Author（著者）を中心とした関連

1. **Author - Session**: 1対多の関係。著者は複数のセッションを持つことが可能
2. **Author - TokenMapping**: 多対1の関係。複数のトークンが同一著者にマッピング可能
3. **Author - AuthorMapping**: 多対1の関係。外部マッパーから著者へのマッピング

### Session（セッション）を中心とした関連

1. **Session - Author**: 多対1の関係。セッションは必ず1人の著者に属する
2. **Session - Group**: 多対1の関係。セッションは必ず1つのグループに属する
3. **AuthorSessions/GroupSessions**: セッションへの参照インデックス

## キープレフィックスとエンティティの対応

| キープレフィックス | エンティティ | 説明 |
| --- | --- | --- |
| `groups` | Groups | 全グループID一覧 |
| `group:$GROUPID` | Group | 個別グループ情報 |
| `pad:$PADID` | Pad | パッド基本情報 |
| `pad:$PADID:revs:$REVNUM` | Revision | リビジョン情報 |
| `pad:$PADID:chat:$CHATNUM` | ChatMessage | チャットメッセージ |
| `globalAuthor:$AUTHORID` | Author | 著者情報 |
| `session:$SESSIONID` | Session | セッション情報 |
| `author2sessions:$AUTHORID` | AuthorSessions | 著者-セッション対応 |
| `group2sessions:$GROUPID` | GroupSessions | グループ-セッション対応 |
| `pad2readonly:$PADID` | ReadOnlyMapping | パッド-読み取り専用ID対応 |
| `readonly2pad:$READONLYID` | ReadOnlyMapping | 読み取り専用ID-パッド対応 |
| `token2author:$TOKENID` | TokenMapping | トークン-著者対応 |
| `mapper2author:$MAPPER` | AuthorMapping | マッパー-著者対応 |
| `mapper2group:$MAPPER` | GroupMapping | マッパー-グループ対応 |
