---
generated_at: 2026-02-10 12:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **savedRevisionsの構造**：コード内に詳細なスキーマ定義なし
  2. **passwordHashフィールド**：database.adocには記載があるがソースコードで確認できず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `doc/database.adoc` - 公式データベース構造ドキュメント
- E-02: `src/node/db/DB.ts` - データベースモジュール実装
- E-03: `src/node/db/AuthorManager.ts` - 著者管理モジュール
- E-04: `src/node/db/GroupManager.ts` - グループ管理モジュール
- E-05: `src/node/db/SessionManager.ts` - セッション管理モジュール
- E-06: `src/node/db/Pad.ts` - パッドクラス実装
- E-07: `src/node/db/PadManager.ts` - パッド管理モジュール
- E-08: `src/node/db/ReadOnlyManager.ts` - 読み取り専用管理モジュール

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UeberDB2をデータベースエンジンとして使用 | E-02 (line 24) | ○ |
| C-02 | groupsキーにグループID一覧を保存 | E-01, E-04 (line 33) | ○ |
| C-03 | group:$GROUPIDにpadsとmappingsを保存 | E-04 (line 98, 124) | ○ |
| C-04 | pad:$PADIDにatext, pool, head, chatHeadを保存 | E-06 (line 42-66), E-01 | ○ |
| C-05 | pad:$PADID:revs:$REVNUMにchangesetとmetaを保存 | E-06 (line 113-123), E-01 | ○ |
| C-06 | pad:$PADID:chat:$CHATNUMにtext, authorId, timeを保存 | E-06 (line 342), E-01 | ○ |
| C-07 | pad2readonly/readonly2padでマッピングを管理 | E-08 (line 46-49), E-01 | ○ |
| C-08 | token2authorでトークンから著者へのマッピング | E-03 (line 126), E-01 | ○ |
| C-09 | mapper2authorで外部識別子から著者へのマッピング | E-03 (line 183), E-01 | ○ |
| C-10 | mapper2groupで外部識別子からグループへのマッピング | E-04 (line 115-119), E-01 | ○ |
| C-11 | globalAuthor:$AUTHORIDにcolorId, name, timestampを保存 | E-03 (line 203-207), E-01 | ○ |
| C-12 | globalAuthorにpadIDsフィールドが存在 | E-03 (line 268, 288-294) | ○ |
| C-13 | session:$SESSIONIDにgroupID, authorID, validUntilを保存 | E-05 (line 147), E-01 | ○ |
| C-14 | author2sessions:$AUTHORIDにsessionIDsを保存 | E-05 (line 155), E-01 | ○ |
| C-15 | group2sessions:$GROUPIDにsessionIDsを保存 | E-05 (line 154), E-01 | ○ |
| C-16 | 著者IDはa.で始まる16文字のランダム文字列 | E-03 (line 200) | ○ |
| C-17 | グループIDはg.で始まる16文字のランダム文字列 | E-04 (line 97) | ○ |
| C-18 | セッションIDはs.で始まる16文字のランダム文字列 | E-05 (line 144) | ○ |
| C-19 | 読み取り専用IDはr.で始まる16文字のランダム文字列 | E-08 (line 45) | ○ |
| C-20 | グループパッドIDは$GROUPID$パッド名の形式 | E-04 (line 139), E-07 (line 195) | ○ |
| C-21 | キーリビジョンは100の倍数 | E-06 (line 262-264) | ○ |
| C-22 | キーリビジョンにはpoolとatextが追加保存される | E-06 (line 118-121) | ○ |
| C-23 | セッション削除時に整合性が保たれる | E-05 (line 195-205) | ○ |
| C-24 | グループ削除時に関連データが削除される | E-04 (line 45-78) | ○ |
| C-25 | パッド削除時に関連データが削除される | E-06 (line 557-614) | ○ |
| C-26 | publicStatusフィールドがPadに存在 | E-06 (line 47, 618-620) | ○ |
| C-27 | savedRevisionsの詳細な構造 | E-06 (line 623-641) | △ |
| C-28 | passwordHashフィールドの存在 | E-01 | △ |

## 4) 不足情報（Unknown / Missing）
- **savedRevisionsの構造**: コード内では使用されているが、詳細なスキーマは暗黙的。addSavedRevision関数から構造を推測。
  - 候補：公式ドキュメントの更新 / テストコードの確認 / 開発者へのヒアリング
- **passwordHashフィールド**: database.adocには記載があるが、現行ソースコードでの実装箇所が特定できず。SecurityManager.tsで関連処理がある可能性。
  - 候補：SecurityManager.tsの詳細確認 / 設定ファイルの確認 / プラグインでの実装確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 主要なデータ構造はすべてソースコードおよび公式ドキュメントで確認済み
- **1（中リスク）**: savedRevisionsのスキーマ詳細は推測に基づく部分あり
- **0（低リスク）**: ID生成規則はすべてソースコードで確認済み
- **1（中リスク）**: passwordHashフィールドの現行実装状況は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] savedRevisionsフィールドの実際の使用状況と構造が正しいか確認
- [ ] passwordHashフィールドが現行バージョンで使用されているか確認
- [ ] UeberDB2がサポートする各データベースバックエンドでのデータ型の互換性確認
- [ ] プラグインによる追加フィールドの有無を確認
- [ ] キーリビジョン間隔（100）の設定可否について確認
