---
generated_at: 2026-02-10 12:55:00
metrics:
  claims_total: 39
  claims_with_evidence: 39
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：39 / 39、根拠なし：0
- 優先レビュー（高）
  - 全ての項目がソースコードに基づいており、根拠不足の項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `bin/run.sh`
- E-02: `bin/safeRun.sh`
- E-03: `bin/fastRun.sh`
- E-04: `bin/debugRun.sh`
- E-05: `bin/cleanRun.sh`
- E-06: `start.bat`
- E-07: `bin/installDeps.sh`
- E-08: `bin/installOnWindows.bat`
- E-09: `bin/installLocalPlugins.sh`
- E-10: `bin/buildDebian.sh`
- E-11: `bin/buildForWindows.sh`
- E-12: `bin/createRelease.sh`
- E-13: `bin/release.ts`
- E-14: `bin/push-after-release.sh`
- E-15: `bin/generateReleaseNotes.ts`
- E-16: `bin/make_docs.ts`
- E-17: `bin/migrateDB.ts`
- E-18: `bin/migrateDirtyDBtoRealDB.ts`
- E-19: `bin/importSqlFile.ts`
- E-20: `bin/checkAllPads.ts`
- E-21: `bin/checkPad.ts`
- E-22: `bin/deletePad.ts`
- E-23: `bin/extractPadData.ts`
- E-24: `bin/rebuildPad.ts`
- E-25: `bin/repairPad.ts`
- E-26: `bin/createUserSession.ts`
- E-27: `bin/deleteAllGroupSessions.ts`
- E-28: `bin/plugins.ts`
- E-29: `bin/commonPlugins.ts`
- E-30: `bin/updatePlugins.sh`
- E-31: `bin/plugins/getCorePlugins.sh`
- E-32: `bin/plugins/updateCorePlugins.sh`
- E-33: `bin/plugins/reTestAllPlugins.sh`
- E-34: `bin/plugins/updateAllPluginsScript.sh`
- E-35: `src/tests/frontend/travis/runner.sh`
- E-36: `src/tests/frontend/travis/adminrunner.sh`
- E-37: `src/tests/frontend/travis/runnerBackend.sh`
- E-38: `src/tests/frontend/travis/runnerLoadTest.sh`
- E-39: `src/tests/ratelimit/testlimits.sh`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | run.sh：Etherpadの起動スクリプト。依存関係のインストール後、Admin UIをビルドしてサーバーを起動する | E-01 | ○ |
| C-02 | safeRun.sh：エラー発生時に自動再起動するEtherpad起動スクリプト。エラー時のメール通知機能あり | E-02 | ○ |
| C-03 | fastRun.sh：依存関係チェックを省略して直接Etherpadを起動する開発者向けスクリプト | E-03 | ○ |
| C-04 | debugRun.sh：Chrome DevToolsでデバッグ可能なモードでEtherpadを起動する | E-04 | ○ |
| C-05 | cleanRun.sh：node_modulesを削除してクリーンな環境でEtherpadを起動する | E-05 | ○ |
| C-06 | start.bat：Windows用Etherpad起動バッチファイル | E-06 | ○ |
| C-07 | installDeps.sh：Node.jsの確認と依存関係のインストールを行う | E-07 | ○ |
| C-08 | installOnWindows.bat：Windows用依存関係インストールバッチファイル。Admin UIとUIのビルドも実行 | E-08 | ○ |
| C-09 | installLocalPlugins.sh：ローカルプラグインをインストールするスクリプト | E-09 | ○ |
| C-10 | buildDebian.sh：Debianパッケージ(.deb)を作成するスクリプト | E-10 | ○ |
| C-11 | buildForWindows.sh：Windows用ビルド(zip)を作成するスクリプト。node.exeをダウンロードしてパッケージ化 | E-11 | ○ |
| C-12 | createRelease.sh：リリースプロセスを自動化するスクリプト(非推奨)。バージョン更新とGitHubリリース作成 | E-12 | ○ |
| C-13 | release.ts：新しいリリースバージョンを作成するTypeScriptスクリプト。バージョン番号の更新とタグ作成を実行 | E-13 | ○ |
| C-14 | push-after-release.sh：リリース後にGitHubへプッシュするスクリプト | E-14 | ○ |
| C-15 | generateReleaseNotes.ts：CHANGELOGから指定バージョンのリリースノートを抽出するスクリプト | E-15 | ○ |
| C-16 | make_docs.ts：asciidoctorを使用してドキュメントを生成するスクリプト | E-16 | ○ |
| C-17 | migrateDB.ts：データベース間でデータを移行するスクリプト | E-17 | ○ |
| C-18 | migrateDirtyDBtoRealDB.ts：DirtyDBから本番用データベースへデータを移行するスクリプト | E-18 | ○ |
| C-19 | importSqlFile.ts：SQLファイルからデータをインポートするスクリプト | E-19 | ○ |
| C-20 | checkAllPads.ts：全てのパッドのデータ整合性をチェックするデバッグツール | E-20 | ○ |
| C-21 | checkPad.ts：指定したパッドのデータ整合性をチェックするデバッグツール | E-21 | ○ |
| C-22 | deletePad.ts：CLIからパッドを削除するスクリプト | E-22 | ○ |
| C-23 | extractPadData.ts：パッドのデータをdirtydbファイルとして抽出するデバッグツール | E-23 | ○ |
| C-24 | rebuildPad.ts：パッドのデータを再挿入して修復するスクリプト | E-24 | ○ |
| C-25 | repairPad.ts：古いパッドを指定リビジョンまで新しいパッドに再構築する修復ツール | E-25 | ○ |
| C-26 | createUserSession.ts：テスト用ユーザーセッションを生成するスクリプト | E-26 | ○ |
| C-27 | deleteAllGroupSessions.ts：全てのグループセッションを削除するスクリプト | E-27 | ○ |
| C-28 | plugins.ts：プラグインのインストール/削除/一覧表示を行うCLIツール | E-28 | ○ |
| C-29 | commonPlugins.ts：インストール済みプラグイン情報を永続化するモジュール | E-29 | ○ |
| C-30 | updatePlugins.sh：インストール済みプラグインを更新するスクリプト | E-30 | ○ |
| C-31 | getCorePlugins.sh：公式プラグインをクローン/更新するスクリプト | E-31 | ○ |
| C-32 | updateCorePlugins.sh：コアプラグインをチェック・プッシュするスクリプト | E-32 | ○ |
| C-33 | reTestAllPlugins.sh：全プラグインに対してテスト再実行をトリガーするスクリプト | E-33 | ○ |
| C-34 | updateAllPluginsScript.sh：GitHub上の全プラグインをクローンしてチェックするスクリプト | E-34 | ○ |
| C-35 | runner.sh：フロントエンドテストを実行するスクリプト | E-35 | ○ |
| C-36 | adminrunner.sh：管理画面のフロントエンドテストを実行するスクリプト | E-36 | ○ |
| C-37 | runnerBackend.sh：バックエンドテストを実行するスクリプト(非推奨) | E-37 | ○ |
| C-38 | runnerLoadTest.sh：負荷テストを実行するスクリプト | E-38 | ○ |
| C-39 | testlimits.sh：レート制限のテストを実行するスクリプト | E-39 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全てのバッチファイル/スクリプトは実際のソースコードに基づいて記述されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての項目がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] カテゴリ分類が適切か確認
- [ ] 各バッチの説明がソースコードの実装と一致しているか確認
- [ ] 非推奨（deprecated）のスクリプトが正しくマークされているか確認
- [ ] 備考欄のファイルパスが正確か確認
