# バッチ設計書 1-run.sh

## 概要

本ドキュメントは、Etherpadの標準起動スクリプト`run.sh`の設計仕様を記載したものである。このスクリプトは依存関係のインストール、Admin UIのビルド、およびサーバー起動を一括して行う。

### 本バッチの処理概要

Etherpadアプリケーションを正しく起動するための標準的なエントリーポイントスクリプトである。依存関係の確認・インストールからAdmin UI/UIのビルド、サーバー起動までを一連の流れで実行する。

**業務上の目的・背景**：Etherpadは複数のコンポーネント（サーバー、Admin UI、UI）から構成されており、これらを正しい順序で初期化・起動する必要がある。このスクリプトは、開発者や運用者がEtherpadを起動する際の標準的な手順を自動化し、起動時のミスや設定漏れを防止する役割を持つ。また、root権限での誤った実行を防ぐセキュリティ機能も備えている。

**バッチの実行タイミング**：Etherpadサーバーを起動する際に手動で実行する。開発環境では開発者が随時実行し、本番環境ではシステム起動時やサービス再起動時に実行される。

**主要な処理内容**：
1. Etherpadベースディレクトリへの移動と環境設定の読み込み
2. root権限チェックとセキュリティ確認
3. `installDeps.sh`による依存関係のインストール
4. 開発環境の場合、Admin UIとUIのビルド（pnpm run build）
5. `pnpm run prod`によるEtherpadサーバーの起動

**前後の処理との関連**：本スクリプトは`installDeps.sh`を内部で呼び出すため、依存関係のインストールが前提処理として自動実行される。また、`safeRun.sh`からも呼び出され、自動再起動機能付きで実行される場合がある。

**影響範囲**：Etherpadアプリケーション全体に影響する。起動に失敗した場合、サービス全体が利用不可となる。Admin UIとUIのビルドにより、`admin`および`ui`ディレクトリ配下にビルド成果物が生成される。

## バッチ種別

起動処理 / アプリケーション初期化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / システム起動時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | バージョン12.13以上がインストールされていること |
| pnpm | パッケージマネージャーpnpmがインストールされていること |
| ディレクトリ構成 | bin/functions.sh, bin/installDeps.shが存在すること |

### 実行可否判定

- root権限での実行時は、`--root`引数が指定されているか、確認メッセージ「Etherpad rocks my socks」の入力が必要
- 上記条件を満たさない場合、スクリプトは終了する

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --root | フラグ | No | なし | root権限での実行を許可する |
| --settings / -s | 文字列 | No | settings.json | 使用する設定ファイルのパス |
| その他 | 任意 | No | - | pnpm run prodに渡される引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| bin/functions.sh | シェルスクリプト | 共通関数・定数定義 |
| settings.json | JSON | Etherpad設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 起動ログ・ステータスメッセージ |
| admin/dist | ディレクトリ | Admin UIビルド成果物 |
| ui/dist | ディレクトリ | UIビルド成果物 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Admin UI/UIビルド成果物（複数ファイル） |
| 出力先 | admin/dist, ui/dist |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. ディレクトリ移動
   └─ スクリプトの場所からEtherpadベースディレクトリへ移動
2. 共通関数読み込み
   └─ bin/functions.shをソースして共通関数を利用可能にする
3. root権限チェック
   └─ --root引数または確認フレーズによる認証
4. 依存関係インストール
   └─ bin/installDeps.shを実行
5. Admin UI/UIビルド（開発環境のみ）
   └─ NODE_ENVが未設定またはdevelopmentの場合、pnpm run buildを実行
6. サーバー起動
   └─ pnpm run prodでEtherpadサーバーを起動
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ディレクトリ移動・環境読み込み]
    B --> C{root権限で実行?}
    C -->|No| E[installDeps.sh実行]
    C -->|Yes| D{--root引数あり?}
    D -->|Yes| E
    D -->|No| F[確認メッセージ入力要求]
    F --> G{正しい入力?}
    G -->|Yes| E
    G -->|No| H[エラー終了]
    E --> I{installDeps成功?}
    I -->|No| H
    I -->|Yes| J{開発環境?}
    J -->|Yes| K[Admin UI/UIビルド]
    J -->|No| L[ビルドスキップ]
    K --> M[pnpm run prod実行]
    L --> M
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチは直接的なデータベース操作を行わない。サーバー起動後、Etherpadアプリケーションがデータベースに接続する。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチでは直接操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 認証エラー | root権限実行時に確認フレーズが不正 | 正しいフレーズを入力するか--root引数を使用 |
| 1 | 依存関係エラー | installDeps.shが失敗 | Node.jsバージョン確認、ネットワーク接続確認 |
| 1 | ビルドエラー | Admin UI/UIのビルドが失敗 | pnpmの状態確認、node_modules削除後再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動再実行が必要） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認し、原因を特定する
2. Node.jsのバージョンが要件を満たしているか確認（12.13以上）
3. pnpmが正しくインストールされているか確認
4. ネットワーク接続を確認（依存関係のダウンロードに必要）
5. `cleanRun.sh`を使用してクリーンな状態から再実行を試みる

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の起動処理 |
| 目標処理時間 | 依存関係インストール状況により変動（初回: 数分、2回目以降: 数十秒） |
| メモリ使用量上限 | Node.jsプロセスに依存 |

## 排他制御

- 同一ホスト上での複数同時実行は推奨されない
- ポートの競合が発生した場合、後から起動したプロセスは失敗する

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 依存関係インストール開始メッセージ |
| 進捗ログ | 処理中 | Admin UI作成メッセージ、起動メッセージ |
| 終了ログ | バッチ終了時 | Etherpadプロセスの出力に依存 |
| エラーログ | エラー発生時 | エラー詳細（標準エラー出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| プロセス起動状態 | 起動失敗時 | 運用担当者 |
| ポート使用状態 | ポート競合時 | 運用担当者 |

## 備考

- 本番環境では`NODE_ENV=production`を設定することでAdmin UIビルドがスキップされる
- セキュリティ上、root権限での実行は非推奨である
- 依存関係のインストールをスキップしたい場合は`fastRun.sh`の使用を検討すること
