# バッチ設計書 10-buildDebian.sh

## 概要

本ドキュメントは、Debianパッケージビルドスクリプト`buildDebian.sh`の設計仕様を記載したものである。Etherpadをdeb形式のパッケージとしてビルドし、Debianベースのシステムにインストール可能な形式で配布できるようにする。

### 本バッチの処理概要

EtherpadをDebianパッケージ（.deb）としてパッケージングするスクリプトである。プロジェクト全体をsysroot構造に配置し、DEBIANメタデータと組み合わせてarコマンドでdebファイルを生成する。

**業務上の目的・背景**：Debianベースのディストリビューション（Debian、Ubuntu等）では、aptパッケージマネージャーによるソフトウェア管理が標準である。Etherpadをdebパッケージとして提供することで、標準的なLinux運用フローに統合でき、インストール・更新・削除が容易になる。また、dpkgコマンドで依存関係の追跡やシステム統合が可能になる。

**バッチの実行タイミング**：
- リリースビルド時
- デプロイメントパッケージ作成時
- CI/CDパイプラインでのパッケージング工程

**主要な処理内容**：
1. 作業ディレクトリ（/tmp/etherpad-deb-src, /tmp/etherpad-deb-dist）のクリーンアップと作成
2. bin/deb-srcからDEBIANメタデータテンプレートのコピー
3. プロジェクトファイルをsysroot/opt/etherpadにコピー（.git除外）
4. README.mdをドキュメントディレクトリにコピー
5. パーミッションとオーナーシップの設定（root:root）
6. data.tar.gzの作成（sysrootの内容）
7. control.tar.gzの作成（DEBIANメタデータ）
8. debian-binary、control.tar.gz、data.tar.gzからdebファイルの生成

**前後の処理との関連**：本スクリプト実行前に、bin/deb-srcディレクトリにDEBIANメタデータ（control等）が配置されている必要がある。ビルド後のdebファイルはdpkgコマンドでインストール可能。

**影響範囲**：/tmpディレクトリに一時ファイルが作成される。プロジェクトルートにetherpad-1.debファイルが生成される。root権限が必要（chown root:rootを実行するため）。

## バッチ種別

ビルド処理 / パッケージング / リリース

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | リリース時 / 必要に応じて |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| root権限 | chownコマンドの実行にroot権限が必要 |
| rsync | ファイルコピーにrsyncコマンドが必要 |
| ar | debファイル作成にarコマンドが必要 |
| bin/deb-src | DEBIANメタデータテンプレートが存在すること |

### 実行可否判定

- root権限がない場合、chownコマンドが失敗する
- rsync、arコマンドがない場合、対応する処理が失敗する

## 入力仕様

### 入力パラメータ

本スクリプトはコマンドライン引数を受け付けない。

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | - |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| bin/deb-src/ | ディレクトリ | DEBIANメタデータテンプレート |
| プロジェクトルート | ディレクトリ | Etherpadソースコード全体 |
| README.md | テキスト | ドキュメントファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| etherpad-1.deb | バイナリ | Debianパッケージファイル |
| /tmp/etherpad-deb-src | ディレクトリ | 作業ディレクトリ（ビルド中） |
| /tmp/etherpad-deb-dist | ディレクトリ | 出力ディレクトリ（ビルド中） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | etherpad-1.deb |
| 出力先 | プロジェクトルート |
| 形式 | Debianパッケージ（ar archive） |
| 内容 | debian-binary, control.tar.gz, data.tar.gz |

### パッケージインストール先

| インストール先 | 内容 |
|--------------|------|
| /opt/etherpad | Etherpadアプリケーション本体 |
| /usr/share/doc/etherpad | README.md |

## 処理フロー

### 処理シーケンス

```
1. 初期設定
   └─ set -u -eで未定義変数使用禁止、エラー時終了
2. 変数定義
   ├─ SRC=/tmp/etherpad-deb-src
   ├─ DIST=/tmp/etherpad-deb-dist
   ├─ SYSROOT=${SRC}/sysroot
   └─ DEBIAN=${SRC}/DEBIAN
3. 出力ディレクトリ準備
   ├─ rm -rf ${DIST}
   └─ mkdir -p ${DIST}/
4. ソースディレクトリ準備
   ├─ rm -rf ${SRC}
   └─ rsync -a bin/deb-src/ ${SRC}/
5. sysroot作成
   ├─ mkdir -p ${SYSROOT}/opt/
   ├─ rsync --exclude '.git' -a . ${SYSROOT}/opt/etherpad/ --delete
   ├─ mkdir -p ${SYSROOT}/usr/share/doc
   └─ cp README.md ${SYSROOT}/usr/share/doc/etherpad
6. パーミッション設定
   ├─ find ${SRC}/ -type d -exec chmod 0755 {} \;
   ├─ find ${SRC}/ -type f -exec chmod go-w {} \;
   └─ chown -R root:root ${SRC}/
7. data.tar.gz作成
   ├─ SIZEの計算（duコマンド）
   ├─ pushd ${SYSROOT}/
   ├─ tar czf ${DIST}/data.tar.gz [a-z]*
   └─ popd
8. control.tar.gz作成
   ├─ sedでSIZE値を置換
   ├─ pushd ${DEBIAN}
   ├─ tar czf ${DIST}/control.tar.gz *
   └─ popd
9. debファイル作成
   ├─ pushd ${DIST}/
   ├─ echo 2.0 > ./debian-binary
   ├─ パーミッション設定
   ├─ chown -R root:root ${DIST}/
   ├─ ar r ${DIST}/etherpad-1.deb debian-binary control.tar.gz data.tar.gz
   ├─ popd
   └─ rsync -a ${DIST}/etherpad-1.deb ./
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[set -u -e設定]
    B --> C[作業ディレクトリクリーンアップ]
    C --> D[DEBIANメタデータコピー]
    D --> E[sysroot構造作成]
    E --> F[プロジェクトファイルコピー]
    F --> G[ドキュメントコピー]
    G --> H[パーミッション設定]
    H --> I[オーナーシップ設定 root:root]
    I --> J[SIZE計算]
    J --> K[data.tar.gz作成]
    K --> L[control更新 SIZE置換]
    L --> M[control.tar.gz作成]
    M --> N[debian-binary作成]
    N --> O[debファイル作成 ar r]
    O --> P[プロジェクトルートにコピー]
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチは直接的なデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチでは直接操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | 権限エラー | root権限なしでchown実行 | root権限で実行 |
| 非0 | コマンドエラー | rsync/ar/tarが未インストール | 必要なパッケージをインストール |
| 非0 | ファイルエラー | bin/deb-srcが存在しない | プロジェクト構成を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動再実行が必要） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認し、原因を特定する
2. root権限で実行しているか確認
3. 必要なコマンド（rsync、ar、tar）がインストールされているか確認
4. ディスク容量を確認（/tmp、プロジェクトディレクトリ）
5. bin/deb-srcディレクトリの存在と内容を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルド処理 |
| 目標処理時間 | 数分（プロジェクトサイズに依存） |
| メモリ使用量上限 | rsync、tarプロセスに依存 |
| ディスク使用量 | プロジェクトサイズの2〜3倍（/tmp使用） |

## 排他制御

- 同一ホスト上での複数同時実行は禁止
- /tmp/etherpad-deb-*ディレクトリが競合する

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各コマンド実行時 | rsync、tar等の標準出力 |
| エラーログ | エラー発生時 | コマンドエラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | リリースエンジニア |
| 生成ファイルサイズ | 異常に小さい場合 | リリースエンジニア |

## 備考

- root権限が必要なため、本番環境での直接実行ではなくCI/CDパイプラインでの使用を推奨
- .gitディレクトリはパッケージから除外される（rsync --exclude '.git'）
- パッケージバージョンは現在「1」固定（etherpad-1.deb）
- debファイルフォーマットバージョンは2.0を使用
- インストール先は/opt/etherpad（FHS準拠の追加アプリケーション配置場所）
- `let SIZE=...`構文でサイズ計算（+8は予備領域）
- pushd/popdでディレクトリスタックを使用してカレントディレクトリを管理
- 生成されたdebファイルはプロジェクトルートにコピーされる
