# バッチ設計書 11-buildForWindows.sh

## 概要

本ドキュメントは、Etherpad Lite の Windows 向け配布用 ZIP ファイルを作成するためのビルドスクリプト `buildForWindows.sh` のバッチ設計書です。

### 本バッチの処理概要

本バッチは、Etherpad Lite を Windows 環境で実行可能な状態にパッケージ化し、配布用の ZIP ファイルを生成します。

**業務上の目的・背景**：Etherpad Lite は Node.js ベースの協調編集ツールであり、主に Linux 環境で開発されています。Windows ユーザーに対しても簡便に導入できるよう、Node.js 実行環境を含んだ自己完結型パッケージを提供する必要があります。本バッチはこの Windows 向け配布パッケージを自動生成することで、リリース作業の効率化とパッケージ品質の均一化を実現します。

**バッチの実行タイミング**：新バージョンリリース時、または Windows 向けビルドが必要な場合に手動で実行します。リリースプロセスの一環として `createRelease.sh` や GitHub Actions から呼び出されることもあります。

**主要な処理内容**：
1. 必要なコマンド（git, unzip, wget, zip）の存在確認
2. 一時ディレクトリへのクリーンなソースコードのチェックアウト
3. pnpm による依存関係のインストールとビルド
4. 不要なディレクトリ（admin, oidc, src/node_modules）の削除
5. settings.json.template から settings.json への複製
6. Windows 用 Node.js 実行ファイル（node.exe）のダウンロード
7. 全ファイルを ZIP 形式で圧縮

**前後の処理との関連**：本バッチはリリースプロセスの一部として使用され、`release.ts` や `createRelease.sh` から呼び出される可能性があります。生成された ZIP ファイルは GitHub Releases にアップロードされ、ユーザーに配布されます。

**影響範囲**：ローカル環境の一時ディレクトリに作業ファイルを生成し、最終的に `etherpad-win.zip` をプロジェクトルートに出力します。リモートサーバーへの直接的な影響はありません。

## バッチ種別

ビルド・パッケージング処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / リリースプロセス / GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| git コマンド | バージョン管理操作に必要 |
| unzip コマンド | 解凍処理に必要 |
| wget コマンド | Node.js のダウンロードに必要 |
| zip コマンド | ZIP ファイル作成に必要 |
| pnpm | パッケージマネージャ |
| src/package.json | Etherpad プロジェクトルートの確認 |

### 実行可否判定

スクリプト開始時に以下の判定を実施：
- 必要コマンド（git, unzip, wget, zip）が PATH 上に存在すること
- カレントディレクトリが Etherpad プロジェクトルートであること（src/package.json の存在確認）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Git リポジトリ | Git | HEAD からチェックアウト |
| settings.json.template | JSON | 設定テンプレートファイル |
| Node.js v20 (node.exe) | 実行ファイル | https://nodejs.org から取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ${workdir}/etherpad-win.zip | ZIP | Windows 向け配布パッケージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | etherpad-win.zip |
| 出力先 | プロジェクトルートディレクトリ |
| 圧縮形式 | ZIP（最大圧縮レベル -9） |
| 内容物 | Etherpad ソースコード、ビルド済みアセット、node.exe、settings.json |

## 処理フロー

### 処理シーケンス

```
1. 環境チェック
   └─ git, unzip, wget, zip コマンドの存在確認
2. ディレクトリ移動
   └─ スクリプトの場所から Git ルートディレクトリへ移動
3. 一時ディレクトリ作成
   └─ mktemp で作業用ディレクトリを作成
4. クリーンなコードのチェックアウト
   └─ GIT_WORK_TREE を使用して一時ディレクトリへ展開
5. 依存関係インストール
   └─ pnpm install の実行
6. アプリケーションビルド
   └─ pnpm run build:etherpad の実行
7. 不要ファイルの削除
   └─ admin/, oidc/, src/node_modules/ の削除
8. 設定ファイルのコピー
   └─ settings.json.template を settings.json にコピー
9. Windows 用 Node.js のダウンロード
   └─ wget で node.exe を取得
10. ZIP ファイル作成
    └─ zip -9 -r で圧縮
11. クリーンアップ
    └─ 一時ディレクトリの削除（trap で自動実行）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{必要コマンド存在確認}
    B -->|存在しない| C[エラー終了]
    B -->|存在する| D[Git ルートへ移動]
    D --> E[一時ディレクトリ作成]
    E --> F[クリーンコードのチェックアウト]
    F --> G[pnpm install 実行]
    G --> H[pnpm run build:etherpad 実行]
    H --> I[不要ディレクトリ削除]
    I --> J[settings.json コピー]
    J --> K[node.exe ダウンロード]
    K --> L[ZIP ファイル作成]
    L --> M[一時ディレクトリ削除]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 依存コマンド不足 | git/unzip/wget/zip が未インストール | 必要コマンドをインストール |
| 1 | ディレクトリエラー | src/package.json が存在しない | 正しいディレクトリで実行 |
| 1 | Git チェックアウト失敗 | Git 操作エラー | リポジトリの状態を確認 |
| 1 | ネットワークエラー | node.exe のダウンロード失敗 | ネットワーク接続を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（set -e により即座に終了） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- スクリプトは `set -e` により、いずれかのコマンドが失敗すると即座に終了
- `trap` により、正常・異常終了に関わらず一時ディレクトリは自動的に削除される
- 障害発生時は出力されたエラーメッセージを確認し、原因を特定して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 回あたり 1 パッケージ |
| 目標処理時間 | 5-10 分（ネットワーク速度依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定されていない。同一環境で複数回並列実行した場合、一時ディレクトリが競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 一時ディレクトリ作成時 | "create a clean environment in $TMP_FOLDER..." |
| 進捗ログ | 各処理ステップ | "copy the windows settings template...", "download windows node...", "create the zip..." |
| 終了ログ | バッチ終了時 | "Finished. You can find the zip at ${OUTPUT}" |
| エラーログ | エラー発生時 | "ERROR: ..." / "Please install ${x}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | なし | なし |
| エラー件数 | なし | なし |

## 備考

- 環境変数 `NODE_ENV=development` が設定されており、開発用依存関係もインストールされる
- 環境変数 `MSYSTEM=winsymlinks:lnk` は MSYS2 環境でシンボリックリンクを正しく処理するための設定
- Node.js v20 の Windows 64bit 版がダウンロードされる
