# バッチ設計書 12-createRelease.sh

## 概要

本ドキュメントは、Etherpad Lite のリリースプロセスを自動化するためのスクリプト `createRelease.sh` のバッチ設計書です。**注意：本スクリプトは Etherpad 1.7.0（2018年8月17日）以降、非推奨（DEPRECATED）となっています。**

### 本バッチの処理概要

本バッチは、Etherpad Lite の新バージョンリリースに必要な一連の作業を自動化します。CHANGELOG の更新、バージョン番号の変更、リリースブランチの作成とマージ、Windows ビルドとドキュメントの生成、GitHub へのリリース公開を一括して実行します。

**業務上の目的・背景**：ソフトウェアリリースは複数のリポジトリ（etherpad-lite 本体と ether.github.com ドキュメントサイト）にまたがる複雑な作業です。手動で行うとミスが発生しやすく、一貫性を保つことが困難です。本バッチはこれらの作業を自動化し、リリース品質の向上とリリース担当者の負担軽減を目的としていました。ただし、現在は `release.ts` に置き換えられており、本スクリプトはドキュメント目的でのみ残されています。

**バッチの実行タイミング**：新バージョンリリース時に手動で実行されます。ただし、現在は非推奨であり、`release.ts` の使用が推奨されます。

**主要な処理内容**：
1. GitHub API トークンの有効性確認
2. CHANGELOG.md へのリリースノート追記
3. src/package.json のバージョン番号更新
4. リリースブランチの作成と GitHub へのプッシュ
5. リリースブランチの master ブランチへのマージ
6. Windows ビルドとドキュメントの生成
7. ether.github.com リポジトリへのビルド成果物のコピーとプッシュ
8. GitHub Release の作成

**前後の処理との関連**：本バッチは単独でリリースプロセス全体を担当します。内部で `buildForWindows.sh` を呼び出し、`make docs` でドキュメントを生成します。後継スクリプトである `release.ts` と `push-after-release.sh` の組み合わせが現在の推奨ワークフローです。

**影響範囲**：etherpad-lite リポジトリと ether.github.com リポジトリの両方に変更を加えます。master ブランチへのマージと GitHub Release の作成を行うため、公開リポジトリに直接影響します。

## バッチ種別

リリース自動化処理（非推奨）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動（対話形式） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHub API トークン | リポジトリへの書き込み権限を持つトークン |
| develop ブランチ | リリース対象のブランチにチェックアウト済み |
| 未コミットの変更 | コミットされていない変更も含めてコミット対象となる |
| git コマンド | バージョン管理操作に必要 |
| curl コマンド | GitHub API 呼び出しに必要 |
| jq コマンド | JSON パース（暗黙的に必要） |

### 実行可否判定

- スクリプト実行開始時に非推奨警告が表示され、続行するかどうかの確認プロンプトが表示される
- GitHub API トークンの有効性を確認し、無効な場合は処理を中止

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VERSION | 文字列 | Yes | - | 新バージョン番号（x.x.x形式、対話入力） |
| changelogText | 文字列 | No | 空文字 | CHANGELOG に追記するテキスト（エディタで入力） |
| API_TOKEN | 文字列 | Yes | - | GitHub API トークン（対話入力） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| CHANGELOG.md | Markdown | 既存の変更履歴ファイル |
| src/package.json | JSON | バージョン番号を含むパッケージ設定 |
| Git リポジトリ | Git | etherpad-lite および ether.github.com |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| CHANGELOG.md | Markdown | バージョン情報を先頭に追記 |
| src/package.json | JSON | バージョン番号を更新 |
| release/{VERSION} ブランチ | Git | リリースブランチを作成 |
| GitHub Release | GitHub | リリースページを作成 |
| ether.github.com/downloads/ | ZIP | Windows ビルド |
| ether.github.com/doc/v{VERSION}/ | HTML | ドキュメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| Windows ビルド名 | etherpad-win-{VERSION}-{GIT_SHA}.zip |
| ドキュメント出力先 | ether.github.com/doc/v{VERSION}/ |

## 処理フロー

### 処理シーケンス

```
1. 非推奨警告の表示と続行確認
   └─ ユーザーが y を入力した場合のみ続行
2. 環境情報の表示
   └─ 現在のブランチ、最終コミット日、現在バージョン
3. バージョン番号入力
   └─ x.x.x 形式で入力
4. CHANGELOG テキスト入力
   └─ エディタ（EDITOR 環境変数、デフォルト vi）で入力
5. GitHub API トークン入力
   └─ 対話形式で入力
6. API トークン検証
   └─ GitHub API を呼び出して有効性確認
7. ファイル修正
   └─ CHANGELOG.md と src/package.json を更新
8. リリースブランチ作成
   └─ release/{VERSION} ブランチを作成してプッシュ
9. master へマージ
   └─ GitHub API 経由でマージ
10. ビルド作成
    └─ Windows ビルドとドキュメント生成
11. ビルド成果物のプッシュ
    └─ ether.github.com リポジトリにコピーしてプッシュ
12. Web リポジトリブランチのマージ
    └─ GitHub API 経由でマージ
13. GitHub Release 作成（オプション）
    └─ ユーザー確認後に作成
14. 手動作業の案内表示
    └─ Wiki 更新、PR 作成、アナウンスの案内
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{非推奨警告確認}
    B -->|No| C[終了]
    B -->|Yes| D[環境情報表示]
    D --> E[バージョン入力]
    E --> F[CHANGELOG入力]
    F --> G[APIトークン入力]
    G --> H{トークン検証}
    H -->|無効| C
    H -->|有効| I[ファイル修正]
    I --> J[リリースブランチ作成・プッシュ]
    J --> K[masterへマージ]
    K --> L[ビルド作成]
    L --> M[成果物をWebリポジトリにプッシュ]
    M --> N[Webブランチマージ]
    N --> O{Release作成確認}
    O -->|Yes| P[GitHub Release作成]
    O -->|No| Q[手動作業案内]
    P --> Q
    Q --> R[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | API トークン無効 | GitHub API 認証失敗 | 有効なトークンを入力 |
| 1 | CHANGELOG 更新失敗 | sed コマンドエラー | ファイル形式を確認 |
| 1 | package.json 更新失敗 | sed コマンドエラー | ファイル形式を確認 |
| 1 | ブランチ作成失敗 | 既存ブランチあり | 既存ブランチを削除 |
| 1 | プッシュ失敗 | 権限不足 | リポジトリ権限を確認 |
| 1 | マージ失敗 | コンフリクト | 手動でマージ |
| 1 | ビルド失敗 | buildForWindows.sh エラー | ビルド環境を確認 |
| 1 | ドキュメント生成失敗 | make docs エラー | ドキュメント環境を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- 各ステップでエラーが発生した場合、スクリプトは即座に終了
- 部分的に完了した状態からの復旧は手動で行う必要がある
- リリースブランチが作成済みの場合は削除して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（各操作は独立） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 回あたり 1 リリース |
| 目標処理時間 | 10-30 分（ネットワーク速度・ビルド環境依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定されていない。リリースプロセスは一度に一人のみが実行すること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 各ステップ開始時 | 処理内容の説明 |
| 環境ログ | 開始時 | ブランチ、コミット日、バージョン |
| エラーログ | エラー発生時 | "Aborting: {エラー内容}" |
| 案内ログ | 終了時 | 手動作業の案内 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- **本スクリプトは Etherpad 1.7.0 以降、非推奨です**
- 後継スクリプトとして `release.ts` と `push-after-release.sh` を使用してください
- GitHub API の認証方式は旧式（URL パラメータ）であり、セキュリティ上の懸念があります
- ドキュメント目的でのみ残されているスクリプトです
