# バッチ設計書 13-release.ts

## 概要

本ドキュメントは、Etherpad Lite の新しいリリースバージョンを作成するための TypeScript スクリプト `release.ts` のバッチ設計書です。セマンティックバージョニングに基づいたバージョン番号の更新、Git タグの作成、ドキュメントのビルドとコミットを自動化します。

### 本バッチの処理概要

本バッチは、Etherpad Lite のリリースプロセスにおけるバージョン管理とブランチ操作を自動化します。非推奨となった `createRelease.sh` の後継スクリプトとして設計されています。

**業務上の目的・背景**：ソフトウェアリリースは複雑なバージョン管理とブランチ操作を伴います。手動で行うとミスが発生しやすく、セマンティックバージョニングの一貫性を保つことが困難です。本バッチはこれらの作業を自動化し、リリース品質の向上とリリース担当者の負担軽減を実現します。また、事前のサニティチェックにより、不適切な状態でのリリースを防止します。

**バッチの実行タイミング**：新バージョンリリース時に手動で実行します。CHANGELOG.md に新バージョンの記載を事前に追加しておく必要があります。

**主要な処理内容**：
1. Etherpad リポジトリの作業ディレクトリクリーン状態確認
2. develop ブランチがチェックアウトされていることの確認
3. develop/master ブランチのリモート追跡状態確認
4. ether.github.com リポジトリのクリーン状態確認
5. CHANGELOG.md に新バージョンが記載されていることの確認
6. asciidoctor がインストールされていることの確認
7. package.json ファイル群のバージョン番号更新
8. develop ブランチでのコミット作成
9. master ブランチへのマージとタグ作成
10. develop ブランチへの master のマージバック
11. ドキュメントのビルドと ether.github.com リポジトリへのコピー・コミット

**前後の処理との関連**：本バッチ実行後、`push-after-release.sh` を使用してリモートリポジトリへプッシュします。Windows ビルドは GitHub Actions で自動的に作成されるようになったため、本スクリプトでは生成しません。

**影響範囲**：ローカルの etherpad-lite リポジトリと ether.github.com リポジトリに変更を加えます。リモートへのプッシュは行わないため、確認後に `push-after-release.sh` で公開します。

## バッチ種別

リリース自動化処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | TypeScript 実行環境 |
| asciidoctor | ドキュメント生成ツール |
| git コマンド | バージョン管理操作 |
| jq コマンド | JSON ファイルの更新 |
| pnpm | パッケージマネージャ |
| develop ブランチ | チェックアウト済み |
| クリーンな作業ディレクトリ | 未コミットの変更なし |
| ether.github.com リポジトリ | 親ディレクトリにクローン済み |
| CHANGELOG.md | 新バージョンの記載あり |

### 実行可否判定

スクリプト開始時に以下のサニティチェックを実施：
- 作業ディレクトリにコミット済み/未コミットの変更がないこと
- develop ブランチがチェックアウトされていること
- develop/master がリモート追跡ブランチと同期していること
- ether.github.com リポジトリが存在し、クリーンな状態であること
- CHANGELOG.md の先頭に新バージョン番号の記載があること
- asciidoctor がインストールされていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| release | 文字列 | Yes | - | リリースタイプ（patch/minor/major） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| CHANGELOG.md | Markdown | リリースノート（先頭に新バージョン記載） |
| src/package.json | JSON | 現在のバージョン番号 |
| admin/package.json | JSON | Admin UIのバージョン番号 |
| bin/package.json | JSON | binのバージョン番号 |
| package.json | JSON | ルートのバージョン番号 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| src/package.json | JSON | バージョン番号更新 |
| admin/package.json | JSON | バージョン番号更新 |
| bin/package.json | JSON | バージョン番号更新 |
| package.json | JSON | バージョン番号更新 |
| Git コミット | Git | "bump version" コミット |
| Git タグ | Git | {VERSION} と v{VERSION} のタグ |
| ../ether.github.com/public/doc/v{VERSION}/ | HTML | ドキュメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ドキュメント出力先 | ../ether.github.com/public/doc/v{VERSION}/ |
| タグ形式 | {VERSION} および v{VERSION}（例: 1.9.0, v1.9.0） |

## 処理フロー

### 処理シーケンス

```
1. サニティチェック（Etherpad リポジトリ）
   ├─ 作業ディレクトリのクリーン確認（git stash後）
   ├─ develop ブランチのチェックアウト確認
   ├─ develop/master のリモート追跡確認
   └─ asciidoctor インストール確認
2. サニティチェック（ether.github.com リポジトリ）
   ├─ ディレクトリ存在確認
   ├─ 作業ディレクトリのクリーン確認
   ├─ master ブランチのチェックアウト確認
   └─ master のリモート追跡確認
3. バージョン計算
   ├─ 現在バージョンの読み込み
   ├─ semver.inc() で新バージョン計算
   └─ CHANGELOG.md に新バージョン記載確認
4. develop ブランチ更新
   ├─ git pull --ff-only
   ├─ 各 package.json のバージョン更新（jq使用）
   ├─ pnpm install
   ├─ git add -A && git commit
   └─ "bump version" コミット作成
5. master ブランチ操作
   ├─ master へチェックアウト
   ├─ git pull --ff-only
   ├─ develop をマージ（--no-ff --no-edit）
   └─ タグ作成（{VERSION}, v{VERSION}）
6. develop へマージバック
   ├─ develop へチェックアウト
   └─ master をマージ（--no-ff --no-edit）
7. ドキュメントビルド
   ├─ pnpm run makeDocs
   ├─ ether.github.com を更新
   └─ ドキュメントをコピー・コミット
8. 完了メッセージ
   └─ 確認コマンドとプッシュ手順の案内
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|引数なし| C[エラー: 使用方法表示]
    B -->|patch/minor/major| D[サニティチェック開始]
    D --> E{作業ディレクトリクリーン?}
    E -->|No| F[エラー終了]
    E -->|Yes| G{developブランチ?}
    G -->|No| F
    G -->|Yes| H{リモート同期OK?}
    H -->|No| F
    H -->|Yes| I{ether.github.com存在?}
    I -->|No| F
    I -->|Yes| J{CHANGELOG記載あり?}
    J -->|No| F
    J -->|Yes| K[バージョン更新開始]
    K --> L[package.json更新]
    L --> M[developでコミット]
    M --> N[masterへマージ]
    N --> O[タグ作成]
    O --> P[developへマージバック]
    P --> Q[ドキュメントビルド]
    Q --> R[ether.github.comへコピー]
    R --> S[完了メッセージ表示]
    S --> T[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数不正 | release タイプ未指定/不正 | 正しい引数で再実行 |
| 1 | 作業ディレクトリ不正 | 未コミットの変更あり | 変更をコミットまたは破棄 |
| 1 | ブランチ不正 | develop がチェックアウトされていない | develop をチェックアウト |
| 1 | リモート同期不正 | ローカルがリモートより進んでいる | プッシュして同期 |
| 1 | リポジトリ不在 | ether.github.com が存在しない | リポジトリをクローン |
| 1 | CHANGELOG 不正 | 新バージョンの記載がない | CHANGELOG を更新 |
| 1 | asciidoctor 不在 | コマンドが見つからない | asciidoctor をインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- エラー発生時は自動的にリポジトリをリセット
  - master を origin/master にリセット
  - develop を origin/develop にリセット
  - 作成したタグを削除
- リセット後、原因を修正して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | try-catch による擬似トランザクション |
| コミットタイミング | 各操作完了時（ただしプッシュ前） |
| ロールバック条件 | 例外発生時に自動ロールバック |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 回あたり 1 リリース |
| 目標処理時間 | 2-5 分 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定されていない。リリースプロセスは一度に一人のみが実行すること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各ステップ開始時 | "Updating develop branch...", "Bumping {release} version...", etc. |
| エラーログ | エラー発生時 | 例外メッセージ |
| リセットログ | ロールバック時 | "Resetting repository...", "Resetting master...", etc. |
| 完了ログ | 正常終了時 | 確認コマンドとプッシュ手順 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- Windows ビルドは GitHub Actions で自動作成されるため、本スクリプトでは生成しない
- リモートへのプッシュは `push-after-release.sh` で別途実行する
- CHANGELOG.md は事前に新バージョンの記載を追加しておく必要がある
- semver パッケージを使用してバージョン番号を計算
- log4js を使用してロギングを設定（console アペンダー）
