# バッチ設計書 14-push-after-release.sh

## 概要

本ドキュメントは、`release.ts` によるリリース準備完了後に GitHub へプッシュするためのシェルスクリプト `push-after-release.sh` のバッチ設計書です。

### 本バッチの処理概要

本バッチは、`release.ts` で作成されたローカルコミット、タグ、ドキュメント更新をリモートリポジトリへプッシュします。リリースプロセスの最終ステップとして位置づけられています。

**業務上の目的・背景**：`release.ts` はローカルでのリリース準備（バージョン更新、タグ作成、ドキュメント生成）を行いますが、リモートへのプッシュは行いません。これは、リリース担当者が変更内容を確認してから公開できるようにするためです。本バッチはその確認後に実行され、変更を公開リポジトリへ反映します。

**バッチの実行タイミング**：`release.ts` 実行後、変更内容を確認した後に手動で実行します。

**主要な処理内容**：
1. src/package.json からバージョン番号を読み取り
2. master ブランチ、develop ブランチ、バージョンタグを origin にプッシュ
3. 全てのタグをプッシュ
4. ether.github.com リポジトリの変更をプッシュ

**前後の処理との関連**：`release.ts` の実行後に使用されます。本バッチ実行後、GitHub Actions が自動的に Windows ビルドを作成し、GitHub Release を作成します。

**影響範囲**：etherpad-lite リポジトリと ether.github.com リポジトリのリモート（origin）に変更をプッシュします。公開リポジトリへの直接的な影響があります。

## バッチ種別

リリース公開処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| release.ts 実行済み | ローカルコミットとタグが作成済み |
| jq コマンド | JSON パースに必要 |
| git コマンド | バージョン管理操作に必要 |
| src/package.json | バージョン番号の読み取り元 |
| ether.github.com | 親ディレクトリにクローン済み |
| リモート権限 | origin への書き込み権限 |

### 実行可否判定

- src/package.json が存在すること
- バージョン番号が読み取れること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/package.json | JSON | バージョン番号の読み取り |
| Git リポジトリ | Git | etherpad-lite および ether.github.com |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| origin/master | Git | master ブランチをプッシュ |
| origin/develop | Git | develop ブランチをプッシュ |
| origin/tags/{VERSION} | Git | バージョンタグをプッシュ |
| ether.github.com origin | Git | ドキュメント更新をプッシュ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| プッシュ対象 | master, develop, {VERSION}タグ, 全タグ |

## 処理フロー

### 処理シーケンス

```
1. バージョン番号読み取り
   └─ jq で src/package.json から version を抽出
2. メインリポジトリプッシュ
   └─ git push origin master develop {VERSION}
3. タグプッシュ
   └─ git push --tags
4. ether.github.com プッシュ
   └─ cd ../ether.github.com && git push
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{package.json存在確認}
    B -->|存在しない| C[エラー終了]
    B -->|存在する| D[バージョン番号読み取り]
    D --> E[master/develop/VERSIONプッシュ]
    E --> F[全タグプッシュ]
    F --> G[ether.github.comプッシュ]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ファイル不在 | package.json が存在しない | プロジェクトルートで実行 |
| (git) | プッシュ失敗 | リモート権限不足 | 権限を確認 |
| (git) | プッシュ失敗 | リモートに先行コミットあり | pull してから再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- プッシュ失敗時は、エラーメッセージを確認し原因を特定
- リモートリポジトリの状態を確認し、必要に応じて再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（各プッシュは独立） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 回あたり 1 リリース |
| 目標処理時間 | 1-3 分（ネットワーク速度依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定されていない。リリースプロセスは一度に一人のみが実行すること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | 標準的な git コマンド出力のみ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- 本スクリプトは `release.ts` の実行後に使用する
- プッシュ前に `release.ts` の出力に記載された確認コマンドを実行し、変更内容を確認することを推奨
- ether.github.com リポジトリは `../ether.github.com` に存在する前提
- スクリプト実行前に GitHub への認証が完了していること
