# バッチ設計書 15-generateReleaseNotes.ts

## 概要

本ドキュメントは、CHANGELOG.md から指定バージョンのリリースノートを抽出する TypeScript スクリプト `generateReleaseNotes.ts` のバッチ設計書です。

### 本バッチの処理概要

本バッチは、CHANGELOG.md ファイルを解析し、指定されたバージョンに対応するリリースノートセクションを抽出して標準出力に出力します。GitHub Actions や CI/CD パイプラインでのリリースノート自動生成に利用されます。

**業務上の目的・背景**：ソフトウェアリリース時に GitHub Release へリリースノートを添付する必要があります。CHANGELOG.md に記載された情報を手動でコピーするのは手間がかかり、ミスが発生しやすいです。本バッチは指定バージョンのリリースノートを自動抽出することで、リリースプロセスの効率化と正確性向上を実現します。

**バッチの実行タイミング**：GitHub Actions のリリースワークフロー内で自動実行されます。また、手動でリリースノートを確認したい場合にも使用できます。

**主要な処理内容**：
1. CHANGELOG.md ファイルの読み込み
2. コマンドライン引数からバージョンタグを取得
3. タグから "refs/tags/v" プレフィックスを除去
4. CHANGELOG 内で該当バージョンのセクションを検索
5. 次のバージョンセクションまでの内容を抽出
6. 抽出したリリースノートを標準出力に出力

**前後の処理との関連**：GitHub Actions のリリースワークフローで `release.ts` と `push-after-release.sh` の実行後に使用されます。抽出されたリリースノートは GitHub Release の説明文として使用されます。

**影響範囲**：読み取り専用の処理であり、ファイルやデータベースへの変更はありません。

## バッチ種別

データ抽出処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | GitHub Actions / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | TypeScript 実行環境 |
| CHANGELOG.md | 親ディレクトリ（../CHANGELOG.md）に存在 |
| バージョンタグ | コマンドライン引数で指定 |

### 実行可否判定

- バージョンタグ引数が指定されていること
- CHANGELOG.md が読み取り可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| tag | 文字列 | Yes | - | バージョンタグ（例: refs/tags/v1.9.0 または 1.9.0） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ../CHANGELOG.md | Markdown | リリースノートが記載されたファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 指定バージョンのリリースノート |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 出力先 | 標準出力（stdout） |
| 形式 | Markdown テキスト |

## 処理フロー

### 処理シーケンス

```
1. CHANGELOG.md 読み込み
   └─ ../CHANGELOG.md を読み込み
2. 引数処理
   ├─ コマンドライン引数からタグを取得
   ├─ タグが未指定の場合はエラー終了
   └─ "refs/tags/v" プレフィックスを除去
3. セクション検索
   ├─ 各行をループ処理
   ├─ "#" で始まり "#" が1つのみの行を見出しと判定
   ├─ 見出しにバージョン番号が含まれる行を開始位置とする
   └─ 次の見出し行を終了位置とする
4. リリースノート抽出
   ├─ 開始位置から終了位置までの行を抽出
   └─ 結合して標準出力に出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[CHANGELOG.md読み込み]
    B --> C{タグ引数あり?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[プレフィックス除去]
    E --> F[行ループ開始]
    F --> G{見出し行?}
    G -->|No| H[次の行へ]
    G -->|Yes| I{バージョン一致?}
    I -->|No| J{開始位置設定済?}
    J -->|No| H
    J -->|Yes| K[終了位置設定・ループ終了]
    I -->|Yes| L[開始位置設定]
    L --> H
    H --> F
    K --> M[リリースノート抽出]
    M --> N[標準出力に出力]
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数不足 | タグが指定されていない | タグ引数を指定して再実行 |
| (例外) | ファイル読み込み失敗 | CHANGELOG.md が存在しない | ファイルパスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- エラーメッセージを確認し、引数やファイルパスを修正して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 ファイル |
| 目標処理時間 | 1 秒未満 |
| メモリ使用量上限 | CHANGELOG ファイルサイズ依存 |

## 排他制御

読み取り専用処理のため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | タグ未指定時 | "No tag provided" |
| 結果出力 | 正常終了時 | リリースノート本文 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- CHANGELOG.md のフォーマットは `# {VERSION}` 形式の見出しを想定
- 見出し判定は `#` が1つのみの行（`##` 等は対象外）
- GitHub Actions から呼び出す場合、タグは `refs/tags/v{VERSION}` 形式で渡される
- スクリプトは bin ディレクトリから実行されるため、CHANGELOG は `../CHANGELOG.md` を参照
