# バッチ設計書 16-make_docs.ts

## 概要

本ドキュメントは、asciidoctor を使用して Etherpad Lite のドキュメントを生成する TypeScript スクリプト `make_docs.ts` のバッチ設計書です。

### 本バッチの処理概要

本バッチは、Etherpad Lite のソースドキュメント（AsciiDoc 形式）を HTML 形式に変換し、配布用ドキュメントを生成します。リリースプロセスの一環として、または開発中のドキュメント確認のために使用されます。

**業務上の目的・背景**：Etherpad Lite は開発者向けの API ドキュメントやユーザーガイドを提供しています。これらのドキュメントは AsciiDoc 形式で記述されており、ユーザーが閲覧できる HTML 形式に変換する必要があります。本バッチはこの変換プロセスを自動化し、一貫した品質のドキュメント生成を実現します。

**バッチの実行タイミング**：リリース時に `release.ts` から呼び出されます（`pnpm run makeDocs`）。また、開発中のドキュメント確認のために手動で実行することもできます。

**主要な処理内容**：
1. asciidoctor のインストール確認
2. 出力ディレクトリ（../out/doc、../out/doc/api）の作成
3. メインドキュメント（../doc/index.adoc 等）の HTML 変換
4. API ドキュメント（../doc/api/*.adoc）の HTML 変換
5. 静的ファイル（../doc/public/）の出力ディレクトリへのコピー

**前後の処理との関連**：`release.ts` の一部として実行され、生成されたドキュメントは `ether.github.com` リポジトリにコピーされます。

**影響範囲**：../out/doc/ ディレクトリ以下にドキュメントを生成します。既存のファイルは上書きされます。

## バッチ種別

ドキュメント生成処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時、開発時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / pnpm run makeDocs / release.ts |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | TypeScript 実行環境 |
| asciidoctor | AsciiDoc → HTML 変換ツール |
| src/package.json | バージョン番号の読み取り元 |

### 実行可否判定

- asciidoctor がインストールされていること（`asciidoctor -v` が成功）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ../doc/index.adoc | AsciiDoc | メインドキュメント |
| ../*/**.adoc | AsciiDoc | サブディレクトリのドキュメント |
| ../doc/api/*.adoc | AsciiDoc | API ドキュメント |
| ../doc/public/ | 各種 | 静的ファイル（画像、CSS等） |
| ../src/package.json | JSON | バージョン番号 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ../out/doc/ | HTML | メインドキュメント |
| ../out/doc/api/ | HTML | API ドキュメント |
| ../out/doc/ | 各種 | 静的ファイルのコピー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 出力先ルート | ../out/doc/ |
| API ドキュメント | ../out/doc/api/ |
| ファイル形式 | HTML |
| バージョン埋め込み | VERSION 変数として AsciiDoc に渡される |

## 処理フロー

### 処理シーケンス

```
1. バージョン番号読み込み
   └─ src/package.json から version を取得
2. asciidoctor インストール確認
   └─ asciidoctor -v を実行、失敗時はエラー終了
3. 出力ディレクトリ作成
   ├─ ../out ディレクトリ作成
   ├─ ../out/doc ディレクトリ作成
   └─ ../out/doc/api ディレクトリ作成
4. メインドキュメント変換
   └─ asciidoctor -D ../out/doc ../doc/index.adoc ../*/**.adoc -a VERSION={VERSION}
5. API ドキュメント変換
   └─ asciidoctor -D ../out/doc/api ../doc/api/*.adoc -a VERSION={VERSION}
6. 静的ファイルコピー
   └─ ../doc/public/ を ../out/doc/ にコピー
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[バージョン番号読み込み]
    B --> C{asciidoctor確認}
    C -->|未インストール| D[エラー終了]
    C -->|インストール済| E[出力ディレクトリ作成]
    E --> F[メインドキュメント変換]
    F --> G[APIドキュメント変換]
    G --> H[静的ファイルコピー]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ツール不在 | asciidoctor 未インストール | asciidoctor をインストール |
| (例外) | ファイル読み込み失敗 | ソースファイルが存在しない | ファイルパスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- asciidoctor のインストール手順を案内（https://asciidoctor.org/docs/install-toolchain/）
- ソースファイルの存在を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 複数の AsciiDoc ファイル |
| 目標処理時間 | 1-2 分 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定されていない。同一ディレクトリへの出力で競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 開始時 | "Building docs for version {VERSION}" |
| エラーログ | asciidoctor 不在時 | "Please install asciidoctor" + インストール URL |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- asciidoctor の `-a VERSION={VERSION}` オプションでバージョン番号をドキュメントに埋め込み
- 静的ファイルコピーは copyFolderSync 関数で再帰的に実行
- 既存の出力ディレクトリは削除してから作成される（copyFolderSync 内で rmSync を実行）
- exec 関数は非同期で実行されるが、スクリプトは待機しない設計
