# バッチ設計書 17-migrateDB.ts

## 概要

本ドキュメントは、異なるデータベース間でデータを移行するための TypeScript スクリプト `migrateDB.ts` のバッチ設計書です。

### 本バッチの処理概要

本バッチは、ueberdb2 ライブラリを使用して、ソースデータベースから対象データベースへ全データをコピーします。データベースの種類（dirty, sqlite, mysql, postgres 等）を問わず、設定ファイルで指定された接続情報に基づいて移行を実行します。

**業務上の目的・背景**：Etherpad Lite は様々なデータベースバックエンドをサポートしています（DirtyDB、SQLite、MySQL、PostgreSQL 等）。運用環境の変更やスケーリングに伴い、データベースを移行する必要が生じることがあります。本バッチはこの移行作業を自動化し、データ損失のリスクを低減しながら効率的な移行を実現します。

**バッチの実行タイミング**：データベース移行が必要な際に手動で実行します。計画メンテナンス時や、開発環境から本番環境への移行時に使用されます。

**主要な処理内容**：
1. コマンドライン引数から設定ファイルパスを取得
2. ソースデータベースと対象データベースの設定ファイルを読み込み
3. 両方のデータベースを初期化
4. ソースデータベースから全キーを取得
5. 各キーの値を読み取り、対象データベースに書き込み
6. 完了メッセージを出力

**前後の処理との関連**：本バッチは単独で使用されます。移行前に Etherpad を停止し、移行完了後に設定を更新して再起動する必要があります。

**影響範囲**：対象データベースにデータを書き込みます。既存データがある場合は上書きされます。

## バッチ種別

データ連携処理（データベース移行）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（移行時） |
| 実行時刻 | 計画メンテナンス時 |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | TypeScript 実行環境 |
| pnpm | パッケージマネージャ |
| ソースDB設定ファイル | JSON形式の接続設定 |
| 対象DB設定ファイル | JSON形式の接続設定 |
| Etherpad停止 | データ整合性のため推奨 |

### 実行可否判定

- 引数が4つ（--file1, ソースファイル, --file2, 対象ファイル）指定されていること
- 設定ファイルが存在し、読み取り可能であること
- データベースに接続可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --file1 | フラグ | Yes | - | ソースDB設定ファイル指定 |
| source.json | 文字列 | Yes | - | ソースDB設定ファイルパス |
| --file2 | フラグ | Yes | - | 対象DB設定ファイル指定 |
| target.json | 文字列 | Yes | - | 対象DB設定ファイルパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| source.json | JSON | ソースDBの接続設定 |
| target.json | JSON | 対象DBの接続設定 |
| ソースDB | 各種 | 移行元データ |

### 設定ファイル形式

```json
{
  "dbType": "<your-db-type>",
  "dbSettings": {
    <your-db-settings>
  }
}
```

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 対象DB | 各種 | 移行されたデータ |
| 標準出力 | テキスト | 進捗・完了メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 出力先 | 設定ファイルで指定されたデータベース |

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ 4つの引数が指定されていることを確認
2. 設定ファイル読み込み
   ├─ --file1/--file2 の順序を解析
   ├─ ソースDB設定を読み込み
   └─ 対象DB設定を読み込み
3. ファイルパス解決
   └─ filename設定がある場合、settings.root からの相対パスに変換
4. データベース初期化
   ├─ ソースDB (ueberdb1) を初期化
   └─ 対象DB (ueberdb2) を初期化
5. データ同期
   ├─ ソースDBから全キーを取得（findKeys('*', '')）
   ├─ 各キーの値を取得
   └─ 対象DBに書き込み
6. 完了処理
   └─ "Done syncing dbs" を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数数チェック}
    B -->|4未満| C[エラー終了]
    B -->|4| D[設定ファイル読み込み]
    D --> E[パス解決]
    E --> F[ソースDB初期化]
    F --> G[対象DB初期化]
    G --> H[全キー取得]
    H --> I[キーループ開始]
    I --> J[値取得]
    J --> K[対象DBに書き込み]
    K --> L{次のキーあり?}
    L -->|Yes| I
    L -->|No| M[完了メッセージ出力]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 全キー取得 | ソースDB store | SELECT | findKeys('*', '') で全キー取得 |
| 値取得 | ソースDB store | SELECT | 各キーの値を取得 |
| 値書き込み | 対象DB store | INSERT/UPDATE | キー・値ペアを書き込み |

### テーブル別操作詳細

#### store テーブル（ueberdb2 標準）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | key | * | ワイルドカードで全キー取得 |
| SELECT | value | key = {各キー} | キーに対応する値を取得 |
| SET | key, value | ソースDBから取得した値 | 対象DBに書き込み |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数不足 | 引数が4つ未満 | 正しい形式で再実行 |
| (例外) | ファイル読み込み失敗 | 設定ファイルが存在しない | ファイルパスを確認 |
| (例外) | DB接続失敗 | 接続設定が不正 | 設定内容を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- エラーメッセージを確認し、設定ファイルや接続情報を修正
- 部分的に移行されたデータは対象DBに残る可能性あり

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | レコード単位 |
| コミットタイミング | ueberdb2 のデフォルト動作 |
| ロールバック条件 | 個別エラー時は継続 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | データ量依存 |
| 目標処理時間 | データ量依存 |
| メモリ使用量上限 | 全キーをメモリに保持するため注意 |

## 排他制御

- Etherpad を停止してから実行することを推奨
- 同時実行は想定されていない

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 設定ログ | 起動時 | 対象DB設定、ファイルパス |
| 完了ログ | 正常終了時 | "Done syncing dbs" |
| エラーログ | エラー発生時 | "Error syncing db {エラー内容}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- ueberdb2 ライブラリを使用してデータベースを抽象化
- 設定ファイルの `dbType` には dirty, sqlite, mysql, postgres 等を指定
- `filename` 設定がある場合、settings.root からの相対パスとして解決される
- 実行コマンド例: `pnpm run --filter bin migrateDB --file1 source.json --file2 target.json`
- 大量データの場合、メモリ使用量に注意が必要
