# バッチ設計書 18-migrateDirtyDBtoRealDB.ts

## 概要

本ドキュメントは、DirtyDB（開発用簡易データベース）から本番用データベースへデータを移行するための TypeScript スクリプト `migrateDirtyDBtoRealDB.ts` のバッチ設計書です。

### 本バッチの処理概要

本バッチは、Etherpad のデフォルトデータストアである DirtyDB から、settings.json で設定された本番用データベース（MySQL、PostgreSQL、SQLite 等）へ全データを移行します。開発環境から本番環境への移行時に使用されます。

**業務上の目的・背景**：Etherpad Lite は初期状態では DirtyDB（ファイルベースの簡易データベース）を使用します。これは開発やテストには便利ですが、本番環境では MySQL や PostgreSQL などの堅牢なデータベースが推奨されます。本バッチは、DirtyDB で蓄積されたパッドデータを本番用データベースへ移行することで、本番環境への移行を支援します。

**バッチの実行タイミング**：開発環境から本番環境への移行時、または DirtyDB から本番用データベースへの切り替え時に手動で実行します。

**主要な処理内容**：
1. settings.json から対象データベースの接続情報を読み込み
2. 対象データベースを初期化（キャッシュ無効、即時書き込みモード）
3. DirtyDB（var/dirty.db）を読み込み
4. DirtyDB から全キーを取得
5. 各キーの値を読み取り、対象データベースに書き込み
6. 100件ごとに進捗を出力
7. 全データ書き込み完了後、両データベースをクローズ

**前後の処理との関連**：本バッチ実行前に settings.json を本番用データベース設定に更新しておく必要があります。移行完了後、Etherpad は設定されたデータベースを使用して起動します。

**影響範囲**：settings.json で設定されたデータベースにデータを書き込みます。既存データがある場合は上書きされます。

## バッチ種別

データ連携処理（データベース移行）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（移行時） |
| 実行時刻 | 計画メンテナンス時 |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | TypeScript 実行環境 |
| settings.json | 本番用データベース設定が完了 |
| var/dirty.db | DirtyDB ファイルが存在 |
| Etherpad停止 | データ整合性のため必須 |

### 実行可否判定

- settings.json に正しいデータベース設定があること
- var/dirty.db が存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| settings.json | JSON | 対象データベースの接続設定 |
| var/dirty.db | DirtyDB | 移行元データ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 設定されたDB | 各種 | 移行されたデータ |
| 標準出力 | テキスト | 進捗・完了メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 出力先 | settings.json で設定されたデータベース |

## 処理フロー

### 処理シーケンス

```
1. 設定読み込み
   └─ settings モジュールから dbType, dbSettings を取得
2. 対象データベース初期化
   ├─ キャッシュ: 0（無効化）
   ├─ writeInterval: 0（即時書き込み）
   └─ ueberdb2 Database インスタンス作成・初期化
3. DirtyDB 読み込み
   ├─ "Waiting for dirtyDB to parse its file." メッセージ出力
   └─ __dirname/../var/dirty.db を読み込み・初期化
4. 全キー取得
   └─ dirty.findKeys('*', '') で全キー取得
5. データ移行ループ
   ├─ "Found {n} records, processing now." メッセージ出力
   ├─ 各キーの値を取得
   ├─ 対象DBに set で書き込み
   └─ 100件ごとに "Wrote record {n} of {total}" を出力
6. 完了処理
   ├─ 全 Promise を待機（Promise.all）
   ├─ "Wrote all {n} records" メッセージ出力
   ├─ 両データベースをクローズ
   └─ "Finished." メッセージ出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[settings.json読み込み]
    B --> C[対象DB初期化]
    C --> D[DirtyDB読み込み・初期化]
    D --> E[全キー取得]
    E --> F[レコード数表示]
    F --> G[キーループ開始]
    G --> H[値取得]
    H --> I[対象DBに書き込み]
    I --> J{100件ごと?}
    J -->|Yes| K[進捗表示]
    J -->|No| L{次のキーあり?}
    K --> L
    L -->|Yes| G
    L -->|No| M[全Promise待機]
    M --> N[完了メッセージ出力]
    N --> O[DBクローズ]
    O --> P[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 全キー取得 | DirtyDB | SELECT | findKeys('*', '') で全キー取得 |
| 値取得 | DirtyDB | SELECT | 各キーの値を取得 |
| 値書き込み | 対象DB store | INSERT/UPDATE | キー・値ペアを書き込み |

### テーブル別操作詳細

#### store テーブル（ueberdb2 標準）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | key | * | DirtyDB から全キー取得 |
| SELECT | value | key = {各キー} | DirtyDB からキーに対応する値を取得 |
| SET | key, value | DirtyDB から取得した値 | 対象DB に書き込み |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| (例外) | 設定読み込み失敗 | settings.json が不正 | 設定内容を確認 |
| (例外) | DirtyDB読み込み失敗 | dirty.db が存在しない | ファイルパスを確認 |
| (例外) | DB接続失敗 | 接続設定が不正 | 設定内容を確認 |
| (例外) | 書き込み失敗 | 対象DB のエラー | 対象DB の状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- unhandledRejection を例外に変換するため、エラー時はプロセス終了
- 部分的に移行されたデータは対象DBに残る可能性あり
- 再実行で上書き可能

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | レコード単位 |
| コミットタイミング | 即時（writeInterval: 0） |
| ロールバック条件 | 個別エラー時は reject |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | データ量依存 |
| 目標処理時間 | データ量依存 |
| メモリ使用量上限 | 大量データ時は --max-old-space-size=4096 オプション推奨 |

## 排他制御

- Etherpad を停止してから実行することが必須
- dirty.db へのアクセス競合を防ぐため

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | DirtyDB読み込み時 | "Waiting for dirtyDB to parse its file." |
| 情報ログ | キー取得後 | "Found {n} records, processing now." |
| 進捗ログ | 100件ごと | "Wrote record {n} of {total}" |
| 完了ログ | 全件書き込み後 | "Wrote all {n} records" |
| 完了ログ | 終了時 | "Finished." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- 大量データの場合は `node --max-old-space-size=4096 src/bin/migrateDirtyDBtoRealDB.js` で実行
- settings.json を事前に本番用データベース設定に更新しておくこと
- dirty.db のバックアップを取得してから実行することを推奨
- キャッシュ無効（cache: '0'）と即時書き込み（writeInterval: 0）でパフォーマンスよりデータ整合性を優先
- log4js を使用して ueberDB のログを記録
