# バッチ設計書 2-safeRun.sh

## 概要

本ドキュメントは、Etherpadの自動再起動機能付き起動スクリプト`safeRun.sh`の設計仕様を記載したものである。エラー発生時に自動的にEtherpadを再起動し、オプションでメール通知を送信する。

### 本バッチの処理概要

Etherpadをプロダクション環境で安定的に運用するためのラッパースクリプトである。`run.sh`を内部で呼び出し、プロセスが終了した場合に自動的に再起動を行う無限ループ構造を持つ。

**業務上の目的・背景**：本番環境においてEtherpadサーバーが予期せぬエラーで停止した場合、サービス停止時間を最小化する必要がある。人手による監視・再起動対応はコストが高く、対応の遅延も発生しやすい。このスクリプトは自動再起動機能を提供することで、サービスの高可用性を実現し、運用負荷を軽減する。また、エラー発生時のメール通知機能により、運用担当者がサービスの異常を迅速に把握できる。

**バッチの実行タイミング**：本番環境でEtherpadを起動する際に使用する。通常、システム起動時のinitスクリプトやsystemdから呼び出される。一度起動すると、明示的に停止されるまで無限に実行を継続する。

**主要な処理内容**：
1. ログファイルパスの検証（第1引数として必須）
2. 無限ループによる`run.sh`の実行と監視
3. プロセス終了時の再起動処理（10秒のクールダウン付き）
4. オプションのメール通知機能（最後の50行のログを送信）
5. 再起動イベントのログファイルへの記録

**前後の処理との関連**：本スクリプトは`run.sh`を内部で呼び出すため、`run.sh`の処理（依存関係インストール、Admin UIビルド、サーバー起動）が前提となる。本スクリプト自体は終了しないため、後続処理は存在しない。

**影響範囲**：Etherpadサービスの可用性に直接影響する。再起動時にはサービスが一時的に利用不可となる（10秒のクールダウン + 起動時間）。メール通知機能を有効にした場合、メールサーバーへの通信が発生する。

## バッチ種別

起動処理 / 監視・自動復旧

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動/システム起動時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / システム起動時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ログファイル | 書き込み可能なログファイルパスを第1引数で指定すること |
| run.sh | bin/run.shが実行可能であること |
| mailコマンド | メール通知を使用する場合、mailコマンドが利用可能であること |

### 実行可否判定

- 第1引数（ログファイルパス）が指定されていない場合、エラー終了
- 指定されたログファイルが書き込み不可の場合、エラー終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (LOG) | 文字列 | Yes | なし | ログファイルのパス |
| その他 | 任意 | No | - | run.shに渡される引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| なし | - | 外部データソースは使用しない |

### 設定変数

| 変数名 | デフォルト値 | 説明 |
|-------|-------------|------|
| ERROR_HANDLING | 0 | エラー通知モード（0: 無効、1: メール送信） |
| EMAIL_ADDRESS | no-reply@example.com | 通知先メールアドレス |
| TIME_BETWEEN_EMAILS | 600 | メール送信の最小間隔（秒） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ログファイル | テキスト | run.shの標準出力・標準エラー出力、再起動イベント |
| メール | テキスト | エラー時のログ最後50行（通知有効時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 第1引数で指定されたファイル名 |
| 出力先 | 第1引数で指定されたパス |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ ログファイルパスが指定されているか確認
2. 無限ループ開始
   ├─ 3. ログファイル存在・書き込み可能チェック
   │   └─ 存在しない場合は作成を試みる
   ├─ 4. run.sh実行
   │   └─ 標準出力・標準エラーをログファイルにリダイレクト
   ├─ 5. プロセス終了検知
   │   └─ run.shが終了した場合
   ├─ 6. メール通知（オプション）
   │   └─ ERROR_HANDLING=1の場合、最後の50行をメール送信
   ├─ 7. 再起動イベントログ記録
   │   └─ タイムスタンプ付きで"RESTART!"をログに追記
   └─ 8. クールダウン待機（10秒）
       └─ 連続再起動を防止
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{ログファイル引数あり?}
    B -->|No| C[エラー終了]
    B -->|Yes| D[無限ループ開始]
    D --> E{ログファイル書き込み可能?}
    E -->|No| F{ファイル作成可能?}
    F -->|No| C
    F -->|Yes| G[ファイル作成]
    G --> H[run.sh実行]
    E -->|Yes| H
    H --> I[プロセス終了を待機]
    I --> J{ERROR_HANDLING=1?}
    J -->|Yes| K{前回メールから600秒経過?}
    K -->|Yes| L[メール送信]
    K -->|No| M[メールスキップ]
    L --> N[再起動ログ記録]
    M --> N
    J -->|No| N
    N --> O[10秒待機]
    O --> D
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチは直接的なデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチでは直接操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | ログファイルパスが未指定 | 第1引数にログファイルパスを指定 |
| 1 | ファイルエラー | ログファイルが書き込み不可 | ファイル/ディレクトリのパーミッション確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無限（自動再起動） |
| リトライ間隔 | 10秒 |
| リトライ対象エラー | run.shの終了（正常/異常問わず） |

### 障害時対応

1. ログファイルを確認し、エラーの原因を特定する
2. 無限再起動ループに陥っている場合は、手動でプロセスを停止
3. 根本原因を解決後、再度safeRun.shを起動する
4. メール通知が届いていない場合、メールサーバーの設定を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロセス（無限実行） |
| 目標処理時間 | 該当なし（常駐プロセス） |
| メモリ使用量上限 | シェルプロセス + run.shのメモリ使用量 |

## 排他制御

- 同一ログファイルを指定した複数インスタンスの同時実行は推奨されない
- 複数インスタンスを起動すると、ログが混在する可能性がある

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| アプリケーションログ | 常時 | run.shからの標準出力・標準エラー |
| 再起動ログ | 再起動時 | "RESTART! {タイムスタンプ}" |
| エラーログ | エラー発生時 | ログファイル書き込みエラー等 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 再起動回数 | 多発時（10分間に複数回） | EMAIL_ADDRESSで設定したアドレス |
| プロセス生存確認 | 停止時 | 外部監視システム |

## 備考

- メール通知機能を使用する場合は、ERROR_HANDLING=1に設定し、EMAIL_ADDRESSを適切に設定すること
- TIME_BETWEEN_EMAILS（デフォルト600秒）により、連続エラー時のメールスパムを防止している
- 本番環境では、systemdなどのプロセス管理ツールと組み合わせて使用することを推奨
- 10秒のクールダウンにより、設定エラー等による無限高速再起動ループを防止している
