# バッチ設計書 20-checkAllPads.ts

## 概要

本ドキュメントは、全てのパッドのデータ整合性をチェックするためのデバッグツール `checkAllPads.ts` のバッチ設計書です。

### 本バッチの処理概要

本バッチは、Etherpad に保存されている全てのパッドに対してデータ整合性チェックを実行し、問題のあるパッドを特定します。データ破損の検出やシステム健全性の確認に使用されるデバッグツールです。

**業務上の目的・背景**：Etherpad のパッドデータは、リビジョン履歴、属性プール、チェンジセットなど複雑な構造を持っています。システム障害、不適切なプラグイン、バグなどによりデータ整合性が損なわれる可能性があります。本バッチは全パッドをスキャンし、整合性チェック（pad.check() メソッド）を実行することで、問題のあるパッドを早期に発見し、データ修復の必要性を判断するための情報を提供します。

**バッチの実行タイミング**：定期的な健全性チェック、問題発生時の診断、またはデータ移行後の検証時に手動で実行します。

**主要な処理内容**：
1. データベースを初期化
2. PadManager から全パッドの ID リストを取得
3. 各パッドに対して並列で整合性チェックを実行
4. チェック結果（OK またはエラー）を出力
5. 全チェック完了後に終了

**前後の処理との関連**：問題が検出されたパッドは、`checkPad.ts`（個別チェック）、`repairPad.ts`（修復）、`rebuildPad.ts`（再構築）などの関連ツールで対処できます。

**影響範囲**：読み取り専用の処理であり、データベースへの変更はありません。ただし、大量のパッドがある場合はシステム負荷が増加する可能性があります。

## バッチ種別

データ整合性チェック処理（デバッグツール）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（診断時） |
| 実行時刻 | 低負荷時間帯推奨 |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | TypeScript 実行環境 |
| settings.json | データベース設定が完了 |
| Etherpad データベース | アクセス可能 |

### 実行可否判定

- コマンドライン引数なしで実行すること（引数があるとエラー）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けない（引数があるとエラー） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| settings.json | JSON | データベースの接続設定 |
| Etherpad DB | 各種 | パッドデータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各パッドのチェック結果 |
| 標準エラー | テキスト | エラー情報 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 出力先 | 標準出力 / 標準エラー |
| 正常時 | "Pad {padId}: OK" |
| 異常時 | "Error in pad {padId}: {エラー詳細}" |
| 完了時 | "Finished." |

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ process.argv.length === 2 であることを確認
2. データベース初期化
   └─ db.init() を実行
3. パッド一覧取得
   └─ padManager.listAllPads() で全パッドIDを取得
4. 並列チェック実行
   ├─ Promise.all で全パッドを並列処理
   ├─ 各パッドで padManager.getPad() を実行
   └─ 各パッドで pad.check() を実行
5. 結果出力
   ├─ 正常: "Pad {padId}: OK"
   └─ 異常: "Error in pad {padId}: {error.stack || error}"
6. 完了処理
   └─ "Finished." を出力して終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|引数あり| C[エラー終了]
    B -->|引数なし| D[DB初期化]
    D --> E[全パッドID取得]
    E --> F[Promise.all並列処理]
    F --> G[パッド取得]
    G --> H[pad.check実行]
    H --> I{チェック結果}
    I -->|OK| J[OK出力]
    I -->|Error| K[エラー出力]
    J --> L{全パッド完了?}
    K --> L
    L -->|No| G
    L -->|Yes| M[Finished出力]
    M --> N[process.exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パッド一覧取得 | store | SELECT | 全パッドIDを取得 |
| パッドデータ取得 | store | SELECT | 各パッドのデータを取得 |
| 整合性チェック | store | SELECT | リビジョン、属性等を読み取り |

### テーブル別操作詳細

#### store テーブル（ueberdb2 標準）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | key, value | pad:* | 全パッドIDを取得 |
| SELECT | key, value | pad:{padId}:* | 各パッドの関連データを取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| (例外) | 引数エラー | コマンドライン引数が指定された | 引数なしで再実行 |
| (例外) | DB接続失敗 | 接続設定が不正 | 設定内容を確認 |
| (例外) | パッド整合性エラー | パッドデータが破損 | repairPad.ts で修復を検討 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- 整合性エラーが検出されたパッドは、`checkPad.ts` で詳細確認
- 必要に応じて `repairPad.ts` または `rebuildPad.ts` で修復

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 全パッド数 |
| 目標処理時間 | パッド数・サイズ依存 |
| メモリ使用量上限 | 並列処理のためパッド数に比例 |

## 排他制御

- 読み取り専用処理のため、排他制御は不要
- Etherpad 稼働中でも実行可能（ただし、負荷に注意）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | 各パッドチェック後 | "Pad {padId}: OK" |
| エラーログ | 整合性エラー検出時 | "Error in pad {padId}: {error}" |
| 完了ログ | 全チェック完了時 | "Finished." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー件数 | 1件以上 | 管理者（手動確認） |

## 備考

- 実行コマンド: `node bin/checkAllPads.js`
- 引数があると `Use: node bin/checkAllPads.js` エラーで終了
- Promise.all による並列処理のため、大量パッドでは高負荷になる可能性
- unhandledRejection を例外に変換するため、重大エラー時はプロセス終了
- 関連ツール: checkPad.ts（個別チェック）、repairPad.ts（修復）、rebuildPad.ts（再構築）
- pad.check() メソッドはパッド内部の整合性（リビジョン、属性プール、チェンジセット等）を検証
