# バッチ設計書 21-checkPad

## 概要

本ドキュメントは、指定したパッドのデータ整合性をチェックするデバッグツール「checkPad.ts」の設計仕様を定義する。

### 本バッチの処理概要

checkPad.tsは、Etherpadの個別パッドに対してデータ整合性検証を実行するコマンドラインデバッグツールである。

**業務上の目的・背景**：Etherpadのパッドデータは、リビジョン履歴、チャットメッセージ、著者情報など複数のデータベースエントリで構成される複雑な構造を持つ。運用中にデータ破損や不整合が発生した場合、問題の特定と修復が困難となる。本バッチは、特定のパッドを対象としてデータの一貫性を検証し、問題箇所を特定するためのデバッグツールとして提供される。

**バッチの実行タイミング**：手動実行のみ。パッドに問題が発生した疑いがある場合、または定期的なデータ健全性チェックとして運用者が任意に実行する。

**主要な処理内容**：
1. コマンドライン引数からパッドIDを取得
2. データベース接続を初期化
3. 指定されたパッドの存在確認
4. パッドオブジェクトを取得
5. Pad.check()メソッドを呼び出し、パッドの整合性検証を実行

**前後の処理との関連**：本バッチは単独で動作し、他のバッチとの依存関係はない。ただし、問題が検出された場合は、rebuildPad.tsやrepairPad.tsによる修復処理が後続として実行される可能性がある。

**影響範囲**：読み取り専用の検証処理であり、データベースの内容を変更しない。システムへの影響は最小限である。

## バッチ種別

データ検証 / デバッグツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v14以上が必要 |
| データベース接続 | Etherpadデータベースにアクセス可能であること |
| パッドID指定 | コマンドライン引数でパッドIDが指定されていること |

### 実行可否判定

コマンドライン引数が3つ（node, スクリプトパス, パッドID）でない場合はエラーで終了する。指定されたパッドが存在しない場合もエラーで終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PADID | string | Yes | - | チェック対象のパッドID |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| pad:{padId} | DB | パッドのメタデータ |
| pad:{padId}:revs:{rev} | DB | 各リビジョンのチェンジセット |
| pad:{padId}:chat:{n} | DB | チャットメッセージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | チェック結果のログ |

### 出力ファイル仕様

本バッチはファイル出力を行わない。結果は標準出力にログとして出力される。

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数検証
   └─ 引数が3つでない場合はエラーで終了
2. パッドIDの取得
   └─ process.argv[2]からパッドIDを取得
3. データベース初期化
   └─ db.init()を呼び出し
4. パッド存在確認
   └─ padManager.doesPadExists(padId)で確認
5. パッドオブジェクト取得
   └─ padManager.getPad(padId)でパッドを取得
6. 整合性チェック実行
   └─ pad.check()メソッドを呼び出し
7. 結果出力
   └─ 成功/失敗をコンソールに出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|引数不正| C[エラー終了]
    B -->|引数OK| D[DB初期化]
    D --> E{パッド存在確認}
    E -->|存在しない| F[エラー: Pad does not exist]
    E -->|存在する| G[パッドオブジェクト取得]
    G --> H[pad.check実行]
    H --> I{チェック結果}
    I -->|成功| J[Finished checking pad]
    I -->|失敗| K[エラー詳細出力]
    J --> L[正常終了 exit 0]
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パッド存在確認 | pad:{padId} | SELECT | パッドの存在確認 |
| パッド取得 | pad:{padId} | SELECT | パッドメタデータ読み込み |
| リビジョン検証 | pad:{padId}:revs:* | SELECT | 全リビジョンの整合性チェック |
| チャット検証 | pad:{padId}:chat:* | SELECT | 全チャットメッセージの整合性チェック |

### テーブル別操作詳細

#### pad:{padId}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | atext, pool, head, chatHead, savedRevisions | パッドID指定 | パッド基本情報の取得 |

#### pad:{padId}:revs:{rev}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | changeset, meta | 0からheadまでの全リビジョン | 各リビジョンのチェンジセット検証 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | コマンドライン引数が不足 | 正しい引数でコマンドを再実行 |
| - | パッド未存在 | 指定パッドがDBに存在しない | パッドIDを確認して再実行 |
| - | 整合性エラー | pad.check()で不整合を検出 | rebuildPad.tsまたはrepairPad.tsで修復 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

整合性エラーが検出された場合は、エラーメッセージの内容を確認し、rebuildPad.tsまたはrepairPad.tsを使用してパッドの修復を試みる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1パッド |
| 目標処理時間 | リビジョン数に依存（100リビジョン/秒程度を想定） |
| メモリ使用量上限 | パッドサイズに依存 |

## 排他制御

読み取り専用処理のため、排他制御は不要。ただし、Etherpad稼働中に実行する場合は、パッドへの同時書き込みが発生する可能性があることに留意する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | パッド存在確認時 | "Checking if {padId} exists" |
| 終了ログ | チェック完了時 | "Finished checking pad." |
| エラーログ | エラー発生時 | "Finished with errors" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のデバッグツールであり、監視対象外とする。

## 備考

- 本バッチはEtherpad稼働中でも実行可能だが、データの一貫性を保証するためには、可能であればEtherpadを停止してから実行することが推奨される
- pad.check()メソッドは、リビジョン、チャットメッセージ、著者情報、AttributePoolなどの整合性を包括的に検証する
- 全パッドを一括でチェックする場合は、checkAllPads.tsを使用する
