# バッチ設計書 22-deletePad

## 概要

本ドキュメントは、CLIからパッドを削除するスクリプト「deletePad.ts」の設計仕様を定義する。

### 本バッチの処理概要

deletePad.tsは、Etherpad APIを使用してコマンドラインから指定したパッドを削除するユーティリティツールである。

**業務上の目的・背景**：Etherpadの運用において、不要になったパッドや問題のあるパッドを削除する必要が生じることがある。Web管理画面からの削除も可能だが、大量のパッド削除やスクリプトによる自動化、またはSSH経由でのサーバー操作時には、コマンドラインツールが有用である。本バッチは「時には窓を直すのにレンガが必要」というコメントが示すように、問題解決の最終手段として機能する。

**バッチの実行タイミング**：手動実行のみ。運用者が必要に応じて任意のタイミングで実行する。

**主要な処理内容**：
1. コマンドライン引数からパッドIDを取得
2. APIKEY.txtファイルからAPIキーを読み込み
3. Etherpad APIのバージョンを取得
4. deletePad APIエンドポイントを呼び出してパッドを削除
5. 削除結果を標準出力に表示

**前後の処理との関連**：本バッチは単独で動作する。削除前にパッドのバックアップが必要な場合は、extractPadData.tsを事前に実行することが推奨される。

**影響範囲**：指定されたパッドのすべてのデータ（リビジョン履歴、チャット、著者情報との関連）がデータベースから完全に削除される。この操作は取り消し不可能である。

## バッチ種別

データ削除 / 管理ツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Etherpad稼働中 | APIを使用するため、Etherpadサーバーが起動していること |
| APIKEY.txt存在 | プロジェクトルートにAPIKEY.txtファイルが存在すること |
| ネットワーク接続 | localhostへのHTTP接続が可能であること |

### 実行可否判定

コマンドライン引数が3つ（node, スクリプトパス, パッドID）でない場合はエラーで終了する。APIキーが無効な場合やパッドが存在しない場合はAPIエラーが返される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PADID | string | Yes | - | 削除対象のパッドID |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| APIKEY.txt | テキストファイル | Etherpad API認証キー |
| settings.json | JSON | Etherpadサーバー設定（IP、ポート） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 削除結果のログ |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数検証
   └─ 引数が3つでない場合はエラーで終了
2. パッドIDの取得
   └─ process.argv[2]からパッドIDを取得
3. APIキー読み込み
   └─ APIKEY.txtファイルからAPIキーを取得
4. APIバージョン取得
   └─ GET /api/ でcurrentVersionを取得
5. パッド削除API呼び出し
   └─ POST /api/{version}/deletePad を実行
6. 結果確認
   └─ レスポンスのcode値を確認（1の場合エラー）
7. 結果出力
   └─ 削除成功メッセージを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|引数不正| C[エラー終了]
    B -->|引数OK| D[APIキー読み込み]
    D --> E[APIバージョン取得]
    E --> F{バージョン取得成功?}
    F -->|失敗| G[エラー: No version set in API]
    F -->|成功| H[deletePad API呼び出し]
    H --> I{削除成功?}
    I -->|code=1| J[エラー: Error deleting pad]
    I -->|code=0| K[Deleted pad 出力]
    K --> L[正常終了 exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パッド削除 | pad:{padId} | DELETE | パッドメタデータ削除 |
| リビジョン削除 | pad:{padId}:revs:* | DELETE | 全リビジョン削除 |
| チャット削除 | pad:{padId}:chat:* | DELETE | 全チャットメッセージ削除 |
| 著者関連削除 | globalAuthor:* | UPDATE | 著者からパッド参照を削除 |
| 読み取り専用ID削除 | readonly2pad:*, pad2readonly:* | DELETE | 読み取り専用ID関連削除 |

### テーブル別操作詳細

#### pad:{padId}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | パッドID指定 | Pad.remove()メソッド経由で削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | コマンドライン引数が不足 | 正しい引数でコマンドを再実行 |
| - | APIバージョン取得失敗 | /api/エンドポイントが応答しない | Etherpadサーバーの起動状態を確認 |
| 1 | API削除エラー | パッドが存在しない、APIキー無効など | パッドIDとAPIキーを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

削除が失敗した場合は、APIレスポンスのエラーメッセージを確認する。パッドが存在しない場合は、パッドIDを確認する。APIキーが無効な場合は、APIKEY.txtの内容を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | API側で管理 |
| コミットタイミング | API処理完了時 |
| ロールバック条件 | APIエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1パッド |
| 目標処理時間 | パッドサイズに依存（通常数秒以内） |
| メモリ使用量上限 | 通常のNode.js制限内 |

## 排他制御

Etherpad APIが内部的に排他制御を行う。パッド削除時には、padMessageHandler.kickSessionsFromPad()により、接続中のすべてのクライアントが強制切断される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | 削除成功時 | "Deleted pad" + APIレスポンス |
| エラーログ | 削除失敗時 | "Error deleting pad" + エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のツールであり、監視対象外とする。

## 備考

- 削除操作は取り消し不可能であるため、重要なパッドは事前にextractPadData.tsでバックアップを取得することを推奨
- 本バッチはEtherpadサーバーが起動している状態で実行する必要がある
- グループパッド（$を含むパッドID）の場合、グループからのパッド参照も削除される
- APIを使用するため、settings.jsonで設定されたIP/ポートに接続できる必要がある
