# バッチ設計書 23-extractPadData

## 概要

本ドキュメントは、パッドのデータをdirtydbファイルとして抽出するデバッグツール「extractPadData.ts」の設計仕様を定義する。

### 本バッチの処理概要

extractPadData.tsは、指定したパッドの全データをdirtydbフォーマットのファイルとして抽出するデバッグ・バックアップツールである。

**業務上の目的・背景**：本番環境で発生したバグを開発環境で再現・デバッグする際、問題が発生したパッドのデータを本番環境から抽出し、開発環境に移行する必要がある。本バッチは、パッドの全データ（メタデータ、リビジョン履歴、チャットメッセージ、著者情報）をポータブルなdirtydb形式で出力することで、環境間でのデータ移行を可能にする。

**バッチの実行タイミング**：手動実行のみ。バグ調査時、バックアップ取得時、または環境移行時に運用者が任意に実行する。

**主要な処理内容**：
1. コマンドライン引数からパッドIDを取得
2. データベース接続を初期化
3. パッドオブジェクトを取得
4. 必要なDBキー（パッドメタデータ、リビジョン、チャット、著者情報）を収集
5. 各キーの値をデータベースから読み込み
6. dirtydbファイル（{padId}.db）として出力

**前後の処理との関連**：本バッチで抽出したデータは、開発環境でのデバッグや、データ復旧時のバックアップとして使用される。rebuildPad.tsやrepairPad.tsの実行前にバックアップとして実行することが推奨される。

**影響範囲**：読み取り専用の処理であり、データベースの内容を変更しない。カレントディレクトリに{padId}.dbファイルが作成される。

## バッチ種別

データ抽出 / バックアップ / デバッグツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v14以上が必要 |
| データベース接続 | Etherpadデータベースにアクセス可能であること |
| パッドID指定 | コマンドライン引数でパッドIDが指定されていること |
| 書き込み権限 | カレントディレクトリへの書き込み権限があること |

### 実行可否判定

コマンドライン引数が3つ（node, スクリプトパス, パッドID）でない場合はエラーで終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PADID | string | Yes | - | 抽出対象のパッドID |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| pad:{padId} | DB | パッドのメタデータ |
| pad:{padId}:revs:{rev} | DB | 各リビジョンのチェンジセット |
| pad:{padId}:chat:{n} | DB | チャットメッセージ |
| globalAuthor:{authorId} | DB | 著者情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {padId}.db | dirtydbファイル | パッドの全データを含むファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {padId}.db |
| 出力先 | カレントディレクトリ |
| 文字コード | UTF-8 |
| 形式 | dirtydb形式（改行区切りのJSON） |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数検証
   └─ 引数が3つでない場合はエラーで終了
2. パッドIDの取得
   └─ process.argv[2]からパッドIDを取得
3. 設定・データベース初期化
   └─ Settings読み込み、db.init()呼び出し
4. dirtyDBファイル初期化
   └─ {padId}.dbファイルを作成
5. パッドオブジェクト取得
   └─ padManager.getPad(padId)でパッドを取得
6. 必要キーの収集
   └─ パッドメタ、著者、リビジョン、チャットのキーを配列に格納
7. データ抽出・出力
   └─ 各キーの値をDBから取得しdirtyDBに書き込み
8. 完了出力
   └─ "finished"を出力して終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|引数不正| C[エラー終了]
    B -->|引数OK| D[DB初期化]
    D --> E[dirtyDBファイル作成]
    E --> F[パッドオブジェクト取得]
    F --> G[パッドメタキー追加]
    G --> H[著者キー追加]
    H --> I[リビジョンキー追加]
    I --> J[チャットキー追加]
    J --> K[各キーのデータ抽出]
    K --> L[dirtyDBに書き込み]
    L --> M[finished出力]
    M --> N[正常終了 exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パッド取得 | pad:{padId} | SELECT | パッドメタデータ読み込み |
| リビジョン取得 | pad:{padId}:revs:* | SELECT | 0からheadまでの全リビジョン |
| チャット取得 | pad:{padId}:chat:* | SELECT | 0からchatHeadまでの全チャット |
| 著者情報取得 | globalAuthor:* | SELECT | パッドに関連する全著者 |

### テーブル別操作詳細

#### pad:{padId}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全項目 | パッドID指定 | パッド基本情報の取得 |

#### globalAuthor:{authorId}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全項目 | pad.getAllAuthors()から取得した著者ID | 著者情報の取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | コマンドライン引数が不足 | 正しい引数でコマンドを再実行 |
| - | パッド未存在 | 指定パッドがDBに存在しない | パッドIDを確認して再実行 |
| - | ファイル書き込みエラー | ディスク容量不足、権限不足 | ディスク状態と権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

ファイル書き込みエラーが発生した場合は、ディスク容量と書き込み権限を確認する。中断された場合、不完全な.dbファイルが残る可能性があるため削除して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1パッド（リビジョン数・チャット数に依存） |
| 目標処理時間 | リビジョン数に依存 |
| メモリ使用量上限 | パッドサイズに依存 |

## 排他制御

読み取り専用処理のため、排他制御は不要。ただし、Etherpad稼働中に実行する場合、抽出中にパッドへの書き込みが発生すると、一貫性のないデータが出力される可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 終了ログ | 処理完了時 | "finished" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のデバッグツールであり、監視対象外とする。

## 備考

- 出力されるdirtydbファイルは、開発環境のEtherpadで直接使用できる（settings.jsonでdirtydb設定が必要）
- 大規模なパッド（多数のリビジョン）の場合、抽出に時間がかかる可能性がある
- 抽出したデータにはパスワードなどの機密情報は含まれないが、パッド内容自体が機密である場合は取り扱いに注意が必要
- JSONパースが必要な場合（文字列として格納されている値）は、自動的にJSON.parseが適用される
