# バッチ設計書 24-rebuildPad

## 概要

本ドキュメントは、パッドのデータを再挿入して修復するスクリプト「rebuildPad.ts」の設計仕様を定義する。

### 本バッチの処理概要

rebuildPad.tsは、指定したパッドのすべてのデータをデータベースから抽出し、削除した後、再挿入することでデータの修復を行う。

**業務上の目的・背景**：Etherpadのデータベースでは、データの断片化やインデックスの不整合が発生することがある。このような場合、データを削除して再挿入することでデータベースの状態を改善できる場合がある。本バッチは、パッドのデータを同じ値で再書き込みすることにより、データベースレベルでの修復を試みる。

**バッチの実行タイミング**：手動実行のみ。Etherpadを停止した状態で実行することが必須。パッドのデータに問題が発生した場合、または定期的なメンテナンスとして運用者が実行する。

**主要な処理内容**：
1. コマンドライン引数からパッドIDを取得
2. データベース接続を初期化
3. パッドオブジェクトを取得
4. 必要なDBキー（パッドメタデータ、リビジョン、チャット、著者情報）を収集
5. 各キーについて、値を取得→削除→再挿入を実行
6. 処理件数を出力

**前後の処理との関連**：本バッチを実行する前に、extractPadData.tsでバックアップを取得することを強く推奨する。問題が解決しない場合は、repairPad.tsでの再構築を検討する。

**影響範囲**：指定されたパッドのすべてのデータベースエントリが削除・再挿入される。Etherpad稼働中に実行すると深刻なデータ破損を引き起こす可能性がある。

## バッチ種別

データ修復 / メンテナンスツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意（Etherpad停止時） |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Etherpad停止 | Etherpadが停止していること（必須） |
| Node.js環境 | Node.js v14以上が必要 |
| データベース接続 | Etherpadデータベースにアクセス可能であること |
| パッドID指定 | コマンドライン引数でパッドIDが指定されていること |
| バックアップ取得 | 事前にextractPadData.tsでバックアップを取得することを推奨 |

### 実行可否判定

コマンドライン引数が3つ（node, スクリプトパス, パッドID）でない場合はエラーで終了する。Etherpad稼働中の実行は警告メッセージが表示されるが、処理は継続される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PADID | string | Yes | - | 修復対象のパッドID |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| pad:{padId} | DB | パッドのメタデータ |
| pad:{padId}:revs:{rev} | DB | 各リビジョンのチェンジセット |
| pad:{padId}:chat:{n} | DB | チャットメッセージ |
| globalAuthor:{authorId} | DB | 著者情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 処理進捗と結果のログ |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. 警告メッセージ出力
   └─ Etherpad稼働中は使用不可の警告
2. コマンドライン引数検証
   └─ 引数が3つでない場合はエラーで終了
3. パッドIDの取得
   └─ process.argv[2]からパッドIDを取得
4. 設定・データベース初期化
   └─ Settings読み込み、db.init()呼び出し
5. パッドオブジェクト取得
   └─ padManager.getPad(padId)でパッドを取得
6. 必要キーの収集
   └─ パッドメタ、著者、リビジョン、チャットのキーを配列に格納
7. 再挿入処理ループ
   └─ 各キーについて：値取得→削除→再挿入
8. 進捗表示
   └─ 100件ごとに進捗を出力
9. 完了出力
   └─ 処理件数を出力して終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[警告メッセージ出力]
    B --> C{引数チェック}
    C -->|引数不正| D[エラー終了]
    C -->|引数OK| E[DB初期化]
    E --> F[パッドオブジェクト取得]
    F --> G[必要キー収集]
    G --> H[パッドメタキー追加]
    H --> I[著者キー追加]
    I --> J[リビジョンキー追加]
    J --> K[チャットキー追加]
    K --> L{全キー処理完了?}
    L -->|No| M[値取得]
    M --> N[キー削除]
    N --> O[値再挿入]
    O --> P[カウンタ増加]
    P --> Q{100件ごと?}
    Q -->|Yes| R[進捗出力]
    Q -->|No| L
    R --> L
    L -->|Yes| S[完了メッセージ出力]
    S --> T[正常終了 exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 値取得 | pad:{padId}* | SELECT | 全関連データの読み込み |
| 削除 | pad:{padId}* | DELETE | 全関連データの削除 |
| 再挿入 | pad:{padId}* | INSERT | 同じ値で再挿入 |
| 著者情報取得 | globalAuthor:* | SELECT | 関連著者情報の読み込み |
| 著者情報削除 | globalAuthor:* | DELETE | 関連著者情報の削除 |
| 著者情報再挿入 | globalAuthor:* | INSERT | 同じ値で再挿入 |

### テーブル別操作詳細

#### pad:{padId}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全項目 | パッドID指定 | 値を一時保持 |
| DELETE | - | パッドID指定 | キー削除 |
| INSERT | 全項目 | 同じ値 | 再挿入 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | コマンドライン引数が不足 | 正しい引数でコマンドを再実行 |
| - | パッド未存在 | 指定パッドがDBに存在しない | パッドIDを確認して再実行 |
| - | DB操作エラー | データベース接続エラー | DB接続設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

処理中に中断された場合、パッドデータが不完全な状態になる可能性がある。事前に取得したバックアップ（extractPadData.ts）を使用してデータを復旧する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | キー単位 |
| コミットタイミング | 各キーの再挿入完了時 |
| ロールバック条件 | エラー発生時（部分的にロールバック不可） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | パッドのキー数（リビジョン数+チャット数+著者数+1） |
| 目標処理時間 | キー数に依存 |
| メモリ使用量上限 | パッドサイズに依存 |

## 排他制御

本バッチはEtherpad停止中に実行することが前提のため、排他制御は行わない。稼働中に実行した場合、データ破損が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | バッチ開始時 | "WARNING: This script must not be used while etherpad is running!" |
| 進捗ログ | 100件ごと | "{処理件数}/{総件数}" |
| 終了ログ | 処理完了時 | "Finished: Replaced {件数} values in the database" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のツールであり、監視対象外とする。

## 備考

- 本バッチは必ずEtherpadを停止してから実行すること
- 実行前にextractPadData.tsでバックアップを取得することを強く推奨
- globalAuthorデータも再挿入されるため、複数パッドで共有される著者情報に影響を与える可能性がある
- 処理は逐次的に行われるため、大規模パッドでは時間がかかる場合がある
