# バッチ設計書 26-createUserSession

## 概要

本ドキュメントは、テスト用ユーザーセッションを生成するスクリプト「createUserSession.ts」の設計仕様を定義する。

### 本バッチの処理概要

createUserSession.tsは、Etherpad APIを使用してテスト・デバッグ用のユーザーセッションを生成するユーティリティツールである。

**業務上の目的・背景**：Etherpadでは、グループパッドへのアクセスにはセッション認証が必要となる場合がある（requireAuthentication設定時など）。開発・テスト環境でセッション認証をテストする際、手動でセッションを作成するのは煩雑である。本バッチは、グループ、グループパッド、著者、セッションを一括で作成し、テスト用の完全なセッション環境を構築する。

**バッチの実行タイミング**：手動実行のみ。開発者やテスターがセッション認証のテスト・デバッグを行う際に実行する。

**主要な処理内容**：
1. Etherpad APIへの接続設定
2. APIキーの読み込み
3. APIバージョンの取得
4. グループの作成（createGroup API）
5. グループパッドの作成（createGroupPad API）
6. 著者の作成（createAuthor API）
7. セッションの作成（createSession API）
8. セッションID（Cookie値）の出力

**前後の処理との関連**：本バッチは単独で動作する。生成されたセッションIDは、ブラウザのCookieに設定することでグループパッドへのアクセスが可能になる。

**影響範囲**：新しいグループ、グループパッド、著者、セッションがデータベースに作成される。セッションの有効期限は実行時刻から約16時間（60000秒）。

## バッチ種別

テストデータ生成 / 開発支援ツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Etherpad稼働中 | APIを使用するため、Etherpadサーバーが起動していること |
| APIKEY.txt存在 | プロジェクトルートにAPIKEY.txtファイルが存在すること |
| ネットワーク接続 | 設定されたIP/ポートへのHTTP接続が可能であること |

### 実行可否判定

APIキーが無効な場合やEtherpadサーバーに接続できない場合はエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| APIKEY.txt | テキストファイル | Etherpad API認証キー |
| settings.json | JSON | Etherpadサーバー設定（IP、ポート） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 作成されたリソースの情報 |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. APIキー読み込み
   └─ APIKEY.txtファイルからAPIキーを取得
2. APIバージョン取得
   └─ GET /api/ でcurrentVersionを取得
3. グループ作成
   └─ POST /api/{version}/createGroup を実行
4. グループパッド作成
   └─ POST /api/{version}/createGroupPad を実行
5. 著者作成
   └─ POST /api/{version}/createAuthor を実行
6. セッション有効期限計算
   └─ 現在時刻 + 60000秒
7. セッション作成
   └─ POST /api/{version}/createSession を実行
8. 結果出力
   └─ セッションIDとCookie設定手順を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[APIキー読み込み]
    B --> C[APIバージョン取得]
    C --> D{バージョン取得成功?}
    D -->|No| E[エラー: No version set]
    D -->|Yes| F[createGroup API呼び出し]
    F --> G{グループ作成成功?}
    G -->|No| H[エラー: Error creating group]
    G -->|Yes| I[createGroupPad API呼び出し]
    I --> J{パッド作成成功?}
    J -->|No| K[エラー: Error creating group pad]
    J -->|Yes| L[createAuthor API呼び出し]
    L --> M{著者作成成功?}
    M -->|No| N[エラー: Error creating author]
    M -->|Yes| O[有効期限計算]
    O --> P[createSession API呼び出し]
    P --> Q{セッション作成成功?}
    Q -->|No| R[エラー: Error creating session]
    Q -->|Yes| S[セッションID出力]
    S --> T[正常終了 exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| グループ作成 | group:{groupId} | INSERT | 新規グループ作成 |
| グループパッド作成 | pad:{groupId}${padId} | INSERT | グループパッド作成 |
| 著者作成 | globalAuthor:{authorId} | INSERT | 著者情報作成 |
| セッション作成 | session:{sessionId} | INSERT | セッション情報作成 |

### テーブル別操作詳細

#### group:{groupId}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | pads | 空オブジェクト → グループパッド追加 | API経由で作成 |

#### session:{sessionId}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | groupID, authorID, validUntil | 作成時に設定 | 有効期限は60000秒後 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | APIバージョン取得失敗 | /api/エンドポイントが応答しない | Etherpadサーバーの起動状態を確認 |
| 1 | グループ作成エラー | API認証失敗など | APIキーを確認 |
| 1 | グループパッド作成エラー | 内部エラー | ログを確認 |
| 1 | 著者作成エラー | 内部エラー | ログを確認 |
| 1 | セッション作成エラー | パラメータ不正など | パラメータを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

エラーが発生した場合は、APIレスポンスのエラーメッセージを確認する。途中で失敗した場合、部分的にリソースが作成されている可能性がある。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各API呼び出し単位 |
| コミットタイミング | 各API処理完了時 |
| ロールバック条件 | エラー発生時（部分作成は残る） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1セット（グループ、パッド、著者、セッション） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 通常のNode.js制限内 |

## 排他制御

本バッチは排他制御を行わない。複数回実行すると、その都度新しいグループ、パッド、著者、セッションが作成される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | APIバージョン取得後 | "apiVersion: {version}" |
| 情報ログ | グループ作成後 | "groupID: {groupId}" |
| 情報ログ | パッド作成後 | "Test Pad ID ====> {padId}" |
| 情報ログ | 著者作成後 | "authorID: {authorId}" |
| 情報ログ | 有効期限設定時 | "validUntil: {timestamp}" |
| 結果ログ | セッション作成後 | "Session made: ====> create a cookie named sessionID and set the value to {sessionId}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行の開発ツールであり、監視対象外とする。

## 備考

- 生成されたセッションIDは、ブラウザ開発者ツールでCookie「sessionID」として設定する必要がある
- セッションの有効期限は約16時間（60000秒）で、期限切れ後は再度実行が必要
- 本バッチは主に開発・テスト環境での使用を想定しており、本番環境での使用は推奨しない
- グループ、パッド、著者、セッションは自動的にユニークなIDで生成される
- 作成されたリソースは手動で削除しない限りデータベースに残り続ける
