# バッチ設計書 27-deleteAllGroupSessions

## 概要

本ドキュメントは、全てのグループセッションを削除するスクリプト「deleteAllGroupSessions.ts」の設計仕様を定義する。

### 本バッチの処理概要

deleteAllGroupSessions.tsは、Etherpad APIを使用してすべてのグループに属するすべてのセッションを一括削除するユーティリティツールである。

**業務上の目的・背景**：Etherpadの運用において、セッションが蓄積すると以下の問題が発生する可能性がある：データベースの肥大化、不要な認証情報の残存、セキュリティリスクの増大。本バッチは、「顔を直すのにレンガが必要なこともある」というコメントが示すように、問題解決の強力な手段として、すべてのグループセッションを一括で削除する機能を提供する。

**バッチの実行タイミング**：手動実行のみ。定期的なセッションクリーンアップ、セキュリティインシデント対応、またはテスト環境のリセット時に運用者が実行する。

**主要な処理内容**：
1. APIキーの読み込み
2. Etherpad APIへの接続設定
3. APIバージョンの取得
4. listAllGroups APIで全グループを取得
5. 各グループについてlistSessionsOfGroup APIでセッション一覧を取得
6. 各セッションについてdeleteSession APIで削除
7. 削除件数を出力

**前後の処理との関連**：本バッチは単独で動作する。実行後、すべてのユーザーがグループパッドへのアクセスにおいて再認証が必要になる。

**影響範囲**：すべてのグループに属するすべてのセッションがデータベースから削除される。グループパッドを使用中のすべてのユーザーに影響を与える。

## バッチ種別

データ削除 / メンテナンスツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Etherpad稼働中 | APIを使用するため、Etherpadサーバーが起動していること |
| APIKEY.txt存在 | プロジェクトルートにAPIKEY.txtファイルが存在すること |
| ネットワーク接続 | 設定されたIP/ポートへのHTTP接続が可能であること |

### 実行可否判定

APIキーが無効な場合やEtherpadサーバーに接続できない場合はエラーとなる。グループが存在しない場合は何も削除せずに終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| APIKEY.txt | テキストファイル | Etherpad API認証キー |
| settings.json | JSON | Etherpadサーバー設定（IP、ポート） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 削除結果のログ |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. 開始メッセージ出力
   └─ "Deleting all group sessions, please be patient."
2. APIキー読み込み
   └─ APIKEY.txtファイルからAPIキーを取得
3. APIバージョン取得
   └─ GET /api/ でcurrentVersionを取得
4. 全グループ取得
   └─ GET /api/{version}/listAllGroups を実行
5. グループループ開始
   └─ 各グループに対して以下を実行
6. セッション一覧取得
   └─ GET /api/{version}/listSessionsOfGroup を実行
7. セッション削除ループ
   └─ 各セッションに対してPOST deleteSession を実行
8. カウンタ更新
   └─ 削除成功ごとにカウンタをインクリメント
9. 結果出力
   └─ "Deleted {count} sessions"を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[開始メッセージ出力]
    B --> C[APIキー読み込み]
    C --> D[APIバージョン取得]
    D --> E[listAllGroups API呼び出し]
    E --> F{グループあり?}
    F -->|No| G[削除件数0で終了]
    F -->|Yes| H[次のグループ取得]
    H --> I[listSessionsOfGroup API呼び出し]
    I --> J{セッションあり?}
    J -->|No| K{全グループ処理完了?}
    J -->|Yes| L[次のセッション取得]
    L --> M[deleteSession API呼び出し]
    M --> N[カウンタ++]
    N --> O{全セッション処理完了?}
    O -->|No| L
    O -->|Yes| K
    K -->|No| H
    K -->|Yes| P[削除件数出力]
    P --> Q[正常終了 exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| グループ一覧取得 | group:* | SELECT | 全グループのID取得 |
| セッション一覧取得 | session:* | SELECT | グループに属するセッション取得 |
| セッション削除 | session:{sessionId} | DELETE | セッション削除 |

### テーブル別操作詳細

#### session:{sessionId}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | セッションID指定 | API経由で削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | APIバージョン取得失敗 | /api/エンドポイントが応答しない | Etherpadサーバーの起動状態を確認 |
| - | グループ一覧取得失敗 | API認証失敗など | APIキーを確認 |
| - | セッション削除失敗 | 個別セッションの削除エラー | ログを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

削除処理が途中で失敗した場合、一部のセッションが残る可能性がある。再度実行することで残りのセッションを削除できる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各API呼び出し単位 |
| コミットタイミング | 各deleteSession完了時 |
| ロールバック条件 | なし（部分削除は許容） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | グループ数×セッション数 |
| 目標処理時間 | セッション数に依存 |
| メモリ使用量上限 | 通常のNode.js制限内 |

## 排他制御

セッション削除はAPI経由で行われるため、Etherpad内部で適切に処理される。削除中にユーザーがグループパッドにアクセスしようとすると、認証エラーとなる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Deleting all group sessions, please be patient." |
| 情報ログ | APIバージョン取得後 | "apiVersion: {version}" |
| 情報ログ | 各セッション削除後 | APIレスポンス（{code: 0, message: "ok", data: null}） |
| 終了ログ | 処理完了時 | "Deleted {count} sessions" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のツールであり、監視対象外とする。

## 備考

- 本バッチを実行すると、すべてのユーザーがグループパッドへのアクセス時に再認証が必要になる
- 大量のセッションがある場合、処理に時間がかかる可能性がある
- nullのセッションはスキップされる（安全性対策）
- 削除カウンタはAPIレスポンス確認前にインクリメントされるため、実際の削除数と若干異なる可能性がある（TODO: 要改善）
- 本バッチはグループに属さないセッションには影響しない
