# バッチ設計書 28-plugins

## 概要

本ドキュメントは、プラグインのインストール/削除/一覧表示を行うCLIツール「plugins.ts」の設計仕様を定義する。

### 本バッチの処理概要

plugins.tsは、Etherpadプラグインをコマンドラインから管理するための統合CLIツールである。

**業務上の目的・背景**：Etherpadの機能拡張はプラグインシステムによって実現される。管理画面からのプラグイン管理も可能だが、サーバー環境でのCLI操作、自動化スクリプトでの利用、Dockerイメージ構築時のプラグイン組み込みなど、コマンドラインからのプラグイン管理が必要なケースが多い。本バッチは、npmレジストリ、GitHub、ローカルパスからのプラグインインストール、アンインストール、一覧表示を統一的なインターフェースで提供する。

**バッチの実行タイミング**：手動実行。新規プラグインの追加、不要プラグインの削除、インストール済みプラグインの確認時に実行する。

**主要な処理内容**：
1. コマンドライン引数から操作種別（install/remove/list）を判定
2. install: npmレジストリ、GitHub、ローカルパスからプラグインをインストール
3. remove: 指定したプラグインをアンインストール
4. list: インストール済みプラグイン一覧を表示
5. インストール済みプラグイン情報の永続化

**前後の処理との関連**：プラグインのインストール後はEtherpadの再起動が推奨される。commonPlugins.tsと連携してインストール情報を永続化する。

**影響範囲**：プラグインファイルのインストール/削除、node_modulesへのシンボリックリンク作成、installed_plugins.jsonの更新。

## バッチ種別

プラグイン管理 / システム設定ツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v14以上が必要 |
| pnpm利用可能 | pnpmパッケージマネージャーがインストールされていること |
| 書き込み権限 | src/plugin_packagesディレクトリへの書き込み権限 |

### 実行可否判定

コマンドライン引数が1つも指定されていない場合はエラー終了。有効なアクション（install/i, remove/rm, list/ls）以外が指定された場合もエラー終了。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| action | string | Yes | - | i/install, rm/remove, ls/list のいずれか |
| plugins | string[] | 条件付き | - | install/removeの場合に対象プラグイン名 |
| --path | string | No | - | ローカルパスからインストール時のパス |
| --github | string | No | - | GitHubリポジトリからインストール時のリポジトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| var/installed_plugins.json | JSON | インストール済みプラグイン情報 |
| npmレジストリ | Web | プラグインパッケージ |
| GitHub | Web | GitHubリポジトリのプラグイン |
| ローカルパス | ファイル | ローカルディレクトリのプラグイン |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| src/plugin_packages/ | ディレクトリ | プラグインファイル |
| src/node_modules/ | シンボリックリンク | プラグインへのリンク |
| var/installed_plugins.json | JSON | インストール済みプラグイン情報 |
| 標準出力 | テキスト | 処理結果のログ |

### 出力ファイル仕様

#### var/installed_plugins.json

| 項目 | 内容 |
|-----|------|
| ファイル名 | installed_plugins.json |
| 出力先 | var/ |
| 文字コード | UTF-8 |
| 形式 | JSON |

```json
{
  "plugins": [
    {"name": "ep_plugin_name", "version": "1.0.0"},
    ...
  ]
}
```

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ action（install/remove/list）を判定
2. アクション分岐
   ├─ install: インストール処理へ
   ├─ remove: アンインストール処理へ
   └─ list: 一覧表示処理へ

【installの場合】
3. マイグレーションチェック
   └─ checkForMigration()で既存プラグインの確認
4. プラグインソース判定
   └─ レジストリ/--path/--githubを解析
5. プラグインインストール
   ├─ レジストリ: linkInstaller.installPlugin()
   ├─ ローカル: linkInstaller.installFromPath()
   └─ GitHub: linkInstaller.installFromGitHub()
6. 情報永続化
   └─ persistInstalledPlugins()

【removeの場合】
3. マイグレーションチェック
4. プラグインアンインストール
   └─ linkInstaller.uninstallPlugin()
5. 情報永続化

【listの場合】
3. インストール済みプラグイン読み込み
   └─ installed_plugins.jsonを読み込み
4. プラグイン名一覧出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数あり?}
    B -->|No| C[エラー終了]
    B -->|Yes| D{action判定}
    D -->|install/i| E[checkForMigration]
    D -->|remove/rm| F[checkForMigration]
    D -->|list/ls| G[installed_plugins.json読み込み]
    D -->|その他| C

    E --> H{プラグインソース}
    H -->|レジストリ| I[installPlugin]
    H -->|--path| J[installFromPath]
    H -->|--github| K[installFromGitHub]
    I --> L[persistInstalledPlugins]
    J --> L
    K --> L

    F --> M[uninstallPlugin]
    M --> L

    G --> N[プラグイン名一覧出力]

    L --> O[正常終了]
    N --> O
```

## データベース操作仕様

本バッチはデータベースを直接操作しない。ファイルシステムのみを操作する。

### ファイル操作一覧

| 処理 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| プラグインインストール | src/plugin_packages/ | 作成 | プラグインファイルの配置 |
| シンボリックリンク作成 | src/node_modules/ | 作成 | プラグインへのリンク |
| 情報永続化 | var/installed_plugins.json | 更新 | インストール情報の保存 |
| プラグイン削除 | src/plugin_packages/ | 削除 | プラグインファイルの削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 引数なしで実行 | 正しい引数で再実行 |
| 1 | 不正アクション | 無効なアクション指定 | install/remove/listを指定 |
| - | ネットワークエラー | npmレジストリ/GitHub接続失敗 | ネットワーク状態を確認 |
| - | パス不正 | --pathで指定したパスが存在しない | 正しいパスを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

インストールが途中で失敗した場合、プラグインファイルが不完全な状態で残る可能性がある。removeコマンドで削除してから再度インストールを試みる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | プラグイン単位 |
| コミットタイミング | persistInstalledPlugins()呼び出し時 |
| ロールバック条件 | なし（手動対応） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1〜複数プラグイン |
| 目標処理時間 | プラグインサイズに依存 |
| メモリ使用量上限 | 通常のNode.js制限内 |

## 排他制御

本バッチは排他制御を行わない。Etherpad稼働中に実行可能だが、プラグインの変更を反映するにはEtherpadの再起動が必要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | レジストリインストール時 | "Installing plugin from registry: {name}" |
| 情報ログ | パスインストール時 | "Installing plugin from path: {path}" |
| 情報ログ | GitHubインストール時 | "Installing plugin from github: {repo}" |
| 情報ログ | アンインストール時 | "Uninstalling plugin: {name}" |
| 情報ログ | 一覧表示時 | "Installed plugins are: {names}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のツールであり、監視対象外とする。

## 備考

- バージョン指定は「@」で区切る（例：ep_plugin@1.0.0）
- --pathと--githubは同時に使用可能で、それぞれ別のプラグインソースとして処理される
- プラグイン名はスペース区切りで複数指定可能
- インストールされたプラグインはsrc/plugin_packagesに配置され、node_modulesにシンボリックリンクが作成される
- Etherpad再起動後にプラグインが有効になる
