# バッチ設計書 29-commonPlugins

## 概要

本ドキュメントは、インストール済みプラグイン情報を永続化するモジュール「commonPlugins.ts」の設計仕様を定義する。

### 本バッチの処理概要

commonPlugins.tsは、Etherpadにインストールされているプラグイン情報をJSONファイルとして永続化する共通モジュールである。

**業務上の目的・背景**：Etherpadのプラグイン管理において、インストール済みプラグインの情報を永続的に保存しておく必要がある。この情報は、Etherpad再起動時のプラグイン復元、プラグイン一覧表示、マイグレーション処理などで使用される。本モジュールは、plugins.tsやinstaller.tsから呼び出され、プラグイン情報の永続化を担当する。

**バッチの実行タイミング**：他のスクリプトからモジュールとして呼び出される。直接実行するバッチではない。

**主要な処理内容**：
1. pluginsモジュールからインストール済みパッケージ情報を取得
2. プラグイン名とバージョン情報を抽出
3. 重複を除去
4. var/installed_plugins.jsonに書き込み

**前後の処理との関連**：plugins.tsのinstall/removeコマンド実行後に呼び出される。installer.tsからも呼び出される。

**影響範囲**：var/installed_plugins.jsonファイルの更新のみ。

## バッチ種別

共通モジュール / データ永続化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 他モジュールからの呼び出し時 |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | モジュール呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v14以上が必要 |
| 書き込み権限 | var/ディレクトリへの書き込み権限 |

### 実行可否判定

呼び出し元で適切にawaitされること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| pluginsModule.getPackages() | オブジェクト | インストール済みパッケージ情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| var/installed_plugins.json | JSON | インストール済みプラグイン情報 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | installed_plugins.json |
| 出力先 | var/ |
| 文字コード | UTF-8 |
| 形式 | JSON |

```json
{
  "plugins": [
    {"name": "ep_plugin_name", "version": "1.0.0"},
    {"name": "ep_another_plugin", "version": "2.0.0"}
  ]
}
```

## 処理フロー

### 処理シーケンス

```
1. パッケージ情報取得
   └─ pluginsModule.getPackages()を呼び出し
2. プラグイン情報抽出
   └─ 各パッケージからname, versionを抽出
3. 配列構築
   └─ pluginsプロパティを持つオブジェクトを構築
4. 重複除去
   └─ Set を使用して重複を除去
5. ファイル書き込み
   └─ writeFileSync()でJSONを出力
```

### フローチャート

```mermaid
flowchart TD
    A[persistInstalledPlugins呼び出し] --> B[getPackages取得]
    B --> C[空のplugins配列初期化]
    C --> D{パッケージ処理ループ}
    D -->|次のパッケージ| E[name, version抽出]
    E --> F[plugins配列に追加]
    F --> D
    D -->|完了| G[Setで重複除去]
    G --> H[writeFileSyncでJSON出力]
    H --> I[処理完了]
```

## データベース操作仕様

本モジュールはデータベースを操作しない。ファイルシステムのみを操作する。

### ファイル操作一覧

| 処理 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| プラグイン情報書き込み | var/installed_plugins.json | 上書き | プラグイン一覧のJSON出力 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル書き込みエラー | ディスク容量不足、権限不足 | ディスク状態と権限を確認 |
| - | getPackagesエラー | pluginsモジュールの異常 | Etherpad環境を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

ファイル書き込みに失敗した場合、プラグイン情報が更新されない。次回のインストール/アンインストール時に再度永続化が試みられる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル書き込み単位 |
| コミットタイミング | writeFileSync完了時 |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プラグイン数（通常10〜50程度） |
| 目標処理時間 | 数ミリ秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

writeFileSyncを使用しているため、同期的にファイルを書き込む。同時呼び出しの場合は最後の呼び出しが有効になる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| - | - | 本モジュールはログ出力を行わない |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本モジュールは監視対象外とする。

## 備考

- 本ファイルは直接実行するスクリプトではなく、他のスクリプトからインポートされるモジュールである
- エクスポートされる関数: `persistInstalledPlugins()`
- 依存モジュール: `fs.writeFileSync`, `pluginfw/installer`, `pluginfw/plugins`
- 重複除去のためにSetを使用しているが、オブジェクト配列に対するSetは参照比較となるため、実際の重複除去効果は限定的（同一オブジェクト参照のみ除去）
- installedPluginsPathはinstaller.tsからエクスポートされる
