# バッチ設計書 3-fastRun.sh

## 概要

本ドキュメントは、Etherpadの高速起動スクリプト`fastRun.sh`の設計仕様を記載したものである。依存関係のチェック・インストールを省略し、直接Etherpadサーバーを起動する開発者向けスクリプトである。

### 本バッチの処理概要

依存関係がすでにインストールされていることを前提とし、チェック処理をスキップしてEtherpadを高速に起動するスクリプトである。開発時の頻繁な再起動において、起動時間を短縮することを目的としている。

**業務上の目的・背景**：開発者がEtherpadのコードを変更し、動作確認のために再起動する場面は頻繁に発生する。通常の`run.sh`では毎回依存関係のチェック・インストール処理が実行されるため、起動に時間がかかる。このスクリプトは、依存関係が既にインストール済みであることを前提に、これらの処理をスキップすることで開発効率を向上させる。ただし、依存関係に変更があった場合は`installDeps.sh`を手動で実行する必要がある。

**バッチの実行タイミング**：開発者がコード変更後にEtherpadを再起動する際に手動で実行する。開発フェーズにおいて頻繁に使用される。

**主要な処理内容**：
1. Etherpadベースディレクトリへの移動
2. 共通関数（functions.sh）の読み込み
3. 依存関係チェックをスキップする旨のメッセージ表示
4. `pnpm run prod`によるEtherpadサーバーの起動

**前後の処理との関連**：本スクリプト実行前に、少なくとも1回は`installDeps.sh`（または`run.sh`）を実行して依存関係をインストールしておく必要がある。依存関係やプラグインを追加・変更した場合も、事前に`installDeps.sh`を実行する必要がある。

**影響範囲**：Etherpadサーバーの起動に影響する。依存関係が不足している状態で実行すると起動に失敗する。Admin UI/UIのビルドは行わないため、UIの変更がある場合は反映されない。

## バッチ種別

起動処理 / 開発支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 依存関係インストール済み | installDeps.shまたはrun.shが事前に実行されていること |
| Node.js | 適切なバージョンがインストールされていること |
| pnpm | パッケージマネージャーpnpmがインストールされていること |

### 実行可否判定

- 依存関係がインストールされていない場合、起動時にエラーが発生する
- 本スクリプト自体には実行可否の判定ロジックはない

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| 任意の引数 | 任意 | No | - | pnpm run prodに渡される引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| bin/functions.sh | シェルスクリプト | 共通関数・定数定義 |
| node_modules | ディレクトリ | 事前にインストールされた依存関係 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 起動メッセージ・サーバーログ |

### 出力ファイル仕様

本バッチではファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. ディレクトリ移動
   └─ スクリプトの場所からEtherpadベースディレクトリへ移動
2. 共通関数読み込み
   └─ bin/functions.shをソースして共通関数を利用可能にする
3. スキップメッセージ表示
   └─ 依存関係チェックをスキップする旨を表示
4. サーバー起動
   └─ pnpm run prodでEtherpadサーバーを起動
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ディレクトリ移動]
    B --> C[functions.sh読み込み]
    C --> D[スキップメッセージ表示]
    D --> E[pnpm run prod実行]
    E --> F[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチは直接的なデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチでは直接操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ディレクトリエラー | ベースディレクトリへの移動失敗 | ディレクトリ構成を確認 |
| 非0 | 依存関係エラー | node_modulesが存在しないまたは不完全 | installDeps.shを実行 |
| 非0 | 起動エラー | pnpm run prodの実行失敗 | エラーメッセージを確認し対処 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動再実行が必要） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認し、原因を特定する
2. 依存関係エラーの場合は`installDeps.sh`を実行する
3. 設定ファイルエラーの場合は`settings.json`を確認する
4. 解決しない場合は`run.sh`での起動を試みる

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の起動処理 |
| 目標処理時間 | 数秒（依存関係チェックをスキップするため高速） |
| メモリ使用量上限 | Node.jsプロセスに依存 |

## 排他制御

- 同一ホスト上での複数同時実行は推奨されない
- ポートの競合が発生した場合、後から起動したプロセスは失敗する

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Running directly, without checking/installing dependencies" |
| 終了ログ | バッチ終了時 | Etherpadプロセスの出力に依存 |
| エラーログ | エラー発生時 | 起動エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| プロセス起動状態 | 起動失敗時 | 開発者 |

## 備考

- 本スクリプトは開発者向けであり、本番環境での使用は推奨されない
- 依存関係の更新やプラグインの追加・削除後は、必ず`installDeps.sh`を実行すること
- Admin UI/UIのビルドは行わないため、UIの変更を反映するには`run.sh`を使用すること
- `set -eu`により、未定義変数の使用やコマンド失敗時に即座にエラー終了する
