# バッチ設計書 30-updatePlugins

## 概要

本ドキュメントは、インストール済みプラグインを更新するスクリプト「updatePlugins.sh」の設計仕様を定義する。

### 本バッチの処理概要

updatePlugins.shは、インストール済みのEtherpadプラグインを最新バージョンに更新するシェルスクリプトである。

**業務上の目的・背景**：Etherpadのプラグインは定期的にアップデートが公開され、セキュリティ修正、バグ修正、新機能追加が行われる。手動で各プラグインのバージョンを確認して更新するのは煩雑であるため、本バッチは一括でアウトデートなプラグインを検出し、更新を実行する。これにより、プラグインを常に最新の状態に保つことができる。

**バッチの実行タイミング**：手動実行。定期的なメンテナンス時、セキュリティアップデート適用時、または新バージョンリリース確認時に実行する。

**主要な処理内容**：
1. プロジェクトルートディレクトリへ移動
2. npm outdatedコマンドでアウトデートなパッケージを検出
3. ep_プレフィックスのパッケージ（Etherpadプラグイン）のみをフィルタリング
4. アウトデートなプラグインがある場合、pnpm installで更新
5. アウトデートなプラグインがない場合は完了メッセージを出力

**前後の処理との関連**：本バッチはpackage.jsonに依存する。更新後はEtherpadの再起動が推奨される。

**影響範囲**：node_modules内のプラグインパッケージが更新される。package-lock.jsonも更新される可能性がある。

## バッチ種別

プラグイン管理 / メンテナンスツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動）/ 週次推奨 |
| 実行時刻 | 任意（メンテナンス時間帯推奨） |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| シェル環境 | POSIX互換シェル（sh） |
| npm/pnpm利用可能 | npm outdatedとpnpm installが実行可能であること |
| ネットワーク接続 | npmレジストリへの接続が可能であること |

### 実行可否判定

常に実行可能。アウトデートなプラグインがない場合は何も更新せずに終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| package.json | JSON | プロジェクトの依存関係定義 |
| npmレジストリ | Web | 最新パッケージ情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| node_modules/ | ディレクトリ | 更新されたプラグインパッケージ |
| package-lock.json | JSON | 更新後のロックファイル |
| 標準出力 | テキスト | 更新結果のログ |

### 出力ファイル仕様

本バッチは直接ファイルを出力しない。pnpm installの副作用としてファイルが更新される。

## 処理フロー

### 処理シーケンス

```
1. エラー時終了設定
   └─ set -e でエラー時にスクリプト終了
2. ディレクトリ取得
   └─ スクリプトのあるディレクトリを特定
3. プロジェクトルート移動
   └─ binディレクトリの親ディレクトリへ移動
4. アウトデートパッケージ取得
   └─ npm outdated --depth=0 を実行
5. プラグインフィルタリング
   └─ awk/grepでep_プレフィックスのパッケージを抽出
6. 更新判定
   ├─ プラグインあり: pnpm installで更新
   └─ プラグインなし: "All plugins are up-to-date"を出力
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[set -e 設定]
    B --> C[スクリプトディレクトリ取得]
    C --> D[プロジェクトルート移動]
    D --> E[npm outdated --depth=0 実行]
    E --> F[awk でパッケージ名抽出]
    F --> G[grep '^ep_' でフィルタ]
    G --> H{ep_プラグインあり?}
    H -->|No| I[All plugins are up-to-date 出力]
    I --> J[exit 0]
    H -->|Yes| K[更新対象を表示]
    K --> L[pnpm install 実行]
    L --> M[終了]
```

## データベース操作仕様

本バッチはデータベースを操作しない。

### ファイル操作一覧

| 処理 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| プラグイン更新 | node_modules/ep_* | 更新 | pnpm install経由で更新 |
| ロックファイル更新 | package-lock.json | 更新 | 依存関係の固定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ネットワークエラー | npmレジストリに接続できない | ネットワーク状態を確認 |
| - | 権限エラー | node_modulesへの書き込み権限なし | 権限を確認 |
| - | pnpmエラー | pnpmコマンドが見つからない | pnpmをインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

pnpm installが途中で失敗した場合、一部のプラグインが不整合な状態になる可能性がある。再度実行するか、node_modulesを削除してpnpm installを実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | pnpm install単位 |
| コミットタイミング | pnpm install完了時 |
| ロールバック条件 | set -eによりエラー時スクリプト終了 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | インストール済みプラグイン数 |
| 目標処理時間 | プラグイン数とサイズに依存（通常数十秒〜数分） |
| メモリ使用量上限 | pnpmの標準使用量 |

## 排他制御

本バッチは排他制御を行わない。Etherpad稼働中に実行可能だが、プラグインの変更を反映するにはEtherpadの再起動が必要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 更新なし時 | "All plugins are up-to-date" |
| 情報ログ | 更新あり時 | "Updating plugins: {plugin1} {plugin2} ..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは手動実行のツールであり、監視対象外とする。

## 備考

- npm outdatedは失敗しても0以外の終了コードを返すことがあるため、その場合は「||」で後続の処理に進む
- --depth=0オプションにより、直接依存のみをチェック（推移的依存は除外）
- awk '{print $1}'で出力の1列目（パッケージ名）のみを抽出
- grep '^ep_'でEtherpadプラグイン（ep_で始まるパッケージ）のみをフィルタ
- set -- ${OUTDATED}で更新対象パッケージを位置パラメータに設定
- exec pnpm installでシェルプロセスを置き換えて実行
