# バッチ設計書 31-getCorePlugins.sh

## 概要

本ドキュメントは、Etherpadプロジェクトにおける公式プラグインのクローン・更新処理を行うシェルスクリプト `getCorePlugins.sh` のバッチ設計書です。

### 本バッチの処理概要

このバッチは、GitHub上のEther組織が管理する公式プラグイン（ep_で始まるリポジトリ）を一括でクローンまたは更新するためのスクリプトです。

**業務上の目的・背景**：Etherpadは多数の公式プラグインをサポートしており、開発者やメンテナーがこれらのプラグインを一元的に管理・開発するためには、すべての公式プラグインをローカル環境に取得する必要があります。本バッチは、Ether組織のGitHubリポジトリから公式プラグイン一覧を取得し、未クローンのプラグインはクローン、既存のプラグインは最新コミットを取得することで、開発環境の構築と同期を自動化します。

**バッチの実行タイミング**：開発者が公式プラグインの開発・テストを行う際に手動で実行します。新しいプラグインが追加された場合や、最新の変更を取得したい場合に随時実行されます。

**主要な処理内容**：
1. `listOfficialPlugins` スクリプトを呼び出し、GitHub APIから公式プラグイン一覧を取得
2. 各プラグインについて、親ディレクトリにリポジトリが存在するか確認
3. リポジトリが存在しない場合は `git clone` でクローン
4. リポジトリが存在する場合は `git pull --ff-only` で最新コミットを取得

**前後の処理との関連**：本バッチは独立して実行可能ですが、取得したプラグインは `updateCorePlugins.sh` などのプラグイン管理スクリプトで利用されます。

**影響範囲**：Etherpadプロジェクトの親ディレクトリにプラグインリポジトリが作成・更新されます。node_modules内のプラグインには直接影響しません。

## バッチ種別

データ同期処理（Git リポジトリ同期）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Gitがインストールされていること | リポジトリのクローン・プルに必要 |
| curlがインストールされていること | GitHub APIへのアクセスに必要 |
| インターネット接続 | GitHubへのアクセスに必要 |
| listOfficialPluginsスクリプトの存在 | プラグイン一覧取得に必要 |

### 実行可否判定

前提条件が満たされていれば常に実行可能です。GitHub APIのレート制限に注意が必要です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API (ether/repos) | JSON | Ether組織の公式プラグイン一覧 |
| listOfficialPluginsスクリプト | テキスト | プラグイン名のリスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 親ディレクトリ/{プラグイン名} | Gitリポジトリ | クローン/更新されたプラグインリポジトリ |
| 標準出力 | テキスト | 処理状況のログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Gitリポジトリとして各プラグインディレクトリを作成 |
| 出力先 | Etherpadプロジェクトの親ディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ set -e でエラー時の即座終了を設定
2. ディレクトリ移動
   └─ Etherpadベースディレクトリへ移動し、親ディレクトリを取得
3. プラグイン一覧取得
   └─ listOfficialPluginsスクリプトを実行してプラグイン名リストを取得
4. 各プラグインの処理（ループ）
   └─ 4.1. リポジトリ存在確認
   └─ 4.2. 存在しない場合: git clone実行
   └─ 4.3. 存在する場合: git pull --ff-only実行
5. 処理完了
   └─ 全プラグインの処理が完了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ディレクトリ移動]
    B --> C[listOfficialPlugins実行]
    C --> D{プラグインリスト取得成功?}
    D -->|失敗| E[エラー終了]
    D -->|成功| F[次のプラグインを取得]
    F --> G{プラグインあり?}
    G -->|なし| H[バッチ終了]
    G -->|あり| I{リポジトリ存在?}
    I -->|なし| J[git clone実行]
    I -->|あり| K[git pull実行]
    J --> L{クローン成功?}
    K --> M{プル成功?}
    L -->|失敗| N[continueで次へ]
    L -->|成功| F
    M -->|失敗| E
    M -->|成功| F
    N --> F
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行いません |

### テーブル別操作詳細

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | プラグイン一覧取得失敗 | GitHub APIアクセス失敗 | ネットワーク確認、APIレート制限確認 |
| 1 | クローン失敗 | リポジトリアクセス失敗 | 次のプラグインへ処理継続（continue） |
| 1 | プル失敗 | Fast-forward不可 | ローカル変更を確認し手動対応 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. クローン失敗時は該当プラグインをスキップして次へ進行（continue）
2. プル失敗時はスクリプト終了、ローカル変更の確認が必要
3. GitHub APIレート制限時は時間を置いて再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（Git操作） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約30-50プラグイン |
| 目標処理時間 | ネットワーク状況に依存（数分〜10分程度） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一プラグインディレクトリに対する同時実行は避けてください。複数のスクリプトが同じGitリポジトリを操作すると競合が発生する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| プラグイン名 | 各プラグイン処理開始時 | プラグイン名（区切り線付き） |
| クローン情報 | クローン実行時 | "Cloning {repo} to {path}..." |
| 更新情報 | プル実行時 | "Fetching latest commits..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特に設定なし | - | - |

## 備考

- `listOfficialPlugins` スクリプトはGitHub APIを使用してEther組織のリポジトリ一覧を取得します
- プラグインは `ep_` で始まる名前のリポジトリのみが対象となります
- `git pull --ff-only` を使用しているため、ローカルに競合する変更がある場合は失敗します
- コメントアウトされたコード部分は、node_modules配下へのシンボリックリンク作成機能ですが、現在は無効化されています
