# バッチ設計書 32-updateCorePlugins.sh

## 概要

本ドキュメントは、Etherpadプロジェクトにおけるコアプラグインのチェックと自動プッシュを行うシェルスクリプト `updateCorePlugins.sh` のバッチ設計書です。

### 本バッチの処理概要

このバッチは、node_modules配下にインストールされているEtherpadプラグイン（ep_で始まるパッケージ）に対して、品質チェックと変更の自動プッシュを実行するスクリプトです。

**業務上の目的・背景**：Etherpadのプラグインエコシステムでは、多数のコアプラグインがメンテナンスされています。これらのプラグインに対して、コード品質のチェック（lint、依存関係の確認など）を一括で実行し、必要に応じて変更を自動的にリモートリポジトリにプッシュすることで、プラグインのメンテナンス作業を効率化します。CIパイプラインやリリースプロセスの一環として使用されることを想定しています。

**バッチの実行タイミング**：プラグインの一括更新やリリース準備時に手動で実行します。または、CIパイプラインから自動実行されることもあります。

**主要な処理内容**：
1. node_modules配下のep_*ディレクトリを走査
2. ep_etherpad-liteを除外（本体パッケージのため）
3. 各プラグインに対して `pnpm run checkPlugins` コマンドを実行
4. autopushオプションにより変更があれば自動プッシュ

**前後の処理との関連**：`getCorePlugins.sh` でプラグインをクローン・インストールした後に実行することが想定されます。プラグインの品質チェック結果は、リリース判断の材料となります。

**影響範囲**：各プラグインリポジトリへの変更プッシュが行われる可能性があります。GitHubへのプッシュ権限が必要です。

## バッチ種別

品質チェック / 自動デプロイ処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / CI |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| pnpmがインストールされていること | checkPluginsコマンドの実行に必要 |
| プラグインがnode_modulesに存在すること | 処理対象が必要 |
| GitHubへのプッシュ権限 | autopush使用時に必要 |
| checkPluginsスクリプトの存在 | package.jsonに定義されている必要あり |

### 実行可否判定

node_modules配下にep_*ディレクトリが存在する場合に実行されます。存在しない場合は何も処理されません。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| node_modules/ep_* | ディレクトリ | チェック対象のプラグインディレクトリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | checkPluginsコマンドの実行結果 |
| GitHubリポジトリ | Gitコミット | autopushによるプッシュ結果 |

### 出力ファイル仕様

本バッチはファイル出力を行いません。

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ set -e でエラー時の即座終了を設定
2. node_modules/ep_*ディレクトリの走査
   └─ forループで各プラグインディレクトリを処理
3. 除外判定
   └─ ep_etherpad-liteの場合はスキップ
4. プラグインチェック実行
   └─ pnpm run checkPlugins {プラグイン名} autopush を実行
5. 処理完了
   └─ 全プラグインの処理が完了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[node_modules/ep_*を走査]
    B --> C{次のプラグイン}
    C -->|なし| D[バッチ終了]
    C -->|あり| E{ep_etherpad-lite?}
    E -->|はい| C
    E -->|いいえ| F[checkPlugins実行]
    F --> G{成功?}
    G -->|成功| C
    G -->|失敗| H[エラー終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行いません |

### テーブル別操作詳細

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | checkPlugins失敗 | プラグインチェックエラー | エラーログ確認、手動修正 |
| 1 | プッシュ失敗 | GitHubアクセスエラー | 認証情報・権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. checkPlugins失敗時はスクリプト終了（set -eによる）
2. エラーログを確認し、該当プラグインの問題を手動で解決
3. 必要に応じて該当プラグインを除外して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（Git操作） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | node_modules内のep_*プラグイン数 |
| 目標処理時間 | プラグイン数×チェック時間に依存 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一プラグインに対する同時実行は避けてください。複数のプロセスが同じGitリポジトリを操作すると競合が発生します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| チェック結果 | 各プラグイン処理時 | checkPluginsコマンドの出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特に設定なし | - | - |

## 備考

- ep_etherpad-liteはEtherpad本体のパッケージであり、プラグインではないため除外されます
- checkPluginsコマンドはpackage.jsonのスクリプトとして定義されている必要があります
- autopushオプションにより、チェック後に自動的にGitHubへプッシュが行われます
- GitHubへのプッシュには適切な認証情報（SSHキーまたはトークン）が必要です
