# バッチ設計書 33-reTestAllPlugins.sh

## 概要

本ドキュメントは、Etherpadプロジェクトにおける全プラグインのテスト再実行をトリガーするシェルスクリプト `reTestAllPlugins.sh` のバッチ設計書です。

### 本バッチの処理概要

このバッチは、node_modules配下にインストールされている全てのEtherpadプラグイン（ep_で始まるパッケージ）に対して、空コミットをプッシュすることでCI/CDパイプラインのテストを再トリガーするスクリプトです。

**業務上の目的・背景**：Etherpad本体のアップデートやテストフレームワークの変更があった場合、すべてのプラグインが新しい環境でも正常に動作するかを確認する必要があります。本バッチは、各プラグインリポジトリに空コミット（実際のコード変更なし）をプッシュすることで、GitHub ActionsなどのCI/CDパイプラインを再実行させ、最新のEtherpadテスト環境でプラグインをテストします。

**バッチの実行タイミング**：Etherpad本体の重要なアップデート後や、テスト環境の更新後に手動で実行します。リリース前の互換性確認としても使用されます。

**主要な処理内容**：
1. node_modules配下のすべてのディレクトリを走査
2. ep_で始まるプラグインディレクトリを特定
3. ep_etherpad-liteを除外
4. 各プラグインディレクトリで空コミットを作成
5. masterブランチにプッシュしてCIをトリガー

**前後の処理との関連**：プラグインのインストール・更新後に実行されます。テスト結果は各プラグインのGitHubリポジトリで確認できます。

**影響範囲**：各プラグインのGitHubリポジトリにコミットがプッシュされます。CI/CDパイプラインが起動し、テストが実行されます。

## バッチ種別

テストトリガー / CI/CD連携処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Gitがインストールされていること | コミット・プッシュに必要 |
| プラグインがnode_modulesに存在すること | 処理対象が必要 |
| 各プラグインがGitリポジトリであること | git commitに必要 |
| GitHubへのプッシュ権限 | masterブランチへのプッシュに必要 |

### 実行可否判定

node_modules配下にep_*ディレクトリが存在し、それらがGitリポジトリである場合に実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| node_modules/* | ディレクトリ | 処理対象候補のディレクトリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 処理対象プラグイン名 |
| GitHubリポジトリ | Gitコミット | 空コミット |

### 出力ファイル仕様

本バッチはファイル出力を行いません。

## 処理フロー

### 処理シーケンス

```
1. 初期メッセージ出力
   └─ "herp" を出力
2. node_modulesディレクトリの走査
   └─ ls node_modules で全ディレクトリを取得
3. プラグイン判定
   └─ ディレクトリ名に "ep_" が含まれるか確認
4. 除外判定
   └─ ep_etherpad-liteの場合はスキップ
5. 空コミット作成・プッシュ
   └─ 5.1. プラグインディレクトリへ移動
   └─ 5.2. 空コミットを作成（--allow-empty）
   └─ 5.3. masterブランチへプッシュ
   └─ 5.4. 元のディレクトリへ戻る
6. 処理完了
   └─ 全プラグインの処理が完了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[herp出力]
    B --> C[ls node_modulesで一覧取得]
    C --> D{次のディレクトリ}
    D -->|なし| E[バッチ終了]
    D -->|あり| F[ディレクトリ名出力]
    F --> G{ep_を含む?}
    G -->|いいえ| D
    G -->|はい| H{ep_etherpad-lite?}
    H -->|はい| D
    H -->|いいえ| I[cd node_modules/プラグイン]
    I --> J[git commit --allow-empty]
    J --> K[git push origin master]
    K --> L[cd ../..]
    L --> D
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行いません |

### テーブル別操作詳細

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | コミット失敗 | Gitリポジトリでない場合 | 処理継続 |
| - | プッシュ失敗 | 権限不足、ネットワークエラー | 手動確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. プッシュ失敗時は手動で該当リポジトリを確認
2. 権限エラーの場合はGitHub認証情報を確認
3. ネットワークエラーの場合は再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（Git操作） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | node_modules内のep_*プラグイン数 |
| 目標処理時間 | プラグイン数×プッシュ時間に依存 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一プラグインに対する同時実行は避けてください。複数のプロセスが同じGitリポジトリを操作すると競合が発生します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | スクリプト開始時 | "herp" |
| ディレクトリ名 | 各ディレクトリ処理時 | ディレクトリ名 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特に設定なし | - | - |

## 備考

- コミットメッセージは固定: "Automatic update: bump update to re-run latest Etherpad tests"
- `--allow-empty` オプションにより、実際のファイル変更がなくてもコミットを作成できます
- masterブランチへの直接プッシュを行うため、適切な権限管理が必要です
- コメントアウトされたコードに `node bin/plugins/checkPlugin.js` がありますが、現在は使用されていません
- set -e が設定されていないため、個別のエラーは無視されて処理が継続されます
