# バッチ設計書 34-updateAllPluginsScript.sh

## 概要

本ドキュメントは、GitHub上の全プラグインをクローンしてチェックするシェルスクリプト `updateAllPluginsScript.sh` のバッチ設計書です。

### 本バッチの処理概要

このバッチは、特定のGitHubユーザー（johnmclear）のリポジトリから全てのEtherpadプラグインをクローンし、品質チェックと自動プッシュを実行するスクリプトです。

**業務上の目的・背景**：Etherpadのプラグインエコシステムには、公式（Ether組織）以外にも、個人開発者が管理するプラグインが多数存在します。本バッチは、特定の開発者（johnmclear氏）が管理するプラグインを一括でクローンし、品質チェックを実施することで、コミュニティプラグインの保守・管理を効率化します。リリース前の互換性確認やプラグインの一括更新に使用されます。

**バッチの実行タイミング**：プラグインの一括管理・更新が必要な場合に手動で実行します。特定の開発者のプラグインを一括チェックしたい場合に使用されます。

**主要な処理内容**：
1. node_modulesディレクトリに移動
2. GitHub APIで対象ユーザーのリポジトリ一覧を取得（最大4ページ分）
3. ep_で始まるリポジトリのみをクローン
4. 各プラグインに対して checkPlugins コマンドを実行
5. autopushオプションにより変更があれば自動プッシュ

**前後の処理との関連**：独立して実行可能ですが、クローンしたプラグインはその後の開発・テストに使用されます。

**影響範囲**：node_modules配下にプラグインリポジトリがクローンされます。checkPluginsにより各プラグインに変更がプッシュされる可能性があります。

## バッチ種別

データ同期 / 品質チェック処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| curlがインストールされていること | GitHub APIアクセスに必要 |
| Gitがインストールされていること | リポジトリクローンに必要 |
| pnpmがインストールされていること | checkPluginsコマンド実行に必要 |
| node_modulesディレクトリが存在すること | クローン先として必要 |
| GitHubへのSSHアクセス | git@github.com形式でクローン |

### 実行可否判定

前提条件が満たされていれば常に実行可能です。GitHub APIのレート制限に注意が必要です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API (users/johnmclear/repos) | JSON | ユーザーのリポジトリ一覧 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| node_modules/{プラグイン名} | Gitリポジトリ | クローンされたプラグイン |
| 標準出力 | テキスト | checkPluginsの実行結果 |
| GitHubリポジトリ | Gitコミット | autopushによるプッシュ結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Gitリポジトリとして各プラグインディレクトリを作成 |
| 出力先 | node_modules配下 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. node_modulesディレクトリへ移動
   └─ cd node_modules
2. GitHubリポジトリのクローン（4ページ分）
   └─ 2.1. ページ1のリポジトリをクローン
   └─ 2.2. ページ2のリポジトリをクローン
   └─ 2.3. ページ3のリポジトリをクローン
   └─ 2.4. ページ4のリポジトリをクローン
3. 元ディレクトリへ戻る
   └─ cd ..
4. プラグインの走査とチェック
   └─ 4.1. ep_*ディレクトリを特定
   └─ 4.2. ep_etherpad-liteを除外
   └─ 4.3. checkPlugins実行
5. 処理完了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[cd node_modules]
    B --> C[GitHub API ページ1取得]
    C --> D[ep_*リポジトリをクローン]
    D --> E[GitHub API ページ2-4取得・クローン]
    E --> F[cd ..]
    F --> G[ls node_modulesで一覧取得]
    G --> H{次のディレクトリ}
    H -->|なし| I[バッチ終了]
    H -->|あり| J{ep_を含む?}
    J -->|いいえ| H
    J -->|はい| K{ep_etherpad-lite?}
    K -->|はい| H
    K -->|いいえ| L[checkPlugins autopush実行]
    L --> H
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行いません |

### テーブル別操作詳細

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | API取得失敗 | GitHub APIアクセスエラー | ネットワーク確認、レート制限確認 |
| - | クローン失敗 | SSH認証エラー、リポジトリ不在 | 次のリポジトリへ継続 |
| - | checkPlugins失敗 | プラグインエラー | 処理継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. クローン失敗は個別にスキップされて処理継続
2. API取得失敗時は手動でリポジトリ一覧を確認
3. checkPlugins失敗時は該当プラグインを個別に確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（Git操作） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大4000リポジトリ（1000×4ページ） |
| 目標処理時間 | リポジトリ数×クローン時間に依存 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一ディレクトリに対する同時実行は避けてください。複数のプロセスが同じリポジトリをクローンすると競合が発生します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| クローン結果 | クローン実行時 | gitコマンドの出力 |
| チェック結果 | checkPlugins実行時 | checkPluginsの出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特に設定なし | - | - |

## 備考

- 対象ユーザーは `johnmclear` にハードコードされています
- GitHub APIは per_page=1000 で最大4ページ（4000リポジトリ）を取得
- git@github.com形式でクローンするため、SSHキーの設定が必要です
- set -e が設定されていないため、個別のエラーは無視されて処理が継続されます
- 既存のリポジトリがある場合はクローンがスキップされます（git cloneのデフォルト動作）
- 本スクリプトは特定開発者のリポジトリ管理用であり、汎用的な使用は想定されていません
