# バッチ設計書 37-runnerBackend.sh

## 概要

本ドキュメントは、Etherpadプロジェクトにおけるバックエンドテストを実行するシェルスクリプト `runnerBackend.sh` のバッチ設計書です。

### 本バッチの処理概要

このバッチは、Etherpadサーバーを起動し、バックエンド（サーバーサイド）のテストスイートを実行するスクリプトです。**非推奨（Deprecated）**であり、代わりに `cd src && npm test` の使用が推奨されています。

**業務上の目的・背景**：Etherpadのバックエンド機能（API、データ処理、認証など）の品質を担保するためのテストを実行します。本スクリプトはTravis CI環境での実行を想定して作成されましたが、現在はより直接的な `npm test` コマンドの使用が推奨されています。settings.json.templateからテスト用の設定ファイルを生成し、レート制限を緩和した状態でテストを実行します。

**バッチの実行タイミング**：CI/CDパイプラインからの自動実行、または開発者による手動実行。ただし非推奨のため、新規での使用は推奨されません。

**主要な処理内容**：
1. settings.json.templateからsettings.jsonを生成（sofficeパス設定、レート制限緩和）
2. Etherpadサーバーを開発モードでバックグラウンド起動
3. サーバーが接続可能になるまで最大15秒待機
4. npm testでバックエンドテストを実行
5. テスト完了後、Etherpadサーバーを終了

**前後の処理との関連**：`installDeps.sh` による依存関係インストールが事前に完了している必要があります。

**影響範囲**：settings.jsonファイルが生成・上書きされます。テスト結果はCI/CDパイプラインの成否判定に使用されます。

## バッチ種別

テスト実行処理（バックエンドテスト）※非推奨

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI/CDトリガー（非推奨） |
| 実行時刻 | コミット・プルリクエスト時 |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI/CD / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.jsがインストールされていること | サーバー起動・テスト実行に必要 |
| 依存関係がインストール済みであること | npm installが完了している必要 |
| curlがインストールされていること | サーバー接続確認に必要 |
| sedがインストールされていること | 設定ファイル生成に必要 |
| settings.json.templateが存在すること | 設定ファイル生成元 |

### 実行可否判定

依存関係がインストールされており、settings.json.templateが存在する場合に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $@ | string | No | なし | npm run devに渡される追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| settings.json.template | JSON | 設定ファイルテンプレート |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| settings.json | JSON | テスト用設定ファイル |
| 標準出力 | テキスト | テスト実行ログ |
| 終了コード | 数値 | 0=成功、1=失敗 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | settings.json |
| 出力先 | プロジェクトルート |
| 文字コード | UTF-8 |
| 区切り文字 | JSON形式 |

## 処理フロー

### 処理シーケンス

```
1. ユーティリティ関数の定義
   └─ pecho, log, error, fatal, try関数を定義
2. ディレクトリ移動
   └─ Etherpadベースディレクトリへ移動
3. 設定ファイル生成
   └─ 3.1. sofficeパスを /usr/bin/soffice に設定
   └─ 3.2. maxを100、pointsを1000に設定（レート制限緩和）
   └─ 3.3. settings.json.templateからsettings.jsonを生成
4. 非推奨警告出力
   └─ "Deprecation notice: runnerBackend.sh - Please use: cd src && npm test"
5. Etherpadサーバー起動
   └─ npm run dev をバックグラウンドで起動
   └─ プロセスIDを保存
6. 接続待機
   └─ 6.1. curl でlocalhost:9001への接続を試行
   └─ 6.2. 最大15秒間、1秒間隔でリトライ
   └─ 6.3. 接続失敗時はタイムアウトエラーで終了
7. バックエンドテスト実行
   └─ cd src && npm test を実行
8. クリーンアップ
   └─ Etherpadプロセスを終了
9. 終了
   └─ テスト結果の終了コードで終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ディレクトリ移動]
    B --> C[sed でsettings.json生成]
    C --> D[非推奨警告出力]
    D --> E[npm run dev 起動]
    E --> F[接続待機開始]
    F --> G{15秒経過?}
    G -->|いいえ| H{接続成功?}
    H -->|いいえ| I[1秒待機]
    I --> G
    H -->|はい| J[cd src && npm test]
    G -->|はい| K[タイムアウトエラー]
    K --> L[fatal終了]
    J --> M[テスト完了]
    M --> N[Etherpadプロセス終了]
    N --> O[終了コード返却]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行いません |

### テーブル別操作詳細

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 接続タイムアウト | 15秒以内にサーバーに接続できない | サーバーログ確認、依存関係確認 |
| 1 | テスト失敗 | npm testでテスト失敗 | テスト結果を確認し問題を修正 |
| 1 | 設定ファイル生成失敗 | sed処理失敗 | settings.json.templateを確認 |
| 1 | コマンド失敗 | try関数でラップされたコマンドの失敗 | エラーメッセージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 接続確認のみ15回（15秒間） |
| リトライ間隔 | 1秒 |
| リトライ対象エラー | サーバー接続エラー |

### 障害時対応

1. 接続タイムアウト時はサーバーログを確認
2. テスト失敗時はテスト結果の詳細を確認
3. 依存関係エラー時はinstallDeps.shを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | バックエンドテストスイート全体 |
| 目標処理時間 | テストスイートに依存 |
| メモリ使用量上限 | Node.jsプロセスに依存 |

## 排他制御

同一ポート（9001）での同時実行は避けてください。ポート競合が発生します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 非推奨警告 | 処理開始時 | "Deprecation notice: runnerBackend.sh - Please use: cd src && npm test" |
| 情報ログ | 処理開始時 | "Assuming src/bin/installDeps.sh has already been run" |
| 接続待機 | 待機中 | "Waiting for Etherpad to accept connections..." |
| 接続成功 | 接続成功時 | "Successfully connected to Etherpad on http://localhost:9001" |
| テスト開始 | テスト開始時 | "Running the backend tests..." |
| 完了ログ | 処理完了時 | "Done." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗 | 1件以上 | CI/CDパイプライン |

## 備考

- **非推奨スクリプトです**：`cd src && npm test` の使用を推奨
- settings.jsonの変更内容：
  - soffice: "/usr/bin/soffice"（LibreOffice/OpenOfficeパス）
  - max: 100（レート制限の最大値）
  - points: 1000（レート制限のポイント）
- runner.shと異なり、--experimental-workerオプションは付与されません
- テスト実行はsrcディレクトリ内で行われます
