# バッチ設計書 38-runnerLoadTest.sh

## 概要

本ドキュメントは、Etherpadプロジェクトにおける負荷テストを実行するシェルスクリプト `runnerLoadTest.sh` のバッチ設計書です。

### 本バッチの処理概要

このバッチは、Etherpadサーバーを本番モードで起動し、etherpad-loadtestツールを使用して負荷テストを実行するスクリプトです。

**業務上の目的・背景**：Etherpadはリアルタイムコラボレーションエディタとして、多数の同時接続ユーザーを処理する必要があります。本バッチは、指定した期間と同時接続数（著者数）で負荷テストを実行し、システムのスケーラビリティとパフォーマンスの限界を検証します。リリース前のパフォーマンス確認や、インフラ増強判断のための指標収集に使用されます。

**バッチの実行タイミング**：パフォーマンステストが必要な場合に手動で実行します。リリース前のパフォーマンス検証や、負荷特性の調査時に使用されます。

**主要な処理内容**：
1. コマンドライン引数で期間と著者数を受け取る
2. settings.json.templateからsettings.jsonを生成（レート制限緩和、loadTestモード有効化）
3. Etherpadサーバーを本番モードでバックグラウンド起動
4. サーバーが接続可能になるまで最大60秒待機
5. minifiedファイルのビルドをトリガー
6. etherpad-loadtestツールで負荷テストを実行
7. テスト完了後、Etherpadサーバーを終了

**前後の処理との関連**：`installDeps.sh` による依存関係インストールが事前に完了している必要があります。etherpad-loadtestパッケージがインストールされている必要があります。

**影響範囲**：settings.jsonファイルが生成・上書きされます。負荷テストにより一時的にシステムリソースが大量消費されます。

## バッチ種別

パフォーマンステスト（負荷テスト）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.jsがインストールされていること | サーバー起動に必要 |
| pnpmがインストールされていること | 本番モード実行に必要 |
| 依存関係がインストール済みであること | npm installが完了している必要 |
| curlがインストールされていること | サーバー接続確認に必要 |
| sedがインストールされていること | 設定ファイル生成に必要 |
| settings.json.templateが存在すること | 設定ファイル生成元 |
| etherpad-loadtestがインストールされていること | 負荷テストツール |

### 実行可否判定

依存関係がインストールされており、必須パラメータ（期間、著者数）が指定されている場合に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | 数値 | Yes | なし | テスト期間（秒） |
| $2 | 数値 | Yes | なし | 著者数（同時接続数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| settings.json.template | JSON | 設定ファイルテンプレート |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| settings.json | JSON | テスト用設定ファイル |
| 標準出力 | テキスト | 負荷テスト実行ログ |
| 終了コード | 数値 | 0=成功、非0=失敗 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | settings.json |
| 出力先 | プロジェクトルート |
| 文字コード | UTF-8 |
| 区切り文字 | JSON形式 |

## 処理フロー

### 処理シーケンス

```
1. ユーティリティ関数の定義
   └─ pecho, log, error, fatal, try関数を定義
2. パラメータ検証
   └─ 2.1. $1（期間）が正の数値か確認
   └─ 2.2. $2（著者数）が正の数値か確認
3. ディレクトリ移動
   └─ Etherpadベースディレクトリへ移動
4. 設定ファイル前処理
   └─ importExportRateLimiting.maxを100000000に設定
5. 設定ファイル生成
   └─ 5.1. loadTestをtrueに設定
   └─ 5.2. pointsを1000に設定（レート制限緩和）
   └─ 5.3. settings.json.templateからsettings.jsonを生成
6. Etherpadサーバー起動
   └─ pnpm run prod をバックグラウンドで起動
   └─ プロセスIDを保存
7. 接続待機
   └─ 7.1. curl でlocalhost:9001への接続を試行
   └─ 7.2. 最大60秒間、1秒間隔でリトライ
   └─ 7.3. 接続失敗時はタイムアウトエラーで終了
8. minifiedファイルビルド
   └─ http://localhost:9001/p/minifymeにアクセス
9. 追加待機
   └─ 10秒待機（ビルド完了待ち）
10. 負荷テスト実行
    └─ etherpad-loadtest -d $1 -a $2 を実行
11. クリーンアップ
    └─ Etherpadプロセスを終了
12. 終了
    └─ テスト結果の終了コードで終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{パラメータ検証}
    B -->|失敗| C[fatal終了]
    B -->|成功| D[ディレクトリ移動]
    D --> E[settings.json.template前処理]
    E --> F[settings.json生成]
    F --> G[pnpm run prod 起動]
    G --> H[接続待機開始]
    H --> I{60秒経過?}
    I -->|いいえ| J{接続成功?}
    J -->|いいえ| K[1秒待機]
    K --> I
    J -->|はい| L[minifymeにアクセス]
    I -->|はい| C
    L --> M[10秒待機]
    M --> N[etherpad-loadtest実行]
    N --> O[テスト完了]
    O --> P[Etherpadプロセス終了]
    P --> Q[終了コード返却]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行いません（テストデータはデフォルトDB使用） |

### テーブル別操作詳細

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | パラメータエラー | 期間または著者数が未指定/不正 | 正しいパラメータで再実行 |
| 1 | 接続タイムアウト | 60秒以内にサーバーに接続できない | サーバーログ確認、依存関係確認 |
| 1 | 負荷テスト失敗 | etherpad-loadtestでエラー | テスト結果を確認し問題を修正 |
| 1 | コマンド失敗 | try関数でラップされたコマンドの失敗 | エラーメッセージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 接続確認のみ60回（60秒間） |
| リトライ間隔 | 1秒 |
| リトライ対象エラー | サーバー接続エラー |

### 障害時対応

1. 接続タイムアウト時はサーバーログを確認
2. 負荷テスト失敗時はリソース状況を確認
3. 依存関係エラー時はinstallDeps.shを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | パラメータで指定した著者数 |
| 目標処理時間 | パラメータで指定した期間 |
| メモリ使用量上限 | 負荷テスト規模に依存 |

## 排他制御

同一ポート（9001）での同時実行は避けてください。ポート競合が発生します。また、負荷テスト中は他のテストを実行しないでください。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 処理開始時 | "Assuming src/bin/installDeps.sh has already been run" |
| 接続待機 | 待機中 | "Waiting for Etherpad to accept connections..." |
| 接続成功 | 接続成功時 | "Successfully connected to Etherpad on http://localhost:9001" |
| テスト開始 | テスト開始時 | "Running the load tests..." |
| 完了ログ | 処理完了時 | "Done." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特に設定なし | - | - |

## 備考

- etherpad-loadtestの引数：
  - `-d`: テスト期間（秒）
  - `-a`: 著者数（同時接続数）- これによりメッセージレートが決まる
- 本番モード（pnpm run prod）で起動するため、minifiedファイルが必要
- /p/minifymeへのアクセスでminifiedファイルのビルドをトリガー
- 接続待機は他のテストより長い60秒（本番モードでの起動に時間がかかるため）
- settings.json.templateの変更内容：
  - importExportRateLimiting.max: 100000000（インポート/エクスポートのレート制限緩和）
  - loadTest: true（負荷テストモード有効化）
  - points: 1000（一般的なレート制限緩和）
