# バッチ設計書 39-testlimits.sh

## 概要

本ドキュメントは、Etherpadプロジェクトにおけるレート制限機能のテストを実行するシェルスクリプト `testlimits.sh` のバッチ設計書です。

### 本バッチの処理概要

このバッチは、Etherpadのレート制限機能が正しく動作するかを検証するテストスクリプトです。異なる間隔でChangesetを送信し、レート制限が適切にトリガーされるかを確認します。

**業務上の目的・背景**：Etherpadは不正なアクセスやDoS攻撃を防ぐためにレート制限機能を実装しています。本バッチは、レート制限が適切な閾値（100ms）で動作することを検証します。101ms間隔での送信ではレート制限が発動せず、99ms間隔での送信ではレート制限が発動することを確認します。また、プロキシ経由やマルチIP環境でのレート制限動作も検証します。

**バッチの実行タイミング**：レート制限機能の変更後や、セキュリティテストの一環として実行します。CI/CDパイプラインに組み込むことも可能です。

**主要な処理内容**：
1. 101ms間隔でChangesetを送信し、レート制限が発動しないことを確認
2. 99ms間隔でChangesetを送信し、レート制限が発動することを確認
3. プロキシ経由での101ms間隔送信テスト
4. Docker経由で別IPからの101ms間隔送信テスト（並列実行）
5. 両方のテストが成功することを確認

**前後の処理との関連**：Etherpadサーバーが稼働中（ポート8081）であることが前提です。Dockerコンテナ（anotherip）が設定されている必要があります。

**影響範囲**：テスト用パッドにデータが書き込まれます。レート制限のテストなので、意図的にレート制限をトリガーします。

## バッチ種別

セキュリティテスト（レート制限テスト）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / CI |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.jsがインストールされていること | send_changesets.js実行に必要 |
| Etherpadがポート8081で稼働中 | テスト対象サーバー |
| etherpad-cli-clientがインストール済み | Changeset送信に必要 |
| Dockerがインストールされていること | マルチIPテストに必要 |
| anotherip Dockerコンテナが設定済み | 別IPテスト用 |

### 実行可否判定

Etherpadサーバーがポート8081で稼働しており、必要な依存関係がインストールされている場合に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け付けません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| send_changesets.js | JavaScript | Changeset送信スクリプト |
| Etherpadサーバー | HTTP/WebSocket | テスト対象 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト結果ログ |
| 終了コード | 数値 | 0=成功、1=失敗 |

### 出力ファイル仕様

本バッチはファイル出力を行いません。

## 処理フロー

### 処理シーケンス

```
1. テスト1: 101ms間隔送信（レート制限なし期待）
   └─ 1.1. send_changesets.js を101ms間隔で実行
   └─ 1.2. 終了コード0を確認（レート制限発動せず）
   └─ 1.3. 失敗時はエラーメッセージ出力して終了
2. テスト2: 99ms間隔送信（レート制限あり期待）
   └─ 2.1. send_changesets.js を99ms間隔で実行
   └─ 2.2. 終了コード1を確認（レート制限発動）
   └─ 2.3. レート制限未発動時はエラーメッセージ出力して終了
3. テスト3: プロキシ経由とマルチIPテスト（並列実行）
   └─ 3.1. プロキシ経由で101ms間隔送信（バックグラウンド）
   └─ 3.2. Docker経由別IPから101ms間隔送信（バックグラウンド）
   └─ 3.3. 両プロセスの終了を待機
4. 結果判定
   └─ 4.1. 両テストの終了コードを確認
   └─ 4.2. どちらかがレート制限発動なら失敗
5. 終了
   └─ 全テスト成功で正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[101ms間隔テスト]
    B --> C{レート制限発動?}
    C -->|発動| D[FAILED: 101msでレート制限]
    D --> E[exit 1]
    C -->|未発動| F[99ms間隔テスト]
    F --> G{レート制限発動?}
    G -->|未発動| H[FAILED: 99msでレート制限なし]
    H --> E
    G -->|発動| I[プロキシテスト開始]
    I --> J[101ms via プロキシ &]
    J --> K[101ms via Docker別IP &]
    K --> L[両プロセス待機]
    L --> M{どちらか失敗?}
    M -->|はい| N[FAILED: プロキシ/別IPでレート制限]
    N --> E
    M -->|いいえ| O[テスト成功]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テストデータ作成 | pad関連テーブル | INSERT/UPDATE | テスト用パッドへのChangeset書き込み |

### テーブル別操作詳細

#### テスト用パッド

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | Changeset | "1"を追加 | テスト用データ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 予期しないレート制限 | 101ms間隔でレート制限発動 | レート制限設定を確認 |
| 1 | レート制限未発動 | 99ms間隔でレート制限未発動 | レート制限設定を確認 |
| 1 | プロキシ/IPテスト失敗 | プロキシまたは別IP経由でレート制限発動 | プロキシ設定・IP判定ロジックを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. レート制限設定（settings.json）を確認
2. Etherpadサーバーのログを確認
3. send_changesets.jsの動作を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（WebSocket通信） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 各テストで11秒間のChangeset送信 |
| 目標処理時間 | 約1分（全テスト合計） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一パッドに対する同時テストは避けてください。レート制限のテストなので、他のテストと干渉する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 失敗ログ | 101msテスト失敗時 | "FAILED: ratelimit was triggered when sending every 101 ms" |
| 失敗ログ | 99msテスト失敗時 | "FAILED: ratelimit was not triggered when sending every 99 ms" |
| 情報ログ | 並列テスト完了時 | "101ms with proxy returned with {exit_code}" |
| 情報ログ | 並列テスト完了時 | "101ms via another ip returned with {exit_code}" |
| 失敗ログ | 並列テスト失敗時 | "FAILED: ratelimit was triggered during proxy and requests via second ip" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗 | 1件以上 | CI/CDパイプライン |

## 備考

- send_changesets.jsはetherpad-cli-clientを使用してWebSocket経由でChangesetを送信します
- レート制限の閾値は100msで、101msは許可、99msは拒否されるべきです
- テスト用パッド名：
  - BACKEND_TEST_ratelimit_101ms
  - BACKEND_TEST_ratelimit_99ms
  - BACKEND_TEST_ratelimit_101ms_via_second_ip
- Dockerコンテナ「anotherip」は172.23.42.1経由でプロキシにアクセスします
- send_changesets.jsは11秒間動作し、レート制限メッセージを受信したら終了コード1を返します
- 接続確立後500msの待機時間があります（CLIENT_READYメッセージがレート制限に含まれるため）
