# バッチ設計書 4-debugRun.sh

## 概要

本ドキュメントは、Etherpadのデバッグモード起動スクリプト`debugRun.sh`の設計仕様を記載したものである。Chrome DevToolsを使用したNode.jsデバッグが可能な状態でEtherpadを起動する。

### 本バッチの処理概要

Node.jsのインスペクタモードを有効にしてEtherpadを起動するスクリプトである。Chrome DevToolsから接続してブレークポイント設定、変数参照、ステップ実行などのデバッグ機能を利用できるようになる。

**業務上の目的・背景**：Etherpadの開発において、サーバーサイドのバグ調査やパフォーマンス分析が必要になることがある。従来のconsole.logベースのデバッグでは効率が悪く、複雑な問題の解決に時間がかかる。このスクリプトはChrome DevToolsによる高度なデバッグ環境を提供することで、開発者がより効率的に問題を特定・解決できるようにする。外部接続を許可する設定（0.0.0.0）により、Dockerコンテナ内で実行している場合でもホストマシンからデバッグが可能である。

**バッチの実行タイミング**：開発者がサーバーサイドコードのデバッグを行う際に手動で実行する。バグ調査、パフォーマンスプロファイリング、コードの動作確認などの場面で使用される。

**主要な処理内容**：
1. Etherpadベースディレクトリへの移動
2. 共通関数（functions.sh）の読み込み
3. `installDeps.sh`による依存関係のインストール
4. デバッグ接続方法のガイドメッセージ表示
5. Node.jsインスペクタモード（--inspect=0.0.0.0:9229）でサーバー起動

**前後の処理との関連**：本スクリプトは`installDeps.sh`を内部で呼び出すため、依存関係のインストールが前提処理として自動実行される。起動後はChrome DevToolsから接続してデバッグを行う。

**影響範囲**：Etherpadサーバーの起動方法に影響する。デバッグポート（9229）が外部に公開されるため、セキュリティ上の注意が必要。本番環境での使用は厳禁である。

## バッチ種別

起動処理 / 開発支援 / デバッグ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | バージョン12.13以上がインストールされていること |
| pnpm | パッケージマネージャーpnpmがインストールされていること |
| Chrome/Chromium | デバッグ用のブラウザがインストールされていること |
| ネットワーク | ポート9229が使用可能であること |

### 実行可否判定

- ポート9229が既に使用されている場合、起動に失敗する
- 本番環境での実行は推奨されない（セキュリティリスク）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| 任意の引数 | 任意 | No | - | server.tsに渡される引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| bin/functions.sh | シェルスクリプト | 共通関数・定数定義 |
| settings.json | JSON | Etherpad設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | デバッグガイドメッセージ、サーバーログ |

### 出力ファイル仕様

本バッチではファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. ディレクトリ移動
   └─ スクリプトの場所からEtherpadベースディレクトリへ移動
2. 共通関数読み込み
   └─ bin/functions.shをソースして共通関数を利用可能にする
3. 依存関係インストール
   └─ bin/installDeps.shを実行
4. ガイドメッセージ表示
   └─ Chrome DevToolsの使用方法を表示
5. srcディレクトリへ移動
   └─ サーバーコードが配置されているディレクトリへ移動
6. デバッグモードでサーバー起動
   └─ node --inspect=0.0.0.0:9229でserver.tsを起動
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ディレクトリ移動]
    B --> C[functions.sh読み込み]
    C --> D[installDeps.sh実行]
    D --> E{installDeps成功?}
    E -->|No| F[エラー終了]
    E -->|Yes| G[デバッグガイド表示]
    G --> H[srcディレクトリへ移動]
    H --> I[node --inspect起動]
    I --> J[デバッガ接続待機]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチは直接的なデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチでは直接操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 依存関係エラー | installDeps.shが失敗 | Node.jsバージョン確認、ネットワーク接続確認 |
| 非0 | ポート競合 | ポート9229が使用中 | 既存プロセスを停止または別ポートを使用 |
| 非0 | 起動エラー | server.tsの実行失敗 | エラーメッセージを確認し対処 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動再実行が必要） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認し、原因を特定する
2. ポート競合の場合は`lsof -i :9229`で使用中のプロセスを確認
3. 依存関係エラーの場合は`installDeps.sh`を単独で実行して確認
4. デバッガが接続できない場合はファイアウォール設定を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の起動処理 |
| 目標処理時間 | 依存関係インストール状況により変動 |
| メモリ使用量上限 | Node.jsプロセスに依存（デバッグ時はオーバーヘッドあり） |

## 排他制御

- 同一ホスト上での複数同時実行は推奨されない
- デバッグポート（9229）の競合が発生した場合、後から起動したプロセスは失敗する

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ガイドログ | 起動時 | Chrome DevToolsの使用方法 |
| デバッガログ | 起動時 | "Debugger listening on ws://..." |
| 終了ログ | バッチ終了時 | Etherpadプロセスの出力に依存 |
| エラーログ | エラー発生時 | 起動エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| デバッグポート公開 | 本番環境検出時 | 運用担当者（緊急） |

## 備考

- 本スクリプトはデバッグ専用であり、本番環境での使用は厳禁
- デバッグポート（9229）が外部に公開されるため、セキュリティに注意
- Chrome DevToolsへの接続方法：
  1. Chromeで`chrome://inspect`を開く
  2. "Open dedicated DevTools for Node"をクリック
  3. またはRemote Targetに表示されるEtherpadをクリック
- Dockerコンテナ内で実行する場合、ポート9229をホストにマッピングする必要がある
- `--inspect`ではなく`--inspect-brk`を使用すると、起動時にブレークする
- tsxを使用してTypeScriptを直接実行している（トランスパイル不要）
