# バッチ設計書 5-cleanRun.sh

## 概要

本ドキュメントは、Etherpadのクリーン起動スクリプト`cleanRun.sh`の設計仕様を記載したものである。node_modulesを削除してクリーンな状態から依存関係を再インストールし、Etherpadを起動する。

### 本バッチの処理概要

既存の依存関係（node_modules）を完全に削除した後、依存関係を再インストールしてEtherpadを起動するスクリプトである。依存関係の破損や不整合が疑われる場合のトラブルシューティングに使用する。

**業務上の目的・背景**：Node.jsプロジェクトにおいて、node_modulesの内容が破損したり、依存関係のバージョン不整合が発生することがある。このような問題は通常の起動では解決せず、依存関係を完全にクリアして再インストールする必要がある。このスクリプトは、このような状況でクリーンな状態からEtherpadを起動するための手段を提供する。また、root権限でのミスを防ぐセキュリティ機能も備えている。

**バッチの実行タイミング**：依存関係の問題が疑われる場合、またはNode.jsやpnpmのメジャーバージョンアップ後に手動で実行する。通常の起動では使用せず、トラブルシューティング時にのみ使用する。

**主要な処理内容**：
1. Etherpadベースディレクトリへの移動
2. 共通関数（functions.sh）の読み込み
3. root権限チェックとセキュリティ確認
4. src/node_modulesディレクトリの削除
5. `installDeps.sh`による依存関係の再インストール
6. Etherpadサーバーの起動

**前後の処理との関連**：本スクリプトは`installDeps.sh`を内部で呼び出すため、Node.jsとpnpmが事前にインストールされている必要がある。node_modulesを削除するため、初回起動と同様の時間がかかる。

**影響範囲**：src/node_modulesが完全に削除されるため、既存の依存関係がすべて失われる。再インストールには時間がかかり、ネットワーク接続が必要。

## バッチ種別

起動処理 / トラブルシューティング / クリーンインストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動、問題発生時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | バージョン12.13以上がインストールされていること |
| pnpm | パッケージマネージャーpnpmがインストールされていること |
| ネットワーク | 依存関係のダウンロードにインターネット接続が必要 |

### 実行可否判定

- root権限での実行時は、`--root`引数が指定されているか、確認メッセージ「Etherpad rocks my socks」の入力が必要
- 上記条件を満たさない場合、スクリプトは終了する

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --root | フラグ | No | なし | root権限での実行を許可する |
| その他 | 任意 | No | - | server.tsに渡される引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| bin/functions.sh | シェルスクリプト | 共通関数・定数定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 起動ログ・ステータスメッセージ |
| src/node_modules | ディレクトリ | 再インストールされた依存関係 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ディレクトリ | src/node_modules（再作成） |
| 内容 | pnpmによってインストールされたパッケージ群 |

## 処理フロー

### 処理シーケンス

```
1. ディレクトリ移動
   └─ スクリプトの場所からEtherpadベースディレクトリへ移動
2. 共通関数読み込み
   └─ bin/functions.shをソースして共通関数を利用可能にする
3. root権限チェック
   └─ --root引数または確認フレーズによる認証
4. node_modules削除
   └─ rm -rf src/node_modulesで既存の依存関係を削除
5. 依存関係インストール
   └─ bin/installDeps.shを実行
6. srcディレクトリへ移動
   └─ サーバーコードが配置されているディレクトリへ移動
7. サーバー起動
   └─ node --import tsx ./node/server.tsでEtherpadサーバーを起動
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ディレクトリ移動・環境読み込み]
    B --> C{root権限で実行?}
    C -->|No| E[src/node_modules削除]
    C -->|Yes| D{--root引数あり?}
    D -->|Yes| E
    D -->|No| F[確認メッセージ入力要求]
    F --> G{正しい入力?}
    G -->|Yes| E
    G -->|No| H[エラー終了]
    E --> I[installDeps.sh実行]
    I --> J{installDeps成功?}
    J -->|No| H
    J -->|Yes| K[srcディレクトリへ移動]
    K --> L[サーバー起動メッセージ表示]
    L --> M[node server.ts実行]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチは直接的なデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチでは直接操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 認証エラー | root権限実行時に確認フレーズが不正 | 正しいフレーズを入力するか--root引数を使用 |
| 1 | 依存関係エラー | installDeps.shが失敗 | Node.jsバージョン確認、ネットワーク接続確認 |
| 非0 | 起動エラー | server.tsの実行失敗 | エラーメッセージを確認し対処 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動再実行が必要） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認し、原因を特定する
2. ネットワーク接続を確認（依存関係のダウンロードに必要）
3. ディスク容量を確認（node_modulesには数百MBが必要）
4. Node.jsのバージョンが要件を満たしているか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（削除したnode_modulesは復元不可） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の起動処理 |
| 目標処理時間 | 数分〜十数分（依存関係の再ダウンロードが必要） |
| メモリ使用量上限 | Node.jsプロセスに依存 |

## 排他制御

- 同一ホスト上での複数同時実行は禁止
- node_modules削除中に他のプロセスがアクセスすると不整合が発生する

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 依存関係インストール開始メッセージ |
| 進捗ログ | 処理中 | 起動メッセージ "Starting Etherpad..." |
| 終了ログ | バッチ終了時 | Etherpadプロセスの出力に依存 |
| エラーログ | エラー発生時 | エラー詳細（標準エラー出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| プロセス起動状態 | 起動失敗時 | 開発者/運用担当者 |
| 処理時間 | 30分以上 | 開発者 |

## 備考

- 本スクリプトは通常の起動には使用しないこと（fastRun.shまたはrun.shを使用）
- node_modulesの削除は不可逆であり、再インストールには時間とネットワーク接続が必要
- 本スクリプトはpnpm run prodではなく、直接node server.tsを実行している
- tsxを使用してTypeScriptを直接実行している（トランスパイル不要）
- root権限チェックの仕組みはrun.shと同様だが、read -rではなくreadを使用している点に注意
