# バッチ設計書 6-start.bat

## 概要

本ドキュメントは、Windows用Etherpad起動バッチファイル`start.bat`の設計仕様を記載したものである。Windows環境でEtherpadサーバーを起動するためのシンプルなバッチファイルである。

### 本バッチの処理概要

Windows環境においてEtherpadを起動するためのバッチファイルである。srcディレクトリに移動し、pnpm run prodコマンドでサーバーを起動する。Windowsとシンボリックリンクの相性問題に対応するため、特定のディレクトリ構造を前提としている。

**業務上の目的・背景**：EtherpadはNode.jsベースのアプリケーションであり、クロスプラットフォームで動作する。しかし、Windowsではシンボリックリンクの扱いが異なるため、Unix系OSとは異なる起動方法が必要となる。特に、`node_modules\ep_etherpad-lite`がシンボリックリンクではなくコピーになる場合があり、これによりNode.jsがモジュールを二重に認識してしまう問題がある。このバッチファイルはこの問題を回避するため、srcディレクトリから直接起動する構成となっている。

**バッチの実行タイミング**：Windows環境でEtherpadサーバーを起動する際に手動で実行する。事前に`installOnWindows.bat`による依存関係のインストールが完了している必要がある。

**主要な処理内容**：
1. srcディレクトリへの移動
2. `pnpm run prod`によるEtherpadサーバーの起動

**前後の処理との関連**：本バッチファイル実行前に、`installOnWindows.bat`を実行して依存関係をインストールしておく必要がある。Admin UIとUIのビルドも事前に完了している必要がある。

**影響範囲**：Etherpadサーバーの起動に影響する。Windows環境でのみ使用される。

## バッチ種別

起動処理 / Windows専用

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windowsオペレーティングシステム |
| Node.js | 適切なバージョンがインストールされていること |
| pnpm | パッケージマネージャーpnpmがインストールされていること |
| 依存関係インストール済み | installOnWindows.batが事前に実行されていること |

### 実行可否判定

- 依存関係がインストールされていない場合、起動時にエラーが発生する
- 本バッチファイル自体には実行可否の判定ロジックはない

## 入力仕様

### 入力パラメータ

本バッチファイルはパラメータを受け付けない。

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | - |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/node_modules | ディレクトリ | 事前にインストールされた依存関係 |
| settings.json | JSON | Etherpad設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | サーバーログ |

### 出力ファイル仕様

本バッチファイルではファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. エコーオフ設定
   └─ バッチコマンドの表示を抑制
2. srcディレクトリへ移動
   └─ cd srcでサーバーコードディレクトリへ移動
3. サーバー起動
   └─ pnpm run prodでEtherpadサーバーを起動
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[echo off設定]
    B --> C[srcディレクトリへ移動]
    C --> D[pnpm run prod実行]
    D --> E[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチは直接的なデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチでは直接操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | ディレクトリエラー | srcディレクトリが存在しない | プロジェクト構成を確認 |
| 非0 | 依存関係エラー | node_modulesが存在しないまたは不完全 | installOnWindows.batを実行 |
| 非0 | 起動エラー | pnpm run prodの実行失敗 | エラーメッセージを確認し対処 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動再実行が必要） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認し、原因を特定する
2. 依存関係エラーの場合は`installOnWindows.bat`を実行する
3. 設定ファイルエラーの場合は`settings.json`を確認する
4. Node.jsとpnpmが正しくインストールされているか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の起動処理 |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | Node.jsプロセスに依存 |

## 排他制御

- 同一ホスト上での複数同時実行は推奨されない
- ポートの競合が発生した場合、後から起動したプロセスは失敗する

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 終了ログ | バッチ終了時 | Etherpadプロセスの出力に依存 |
| エラーログ | エラー発生時 | 起動エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| プロセス起動状態 | 起動失敗時 | 開発者/運用担当者 |

## 備考

- Windowsとシンボリックリンクの相性問題について：
  - Windowsでは`node_modules\ep_etherpad-lite`がシンボリックリンクではなくコピーになることがある
  - この場合、Node.jsが`src\foo.js`と`node_modules\ep_etherpad-lite\foo.js`を別モジュールとして認識してしまう
  - この問題を回避するため、常にsrcディレクトリから起動する構成となっている
- 本バッチファイルは非常にシンプルであり、依存関係のインストールやビルドは含まない
- 事前に`installOnWindows.bat`を実行して環境を整える必要がある
- Unix系OSでは代わりに`run.sh`または`fastRun.sh`を使用すること
