# バッチ設計書 7-installDeps.sh

## 概要

本ドキュメントは、Etherpadの依存関係インストールスクリプト`installDeps.sh`の設計仕様を記載したものである。Node.jsのバージョン確認、依存関係のインストール、設定ファイルの初期化を行う。

### 本バッチの処理概要

Etherpadの実行に必要な依存関係をインストールし、初期設定を行うスクリプトである。Node.jsのバージョンチェック、pnpmによる依存関係インストール、設定ファイルのテンプレートコピー、キャッシュクリアを実行する。

**業務上の目的・背景**：Etherpadは多数のnpmパッケージに依存しており、これらを正しくインストールする必要がある。また、Node.jsのバージョン要件（12.13以上）を満たしていない環境では正常に動作しないため、事前チェックが必要である。このスクリプトは、新規インストール時やアップデート後に必要なセットアップ作業を自動化し、手動での設定ミスを防止する。

**バッチの実行タイミング**：
- Etherpadの初回セットアップ時
- 依存関係のアップデート後
- `run.sh`からの内部呼び出し時
- プラグインの追加・削除後

**主要な処理内容**：
1. pnpmのグローバルインストール確認
2. Node.jsのインストール確認とバージョンチェック
3. 設定ファイル（--settingsオプション）の解析
4. settings.jsonが存在しない場合のテンプレートコピー
5. pnpmによる依存関係のインストール（開発/本番モード対応）
6. ミニファイキャッシュのクリア

**前後の処理との関連**：本スクリプトは`run.sh`、`debugRun.sh`、`cleanRun.sh`から呼び出される。本スクリプトの成功後にEtherpadサーバーが起動される。

**影響範囲**：node_modulesディレクトリに依存関係がインストールされる。settings.jsonが存在しない場合は新規作成される。var/minified*のキャッシュファイルが削除される。

## バッチ種別

インストール処理 / セットアップ / 依存関係管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動または他スクリプトからの呼び出し） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / run.sh等からの自動呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | バージョン12.13以上がインストールされていること |
| npm | pnpmのグローバルインストールに必要 |
| ネットワーク | 依存関係のダウンロードにインターネット接続が必要 |

### 実行可否判定

- Node.jsがインストールされていない場合、エラー終了
- Node.jsのバージョンが12.13未満の場合、エラー終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --settings / -s | 文字列 | No | settings.json | 使用する設定ファイルのパス |
| その他 | 任意 | No | - | 現在は使用されない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| bin/functions.sh | シェルスクリプト | 共通関数・定数定義 |
| settings.json.template | JSON | 設定ファイルテンプレート |

### 環境変数

| 変数名 | 説明 |
|-------|------|
| ETHERPAD_PRODUCTION | 設定時、本番用依存関係のみインストール |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | インストールログ・ステータスメッセージ |
| node_modules | ディレクトリ | インストールされた依存関係 |
| settings.json | JSON | 設定ファイル（テンプレートから作成） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | settings.json（存在しない場合のみ作成） |
| 出力先 | プロジェクトルート |
| 文字コード | UTF-8 |
| 形式 | JSON |

## 処理フロー

### 処理シーケンス

```
1. ディレクトリ移動
   └─ スクリプトの場所からEtherpadベースディレクトリへ移動
2. 共通関数読み込み
   └─ bin/functions.shをソースして共通関数を利用可能にする
3. pnpmインストール確認
   └─ pnpmが存在しない場合、npm install pnpm -gを実行
4. Node.js確認
   └─ nodeコマンドの存在確認、エラー時はインストールを促すメッセージ
5. Node.jsバージョンチェック
   └─ 12.13以上であることを確認
6. 設定ファイルパース
   └─ --settingsまたは-s引数から設定ファイルパスを取得
7. 設定ファイル作成
   └─ settings.jsonが存在しない場合、テンプレートからコピー
8. 依存関係インストール
   └─ ETHERPAD_PRODUCTIONに応じてpnpm installを実行
9. キャッシュクリア
   └─ var/minified*ファイルを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ディレクトリ移動・環境読み込み]
    B --> C{pnpmインストール済み?}
    C -->|No| D[npm install pnpm -g]
    C -->|Yes| E{Node.jsインストール済み?}
    D --> E
    E -->|No| F[エラー終了: Node.jsインストール要求]
    E -->|Yes| G{Node.jsバージョン >= 12.13?}
    G -->|No| H[エラー終了: バージョンエラー]
    G -->|Yes| I[設定ファイルパース]
    I --> J{settings.json存在?}
    J -->|No| K[テンプレートからコピー]
    J -->|Yes| L[依存関係インストール]
    K --> L
    L --> M{ETHERPAD_PRODUCTION設定?}
    M -->|Yes| N[pnpm --recursive i --production]
    M -->|No| O[pnpm --recursive i]
    N --> P[キャッシュクリア]
    O --> P
    P --> Q[正常終了 exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチは直接的なデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチでは直接操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 環境エラー | Node.jsがインストールされていない | Node.jsをインストール |
| 1 | バージョンエラー | Node.jsバージョンが12.13未満 | Node.jsをアップグレード |
| 1 | ネットワークエラー | 依存関係のダウンロード失敗 | ネットワーク接続を確認 |
| 1 | ファイルエラー | settings.json.templateが存在しない | プロジェクトの整合性を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動再実行が必要） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認し、原因を特定する
2. Node.jsのバージョンが要件を満たしているか確認（`node --version`）
3. ネットワーク接続を確認
4. プロキシ環境の場合、npm/pnpmのプロキシ設定を確認
5. ディスク容量を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のセットアップ処理 |
| 目標処理時間 | 初回: 数分、2回目以降: 数十秒（キャッシュ利用時） |
| メモリ使用量上限 | pnpmプロセスに依存 |

## 排他制御

- 同一プロジェクトに対する複数同時実行は推奨されない
- node_modulesへの同時書き込みで不整合が発生する可能性がある

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Copy the settings template to $settings..." |
| 進捗ログ | 依存関係インストール時 | "Installing dependencies...", "Installing dev/production dependencies with pnpm" |
| 終了ログ | キャッシュクリア時 | "Clearing minified cache..." |
| エラーログ | エラー発生時 | "Please install node.js"等 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 10分以上 | 開発者 |
| 終了コード | 0以外 | 開発者/運用担当者 |

## 備考

- pnpmは自動的にグローバルインストールされる（存在しない場合）
- `ETHERPAD_PRODUCTION`環境変数を設定すると、本番用依存関係のみインストールされる（`--production`オプション）
- 設定ファイルのパスは`--settings`または`-s`オプションで変更可能
- キャッシュクリア（var/minified*の削除）により、起動時にファイルが再生成される
- functions.shで定義されている最小Node.jsバージョン: 12.13（REQUIRED_NODE_MAJOR=12, REQUIRED_NODE_MINOR=13）
