# バッチ設計書 8-installOnWindows.bat

## 概要

本ドキュメントは、Windows用依存関係インストールバッチファイル`installOnWindows.bat`の設計仕様を記載したものである。Node.jsの確認、依存関係のインストール、Admin UI/UIのビルド、設定ファイルの初期化を行う。

### 本バッチの処理概要

Windows環境でEtherpadをセットアップするためのバッチファイルである。Node.jsの存在確認、Admin UIとUIのビルド、pnpmによる依存関係のインストール、キャッシュクリア、設定ファイルの作成を実行する。

**業務上の目的・背景**：Windows環境でEtherpadを利用する開発者・運用者向けに、Unix系OSの`installDeps.sh`に相当するセットアップ機能を提供する。Windowsでは シェルスクリプトが直接実行できないため、バッチファイル形式で同等の機能を実装している。Admin UIとUIのビルドも含まれており、Unix版の`run.sh`相当のセットアップがこのバッチファイル一つで完了する。

**バッチの実行タイミング**：
- Windows環境でのEtherpad初回セットアップ時
- 依存関係のアップデート後
- Admin UI/UIの再ビルドが必要な場合

**主要な処理内容**：
1. Etherpadルートディレクトリへの移動
2. Node.jsのインストール確認
3. Admin UIディレクトリでの依存関係インストールとビルド
4. UIディレクトリでの依存関係インストールとビルド
5. ルートディレクトリでの依存関係インストール
6. ミニファイキャッシュのクリア
7. settings.jsonの作成（存在しない場合）

**前後の処理との関連**：本バッチファイル実行後、`start.bat`を使用してEtherpadを起動できる。Node.jsとpnpmが事前にインストールされている必要がある。

**影響範囲**：admin/node_modules、ui/node_modules、node_modulesディレクトリに依存関係がインストールされる。admin/dist、ui/distにビルド成果物が生成される。settings.jsonが存在しない場合は新規作成される。

## バッチ種別

インストール処理 / セットアップ / Windows専用

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windowsオペレーティングシステム |
| Node.js | 適切なバージョンがインストールされていること |
| pnpm | パッケージマネージャーpnpmがインストールされていること |
| ネットワーク | 依存関係のダウンロードにインターネット接続が必要 |

### 実行可否判定

- Node.jsがインストールされていない場合、エラー終了（exit /B 1）

## 入力仕様

### 入力パラメータ

本バッチファイルはパラメータを受け付けない。

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | - |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| settings.json.template | JSON | 設定ファイルテンプレート |
| admin/package.json | JSON | Admin UI依存関係定義 |
| ui/package.json | JSON | UI依存関係定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | インストールログ・ステータスメッセージ |
| node_modules | ディレクトリ | インストールされた依存関係 |
| admin/node_modules | ディレクトリ | Admin UI依存関係 |
| ui/node_modules | ディレクトリ | UI依存関係 |
| admin/dist | ディレクトリ | Admin UIビルド成果物 |
| ui/dist | ディレクトリ | UIビルド成果物 |
| settings.json | JSON | 設定ファイル（テンプレートから作成） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | settings.json（存在しない場合のみ作成） |
| 出力先 | プロジェクトルート |
| 文字コード | UTF-8 |
| 形式 | JSON |

## 処理フロー

### 処理シーケンス

```
1. エコーオフ設定
   └─ バッチコマンドの表示を抑制
2. ルートディレクトリへ移動
   └─ cd /D "%~dp0\.."でプロジェクトルートへ移動
3. Node.js確認
   └─ node -eの実行でNode.jsの存在確認
4. Admin UIセットアップ（adminディレクトリが存在する場合）
   ├─ adminディレクトリへ移動
   ├─ pnpm iで依存関係インストール
   └─ pnpm run buildでビルド
5. UIセットアップ（uiディレクトリが存在する場合）
   ├─ uiディレクトリへ移動
   ├─ pnpm iで依存関係インストール
   └─ pnpm run buildでビルド
6. ルート依存関係インストール
   └─ pnpm iでプロジェクト全体の依存関係インストール
7. キャッシュクリア
   └─ del /S var\minified*でキャッシュファイル削除
8. 設定ファイルセットアップ
   └─ settings.jsonが存在しない場合、テンプレートからコピー
9. 完了メッセージ表示
   └─ "Installed Etherpad! To run Etherpad type start.bat"
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[echo off設定]
    B --> C[ルートディレクトリへ移動]
    C --> D{Node.jsインストール済み?}
    D -->|No| E[エラー終了: Node.jsインストール要求]
    D -->|Yes| F{adminディレクトリ存在?}
    F -->|Yes| G[admin: pnpm i]
    G --> H[admin: pnpm run build]
    F -->|No| I{uiディレクトリ存在?}
    H --> I
    I -->|Yes| J[ui: pnpm i]
    J --> K[ui: pnpm run build]
    I -->|No| L[ルート: pnpm i]
    K --> L
    L --> M[キャッシュクリア]
    M --> N{settings.json存在?}
    N -->|No| O[テンプレートからコピー]
    N -->|Yes| P[完了メッセージ表示]
    O --> P
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチは直接的なデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチでは直接操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 環境エラー | Node.jsがインストールされていない | Node.jsをインストール |
| 1 | インストールエラー | pnpm iの実行失敗 | ネットワーク接続確認、ディスク容量確認 |
| 1 | ビルドエラー | pnpm run buildの実行失敗 | エラーメッセージを確認し対処 |
| 1 | コピーエラー | settings.jsonのコピー失敗 | ファイル権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動再実行が必要） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認し、原因を特定する
2. Node.jsが正しくインストールされているか確認
3. pnpmがインストールされているか確認
4. ネットワーク接続を確認
5. ディスク容量を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のセットアップ処理 |
| 目標処理時間 | 初回: 数分〜十数分、2回目以降: 数分（キャッシュ利用時） |
| メモリ使用量上限 | pnpmプロセス、ビルドプロセスに依存 |

## 排他制御

- 同一プロジェクトに対する複数同時実行は推奨されない
- node_modulesへの同時書き込みで不整合が発生する可能性がある

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Ensure that all dependencies are up to date..." |
| 進捗ログ | キャッシュクリア時 | "Clearing cache..." |
| 進捗ログ | 設定ファイル作成時 | "Setting up settings.json...", "Copying settings.json.template..." |
| 終了ログ | 正常終了時 | "Installed Etherpad! To run Etherpad type start.bat" |
| エラーログ | エラー発生時 | "Please install node.js"等 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 30分以上 | 開発者 |
| 終了コード | 0以外 | 開発者/運用担当者 |

## 備考

- Unix系OSでは代わりに`installDeps.sh`および`run.sh`を使用すること
- Admin UIとUIのビルドが含まれているため、Unix版の`run.sh`相当のセットアップが完了する
- `IF EXIST`によるディレクトリ存在チェックにより、Admin UI/UIが存在しない場合もエラーにならない
- `exit /B 1`によるエラー終了で、エラー発生時に処理が停止する
- 完了後は`start.bat`でEtherpadを起動できる
- `dir`コマンドはデバッグ用にディレクトリ内容を表示している
