# バッチ設計書 9-installLocalPlugins.sh

## 概要

本ドキュメントは、ローカルプラグインインストールスクリプト`installLocalPlugins.sh`の設計仕様を記載したものである。local_pluginsディレクトリに配置されたプラグインをEtherpadにインストールする。

### 本バッチの処理概要

環境変数`ETHERPAD_LOCAL_PLUGINS`で指定されたプラグインを`local_plugins`ディレクトリから検索し、pnpmを使用してワークスペースにインストールするスクリプトである。開発中のプラグインや社内用プラグインをnpmに公開せずに利用できる。

**業務上の目的・背景**：Etherpadプラグイン開発において、npmに公開する前のプラグインをテストしたい場面がある。また、社内用のプライベートプラグインをnpmを経由せずに配布・インストールしたい場合もある。このスクリプトは、local_pluginsディレクトリに配置したプラグインをEtherpadにインストールする機能を提供し、プラグイン開発・テストのワークフローを支援する。

**バッチの実行タイミング**：
- ローカルプラグインの開発・テスト時
- 社内プラグインのインストール時
- CI/CD環境でのカスタムプラグイン適用時

**主要な処理内容**：
1. Etherpadベースディレクトリへの移動
2. 共通関数（functions.sh）の読み込み
3. NODE_ENV / ETHERPAD_LOCAL_PLUGINS_ENVによるpnpmオプションの設定
4. ETHERPAD_LOCAL_PLUGINSの解析（スペース区切り）
5. 各プラグインについて:
   - local_plugins/{プラグイン名}ディレクトリの存在確認
   - pnpm install -wによるワークスペースへのインストール

**前後の処理との関連**：本スクリプト実行前に、プラグインを`local_plugins`ディレクトリに配置しておく必要がある。インストール後、Etherpadを再起動することでプラグインが有効になる。

**影響範囲**：node_modulesにプラグインがインストールされる。package.jsonにプラグインの依存関係が追加される可能性がある。

## バッチ種別

インストール処理 / プラグイン管理 / 開発支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| pnpm | パッケージマネージャーpnpmがインストールされていること |
| local_plugins | プラグインがlocal_pluginsディレクトリに配置されていること |
| ETHERPAD_LOCAL_PLUGINS | 環境変数でプラグイン名が設定されていること |

### 実行可否判定

- `ETHERPAD_LOCAL_PLUGINS`が設定されていない場合、「No local plugins to install.」メッセージを表示して終了
- 指定されたプラグインのディレクトリが存在しない場合、エラー終了

## 入力仕様

### 入力パラメータ

本スクリプトはコマンドライン引数を受け付けない。環境変数で動作を制御する。

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | - |

### 環境変数

| 変数名 | 必須 | 説明 |
|-------|-----|------|
| ETHERPAD_LOCAL_PLUGINS | No | インストールするプラグイン名（スペース区切り） |
| NODE_ENV | No | production設定時、--prodオプションを使用 |
| ETHERPAD_LOCAL_PLUGINS_ENV | No | production/development指定でpnpmオプションを制御 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| bin/functions.sh | シェルスクリプト | 共通関数・定数定義 |
| local_plugins/{プラグイン名} | ディレクトリ | プラグインソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | インストールログ・ステータスメッセージ |
| node_modules | ディレクトリ | インストールされたプラグイン |

### 出力ファイル仕様

本スクリプトでは直接的なファイル出力を行わない。pnpmがpackage.jsonを更新する場合がある。

## 処理フロー

### 処理シーケンス

```
1. 初期設定
   └─ set -euo pipefailでエラー時即座終了、IFSの設定
2. ディレクトリ移動
   └─ スクリプトの場所からEtherpadベースディレクトリへ移動
3. 共通関数読み込み
   └─ bin/functions.shをソースして共通関数を利用可能にする
4. pnpmオプション設定
   ├─ NODE_ENV=productionの場合: --prod
   └─ ETHERPAD_LOCAL_PLUGINS_ENVによるオーバーライド
       ├─ production: --prod
       └─ development: -D
5. プラグインインストール
   ├─ ETHERPAD_LOCAL_PLUGINSが設定されている場合:
   │   ├─ スペースで分割してループ
   │   ├─ 各プラグインのディレクトリ存在確認
   │   ├─ 存在しない場合: エラーメッセージ表示してexit 1
   │   └─ 存在する場合: pnpm install -w {オプション} "local_plugins/{プラグイン}/"
   └─ 設定されていない場合: "No local plugins to install."表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[初期設定 set -euo pipefail]
    B --> C[ディレクトリ移動・環境読み込み]
    C --> D[pnpmオプション設定]
    D --> E{ETHERPAD_LOCAL_PLUGINS設定?}
    E -->|No| F["'No local plugins to install.'表示"]
    E -->|Yes| G[プラグインリスト分割]
    F --> N[正常終了]
    G --> H{次のプラグイン}
    H -->|あり| I[プラグイン名をtrim]
    I --> J{local_plugins/プラグインディレクトリ存在?}
    J -->|No| K[エラーメッセージ表示]
    K --> L[exit 1]
    J -->|Yes| M["pnpm install -w 実行"]
    M --> H
    H -->|なし| N
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチは直接的なデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本バッチでは直接操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ディレクトリエラー | local_plugins/{プラグイン}が存在しない | プラグインを正しいディレクトリに配置 |
| 非0 | インストールエラー | pnpm installの実行失敗 | プラグインのpackage.jsonを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動再実行が必要） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認し、原因を特定する
2. プラグインディレクトリが正しく配置されているか確認
3. プラグインのpackage.jsonが正しいか確認
4. 環境変数`ETHERPAD_LOCAL_PLUGINS`の値を確認（スペース区切り）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プラグイン数に依存（通常1〜数個） |
| 目標処理時間 | プラグインあたり数秒〜数十秒 |
| メモリ使用量上限 | pnpmプロセスに依存 |

## 排他制御

- 同一プロジェクトに対する複数同時実行は推奨されない
- pnpmのロック機構により同時実行時はエラーになる可能性がある

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | プラグインインストール時 | "Installing plugin: '{プラグイン名}'" |
| 完了ログ | インストール完了時 | "No local plugins to install."（プラグインなし時） |
| エラーログ | エラー発生時 | "Error. Directory 'local_plugins/{プラグイン}' for local plugin '{プラグイン}' missing" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 開発者 |

## 備考

- `set -euo pipefail`により、エラー発生時に即座にスクリプトが終了する
- trim関数で前後の空白を除去してからプラグイン名を処理している
- pnpmの`-w`オプションはワークスペースルートへのインストールを意味する
- ETHERPAD_LOCAL_PLUGINS_ENVはNODE_ENVよりも優先される（より細かい制御が可能）
- developmentモード（-D）では開発依存関係としてインストールされる
- typo: 「local plugings」は「local plugins」の誤り（line 50）
