---
generated_at: 2026-02-10 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-run.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：具体的な数値の根拠なし
  2. **該当なし**：-
  3. **該当なし**：-

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/run.sh` - メインスクリプト
- E-02: `bin/functions.sh` - 共通関数定義
- E-03: `bin/installDeps.sh` - 依存関係インストールスクリプト
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Etherpadベースディレクトリへの移動処理 | E-01 (line 4-5) | ○ |
| C-02 | functions.shの読み込み処理 | E-01 (line 8) | ○ |
| C-03 | --root引数によるroot権限チェックスキップ | E-01 (line 11-15) | ○ |
| C-04 | root権限実行時の確認メッセージ処理 | E-01 (line 18-27) | ○ |
| C-05 | installDeps.shの呼び出し | E-01 (line 30) | ○ |
| C-06 | NODE_ENVによる開発/本番環境の分岐 | E-01 (line 34) | ○ |
| C-07 | Admin UIのビルド（pnpm run build） | E-01 (line 38) | ○ |
| C-08 | UIのビルド（pnpm run build） | E-01 (line 39) | ○ |
| C-09 | pnpm run prodによるサーバー起動 | E-01 (line 48) | ○ |
| C-10 | Node.js 12.13以上が必要 | E-02 (line 2-3) | ○ |
| C-11 | pnpmパッケージマネージャーの使用 | E-01 (line 38, 39, 48), E-03 (line 39, 42) | ○ |
| C-12 | バッチ一覧での説明内容 | E-04 (No.1) | ○ |
| C-13 | safeRun.shからの呼び出し | E-01, 別途safeRun.sh参照 | ○ |
| C-14 | exit 1によるエラー終了 | E-01 (line 26, 30) | ○ |
| C-15 | 本番環境でのAdmin UIビルドスキップ | E-01 (line 40-42) | ○ |
| C-16 | 確認フレーズ「Etherpad rocks my socks」 | E-01 (line 26) | ○ |
| C-17 | execによるプロセス置換起動 | E-01 (line 48) | ○ |
| C-18 | 目標処理時間（初回数分、2回目以降数十秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: 処理時間に関する具体的な測定データや仕様書がない
  - 候補：パフォーマンステスト結果 / 運用実績データ / 設計時の目標値ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理内容はソースコードから明確に確認可能
- 1: 中リスク - パフォーマンス関連の数値は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] root権限チェックのセキュリティ要件が現行ポリシーと一致しているか
- [ ] Admin UI/UIビルドの成功判定基準が明確か
- [ ] 処理時間の目標値が運用要件と一致しているか
